/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal.xmlimpl;

import org.w3c.dom.Node;
import sun.org.mozilla.javascript.internal.Context;
import sun.org.mozilla.javascript.internal.ScriptRuntime;
import sun.org.mozilla.javascript.internal.Scriptable;
import sun.org.mozilla.javascript.internal.Undefined;
import sun.org.mozilla.javascript.internal.xml.XMLObject;
import sun.org.mozilla.javascript.internal.xmlimpl.Namespace;
import sun.org.mozilla.javascript.internal.xmlimpl.QName;
import sun.org.mozilla.javascript.internal.xmlimpl.XMLLibImpl;
import sun.org.mozilla.javascript.internal.xmlimpl.XMLList;
import sun.org.mozilla.javascript.internal.xmlimpl.XMLName;
import sun.org.mozilla.javascript.internal.xmlimpl.XMLObjectImpl;
import sun.org.mozilla.javascript.internal.xmlimpl.XmlNode;

class XML
extends XMLObjectImpl {
    static final long serialVersionUID = -630969919086449092L;
    private XmlNode node;

    XML(XMLLibImpl xMLLibImpl, Scriptable scriptable, XMLObject xMLObject, XmlNode xmlNode) {
        super(xMLLibImpl, scriptable, xMLObject);
        this.initialize(xmlNode);
    }

    void initialize(XmlNode xmlNode) {
        this.node = xmlNode;
        this.node.setXml(this);
    }

    @Override
    final XML getXML() {
        return this;
    }

    void replaceWith(XML xML) {
        if (this.node.parent() != null) {
            this.node.replaceWith(xML.node);
        } else {
            this.initialize(xML.node);
        }
    }

    XML makeXmlFromString(XMLName xMLName, String string) {
        try {
            return this.newTextElementXML(this.node, xMLName.toQname(), string);
        }
        catch (Exception exception) {
            throw ScriptRuntime.typeError(exception.getMessage());
        }
    }

    XmlNode getAnnotation() {
        return this.node;
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        if (n == 0) {
            return this;
        }
        return Scriptable.NOT_FOUND;
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        return n == 0;
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        throw ScriptRuntime.typeError("Assignment to indexed XML is not allowed");
    }

    @Override
    public Object[] getIds() {
        if (this.isPrototype()) {
            return new Object[0];
        }
        return new Object[]{0};
    }

    @Override
    public void delete(int n) {
        if (n == 0) {
            this.remove();
        }
    }

    @Override
    boolean hasXMLProperty(XMLName xMLName) {
        if (this.isPrototype()) {
            return this.getMethod(xMLName.localName()) != NOT_FOUND;
        }
        return this.getPropertyList(xMLName).length() > 0 || this.getMethod(xMLName.localName()) != NOT_FOUND;
    }

    @Override
    Object getXMLProperty(XMLName xMLName) {
        if (this.isPrototype()) {
            return this.getMethod(xMLName.localName());
        }
        return this.getPropertyList(xMLName);
    }

    XmlNode.QName getNodeQname() {
        return this.node.getQname();
    }

    XML[] getChildren() {
        if (!this.isElement()) {
            return null;
        }
        XmlNode[] xmlNodeArray = this.node.getMatchingChildren(XmlNode.Filter.TRUE);
        XML[] xMLArray = new XML[xmlNodeArray.length];
        for (int i = 0; i < xMLArray.length; ++i) {
            xMLArray[i] = this.toXML(xmlNodeArray[i]);
        }
        return xMLArray;
    }

    XML[] getAttributes() {
        XmlNode[] xmlNodeArray = this.node.getAttributes();
        XML[] xMLArray = new XML[xmlNodeArray.length];
        for (int i = 0; i < xMLArray.length; ++i) {
            xMLArray[i] = this.toXML(xmlNodeArray[i]);
        }
        return xMLArray;
    }

    XMLList getPropertyList(XMLName xMLName) {
        return xMLName.getMyValueOn(this);
    }

    @Override
    void deleteXMLProperty(XMLName xMLName) {
        XMLList xMLList = this.getPropertyList(xMLName);
        for (int i = 0; i < xMLList.length(); ++i) {
            xMLList.item((int)i).node.deleteMe();
        }
    }

    @Override
    void putXMLProperty(XMLName xMLName, Object object) {
        if (!this.isPrototype()) {
            xMLName.setMyValueOn(this, object);
        }
    }

    @Override
    boolean hasOwnProperty(XMLName xMLName) {
        String string;
        boolean bl = false;
        bl = this.isPrototype() ? 0 != this.findPrototypeId(string = xMLName.localName()) : this.getPropertyList(xMLName).length() > 0;
        return bl;
    }

    @Override
    protected Object jsConstructor(Context context, boolean bl, Object[] objectArray) {
        if (objectArray.length == 0 || objectArray[0] == null || objectArray[0] == Undefined.instance) {
            objectArray = new Object[]{""};
        }
        XML xML = this.ecmaToXml(objectArray[0]);
        if (bl) {
            return xML.copy();
        }
        return xML;
    }

    @Override
    public Scriptable getExtraMethodSource(Context context) {
        if (this.hasSimpleContent()) {
            String string = this.toString();
            return ScriptRuntime.toObjectOrNull(context, string);
        }
        return null;
    }

    void removeChild(int n) {
        this.node.removeChild(n);
    }

    @Override
    void normalize() {
        this.node.normalize();
    }

    private XML toXML(XmlNode xmlNode) {
        if (xmlNode.getXml() == null) {
            xmlNode.setXml(this.newXML(xmlNode));
        }
        return xmlNode.getXml();
    }

    void setAttribute(XMLName xMLName, Object object) {
        if (!this.isElement()) {
            throw new IllegalStateException("Can only set attributes on elements.");
        }
        if (xMLName.uri() == null && xMLName.localName().equals("*")) {
            throw ScriptRuntime.typeError("@* assignment not supported.");
        }
        this.node.setAttribute(xMLName.toQname(), ScriptRuntime.toString(object));
    }

    void remove() {
        this.node.deleteMe();
    }

    @Override
    void addMatches(XMLList xMLList, XMLName xMLName) {
        xMLName.addMatches(xMLList, this);
    }

    @Override
    XMLList elements(XMLName xMLName) {
        XMLList xMLList = this.newXMLList();
        xMLList.setTargets(this, xMLName.toQname());
        XmlNode[] xmlNodeArray = this.node.getMatchingChildren(XmlNode.Filter.ELEMENT);
        for (int i = 0; i < xmlNodeArray.length; ++i) {
            if (!xMLName.matches(this.toXML(xmlNodeArray[i]))) continue;
            xMLList.addToList(this.toXML(xmlNodeArray[i]));
        }
        return xMLList;
    }

    @Override
    XMLList child(XMLName xMLName) {
        XMLList xMLList = this.newXMLList();
        XmlNode[] xmlNodeArray = this.node.getMatchingChildren(XmlNode.Filter.ELEMENT);
        for (int i = 0; i < xmlNodeArray.length; ++i) {
            if (!xMLName.matchesElement(xmlNodeArray[i].getQname())) continue;
            xMLList.addToList(this.toXML(xmlNodeArray[i]));
        }
        xMLList.setTargets(this, xMLName.toQname());
        return xMLList;
    }

    XML replace(XMLName xMLName, Object object) {
        this.putXMLProperty(xMLName, object);
        return this;
    }

    @Override
    XMLList children() {
        XMLList xMLList = this.newXMLList();
        XMLName xMLName = XMLName.formStar();
        xMLList.setTargets(this, xMLName.toQname());
        XmlNode[] xmlNodeArray = this.node.getMatchingChildren(XmlNode.Filter.TRUE);
        for (int i = 0; i < xmlNodeArray.length; ++i) {
            xMLList.addToList(this.toXML(xmlNodeArray[i]));
        }
        return xMLList;
    }

    @Override
    XMLList child(int n) {
        XMLList xMLList = this.newXMLList();
        xMLList.setTargets(this, null);
        if (n >= 0 && n < this.node.getChildCount()) {
            xMLList.addToList(this.getXmlChild(n));
        }
        return xMLList;
    }

    XML getXmlChild(int n) {
        XmlNode xmlNode = this.node.getChild(n);
        if (xmlNode.getXml() == null) {
            xmlNode.setXml(this.newXML(xmlNode));
        }
        return xmlNode.getXml();
    }

    int childIndex() {
        return this.node.getChildIndex();
    }

    @Override
    boolean contains(Object object) {
        if (object instanceof XML) {
            return this.equivalentXml(object);
        }
        return false;
    }

    @Override
    boolean equivalentXml(Object object) {
        boolean bl = false;
        if (object instanceof XML) {
            return this.node.toXmlString(this.getProcessor()).equals(((XML)object).node.toXmlString(this.getProcessor()));
        }
        if (object instanceof XMLList) {
            XMLList xMLList = (XMLList)object;
            if (xMLList.length() == 1) {
                bl = this.equivalentXml(xMLList.getXML());
            }
        } else if (this.hasSimpleContent()) {
            String string = ScriptRuntime.toString(object);
            bl = this.toString().equals(string);
        }
        return bl;
    }

    @Override
    XMLObjectImpl copy() {
        return this.newXML(this.node.copy());
    }

    @Override
    boolean hasSimpleContent() {
        if (this.isComment() || this.isProcessingInstruction()) {
            return false;
        }
        if (this.isText() || this.node.isAttributeType()) {
            return true;
        }
        return !this.node.hasChildElement();
    }

    @Override
    boolean hasComplexContent() {
        return !this.hasSimpleContent();
    }

    @Override
    int length() {
        return 1;
    }

    boolean is(XML xML) {
        return this.node.isSameNode(xML.node);
    }

    Object nodeKind() {
        return this.ecmaClass();
    }

    @Override
    Object parent() {
        XmlNode xmlNode = this.node.parent();
        if (xmlNode == null) {
            return null;
        }
        return this.newXML(this.node.parent());
    }

    @Override
    boolean propertyIsEnumerable(Object object) {
        double d;
        boolean bl = object instanceof Integer ? (Integer)object == 0 : (object instanceof Number ? (d = ((Number)object).doubleValue()) == 0.0 && 1.0 / d > 0.0 : ScriptRuntime.toString(object).equals("0"));
        return bl;
    }

    @Override
    Object valueOf() {
        return this;
    }

    @Override
    XMLList comments() {
        XMLList xMLList = this.newXMLList();
        this.node.addMatchingChildren(xMLList, XmlNode.Filter.COMMENT);
        return xMLList;
    }

    @Override
    XMLList text() {
        XMLList xMLList = this.newXMLList();
        this.node.addMatchingChildren(xMLList, XmlNode.Filter.TEXT);
        return xMLList;
    }

    @Override
    XMLList processingInstructions(XMLName xMLName) {
        XMLList xMLList = this.newXMLList();
        this.node.addMatchingChildren(xMLList, XmlNode.Filter.PROCESSING_INSTRUCTION(xMLName));
        return xMLList;
    }

    private XmlNode[] getNodesForInsert(Object object) {
        if (object instanceof XML) {
            return new XmlNode[]{((XML)object).node};
        }
        if (object instanceof XMLList) {
            XMLList xMLList = (XMLList)object;
            XmlNode[] xmlNodeArray = new XmlNode[xMLList.length()];
            for (int i = 0; i < xMLList.length(); ++i) {
                xmlNodeArray[i] = xMLList.item((int)i).node;
            }
            return xmlNodeArray;
        }
        return new XmlNode[]{XmlNode.createText(this.getProcessor(), ScriptRuntime.toString(object))};
    }

    XML replace(int n, Object object) {
        XMLList xMLList = this.child(n);
        if (xMLList.length() > 0) {
            XML xML = xMLList.item(0);
            this.insertChildAfter(xML, object);
            this.removeChild(n);
        }
        return this;
    }

    XML prependChild(Object object) {
        if (this.node.isParentType()) {
            this.node.insertChildrenAt(0, this.getNodesForInsert(object));
        }
        return this;
    }

    XML appendChild(Object object) {
        if (this.node.isParentType()) {
            XmlNode[] xmlNodeArray = this.getNodesForInsert(object);
            this.node.insertChildrenAt(this.node.getChildCount(), xmlNodeArray);
        }
        return this;
    }

    private int getChildIndexOf(XML xML) {
        for (int i = 0; i < this.node.getChildCount(); ++i) {
            if (!this.node.getChild(i).isSameNode(xML.node)) continue;
            return i;
        }
        return -1;
    }

    XML insertChildBefore(XML xML, Object object) {
        if (xML == null) {
            this.appendChild(object);
        } else {
            XmlNode[] xmlNodeArray = this.getNodesForInsert(object);
            int n = this.getChildIndexOf(xML);
            if (n != -1) {
                this.node.insertChildrenAt(n, xmlNodeArray);
            }
        }
        return this;
    }

    XML insertChildAfter(XML xML, Object object) {
        if (xML == null) {
            this.prependChild(object);
        } else {
            XmlNode[] xmlNodeArray = this.getNodesForInsert(object);
            int n = this.getChildIndexOf(xML);
            if (n != -1) {
                this.node.insertChildrenAt(n + 1, xmlNodeArray);
            }
        }
        return this;
    }

    XML setChildren(Object object) {
        if (!this.isElement()) {
            return this;
        }
        while (this.node.getChildCount() > 0) {
            this.node.removeChild(0);
        }
        XmlNode[] xmlNodeArray = this.getNodesForInsert(object);
        this.node.insertChildrenAt(0, xmlNodeArray);
        return this;
    }

    private void addInScopeNamespace(Namespace namespace) {
        if (!this.isElement()) {
            return;
        }
        if (namespace.prefix() != null) {
            if (namespace.prefix().length() == 0 && namespace.uri().length() == 0) {
                return;
            }
            if (this.node.getQname().getNamespace().getPrefix().equals(namespace.prefix())) {
                this.node.invalidateNamespacePrefix();
            }
        } else {
            return;
        }
        this.node.declareNamespace(namespace.prefix(), namespace.uri());
    }

    Namespace[] inScopeNamespaces() {
        XmlNode.Namespace[] namespaceArray = this.node.getInScopeNamespaces();
        return this.createNamespaces(namespaceArray);
    }

    private XmlNode.Namespace adapt(Namespace namespace) {
        if (namespace.prefix() == null) {
            return XmlNode.Namespace.create(namespace.uri());
        }
        return XmlNode.Namespace.create(namespace.prefix(), namespace.uri());
    }

    XML removeNamespace(Namespace namespace) {
        if (!this.isElement()) {
            return this;
        }
        this.node.removeNamespace(this.adapt(namespace));
        return this;
    }

    XML addNamespace(Namespace namespace) {
        this.addInScopeNamespace(namespace);
        return this;
    }

    QName name() {
        if (this.isText() || this.isComment()) {
            return null;
        }
        if (this.isProcessingInstruction()) {
            return this.newQName("", this.node.getQname().getLocalName(), null);
        }
        return this.newQName(this.node.getQname());
    }

    Namespace[] namespaceDeclarations() {
        XmlNode.Namespace[] namespaceArray = this.node.getNamespaceDeclarations();
        return this.createNamespaces(namespaceArray);
    }

    Namespace namespace(String string) {
        if (string == null) {
            return this.createNamespace(this.node.getNamespaceDeclaration());
        }
        return this.createNamespace(this.node.getNamespaceDeclaration(string));
    }

    String localName() {
        if (this.name() == null) {
            return null;
        }
        return this.name().localName();
    }

    void setLocalName(String string) {
        if (this.isText() || this.isComment()) {
            return;
        }
        this.node.setLocalName(string);
    }

    void setName(QName qName) {
        if (this.isText() || this.isComment()) {
            return;
        }
        if (this.isProcessingInstruction()) {
            this.node.setLocalName(qName.localName());
            return;
        }
        this.node.renameNode(qName.getDelegate());
    }

    void setNamespace(Namespace namespace) {
        if (this.isText() || this.isComment() || this.isProcessingInstruction()) {
            return;
        }
        this.setName(this.newQName(namespace.uri(), this.localName(), namespace.prefix()));
    }

    final String ecmaClass() {
        if (this.node.isTextType()) {
            return "text";
        }
        if (this.node.isAttributeType()) {
            return "attribute";
        }
        if (this.node.isCommentType()) {
            return "comment";
        }
        if (this.node.isProcessingInstructionType()) {
            return "processing-instruction";
        }
        if (this.node.isElementType()) {
            return "element";
        }
        throw new RuntimeException("Unrecognized type: " + this.node);
    }

    @Override
    public String getClassName() {
        return "XML";
    }

    private String ecmaValue() {
        return this.node.ecmaValue();
    }

    private String ecmaToString() {
        if (this.isAttribute() || this.isText()) {
            return this.ecmaValue();
        }
        if (this.hasSimpleContent()) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.node.getChildCount(); ++i) {
                XmlNode xmlNode = this.node.getChild(i);
                if (xmlNode.isProcessingInstructionType() || xmlNode.isCommentType()) continue;
                XML xML = new XML(this.getLib(), this.getParentScope(), (XMLObject)this.getPrototype(), xmlNode);
                stringBuffer.append(xML.toString());
            }
            return stringBuffer.toString();
        }
        return this.toXMLString();
    }

    @Override
    public String toString() {
        return this.ecmaToString();
    }

    @Override
    String toSource(int n) {
        return this.toXMLString();
    }

    @Override
    String toXMLString() {
        return this.node.ecmaToXMLString(this.getProcessor());
    }

    final boolean isAttribute() {
        return this.node.isAttributeType();
    }

    final boolean isComment() {
        return this.node.isCommentType();
    }

    final boolean isText() {
        return this.node.isTextType();
    }

    final boolean isElement() {
        return this.node.isElementType();
    }

    final boolean isProcessingInstruction() {
        return this.node.isProcessingInstructionType();
    }

    Node toDomNode() {
        return this.node.toDomNode();
    }
}

