/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.document.invoice;

import com.bysquare.document.BysquareDocument;
import com.bysquare.document.InvalidValueException;
import com.bysquare.document.Verify;
import com.bysquare.document.invoice.CustomerParty;
import com.bysquare.document.invoice.MonetarySummary;
import com.bysquare.document.invoice.PaymentMean;
import com.bysquare.document.invoice.SingleInvoiceLine;
import com.bysquare.document.invoice.SupplierParty;
import com.bysquare.document.invoice.TaxCategorySummaries;
import com.bysquare.xml.helper.PaymentMeansConverter;
import java.util.Date;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.convert.Convert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Order(elements={"InvoiceID", "IssueDate", "TaxPointDate", "OrderID", "DeliveryNoteID", "LocalCurrencyCode", "ForeignCurrencyCode", "CurrRate", "ReferenceCurrRate", "SupplierParty", "CustomerParty", "NumberOfInvoiceLines", "InvoiceDescription", "SingleInvoiceLine", "TaxCategorySummaries", "MonetarySummary", "PaymentMeans"})
@Root(name="Invoice", strict=false)
public abstract class InvoiceBase
extends BysquareDocument {
    protected String invoiceID;
    @Element(name="IssueDate", required=false)
    protected Date issueDate;
    @Element(name="TaxPointDate", required=false)
    protected Date taxPointDate;
    protected String orderID;
    protected String deliveryNoteID;
    protected String localCurrencyCode;
    protected String foreignCurrencyCode;
    @Element(name="CurrRate", required=false)
    protected Double currRate;
    @Element(name="ReferenceCurrRate", required=false)
    protected Double referenceCurrRate;
    protected SupplierParty supplierParty;
    protected CustomerParty customerParty;
    @Element(name="NumberOfInvoiceLines", required=false)
    protected Integer numberOfInvoiceLines;
    protected String invoiceDescription;
    protected SingleInvoiceLine singleInvoiceLine;
    protected TaxCategorySummaries taxCategorySummaries;
    protected MonetarySummary monetarySummary;
    @Element(name="PaymentMeans", required=false)
    @Convert(value=PaymentMeansConverter.class)
    protected List<PaymentMean> paymentMeans;

    @Element(name="InvoiceID", required=false)
    public String getInvoiceID() {
        return this.invoiceID;
    }

    @Element(name="InvoiceID", required=false)
    public void setInvoiceID(String string) {
        this.invoiceID = Verify.trim(string);
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public void setIssueDate(Date date) {
        this.issueDate = date;
    }

    public Date getTaxPointDate() {
        return this.taxPointDate;
    }

    public void setTaxPointDate(Date date) {
        this.taxPointDate = date;
    }

    @Element(name="OrderID", required=false)
    public String getOrderID() {
        return this.orderID;
    }

    @Element(name="OrderID", required=false)
    public void setOrderID(String string) {
        this.orderID = Verify.trim(string);
    }

    @Element(name="DeliveryNoteID", required=false)
    public String getDeliveryNoteID() {
        return this.deliveryNoteID;
    }

    @Element(name="DeliveryNoteID", required=false)
    public void setDeliveryNoteID(String string) {
        this.deliveryNoteID = Verify.trim(string);
    }

    @Element(name="LocalCurrencyCode", required=false)
    public String getLocalCurrencyCode() {
        return this.localCurrencyCode;
    }

    @Element(name="LocalCurrencyCode", required=false)
    public void setLocalCurrencyCode(String string) {
        this.localCurrencyCode = Verify.trimAllToUpperCase(string);
    }

    @Element(name="ForeignCurrencyCode", required=false)
    public String getForeignCurrencyCode() {
        return this.foreignCurrencyCode;
    }

    @Element(name="ForeignCurrencyCode", required=false)
    public void setForeignCurrencyCode(String string) {
        this.foreignCurrencyCode = Verify.trimAllToUpperCase(string);
    }

    public Double getCurrRate() {
        return this.currRate;
    }

    public void setCurrRate(Double d2) {
        this.currRate = d2;
    }

    public Double getReferenceCurrRate() {
        return this.referenceCurrRate;
    }

    public void setReferenceCurrRate(Double d2) {
        this.referenceCurrRate = d2;
    }

    @Element(name="SupplierParty", required=false)
    public SupplierParty getSupplierParty() {
        if (this.supplierParty == null) {
            this.supplierParty = new SupplierParty();
        }
        return this.supplierParty;
    }

    @Element(name="SupplierParty", required=false)
    public void setSupplierParty(SupplierParty supplierParty) {
        this.supplierParty = supplierParty;
    }

    @Element(name="CustomerParty", required=false)
    public CustomerParty getCustomerParty() {
        if (this.customerParty == null) {
            this.customerParty = new CustomerParty();
        }
        return this.customerParty;
    }

    @Element(name="CustomerParty", required=false)
    public void setCustomerParty(CustomerParty customerParty) {
        this.customerParty = customerParty;
    }

    public Integer getNumberOfInvoiceLines() {
        return this.numberOfInvoiceLines;
    }

    public void setNumberOfInvoiceLines(Integer n2) {
        if (n2 != null && n2 < 0) {
            n2 = -n2.intValue();
        }
        this.numberOfInvoiceLines = n2;
    }

    @Element(name="InvoiceDescription", required=false)
    public String getInvoiceDescription() {
        return this.invoiceDescription;
    }

    @Element(name="InvoiceDescription", required=false)
    public void setInvoiceDescription(String string) {
        this.invoiceDescription = Verify.trim(string);
    }

    @Element(name="SingleInvoiceLine", required=false)
    public SingleInvoiceLine getSingleInvoiceLine() {
        return this.singleInvoiceLine;
    }

    @Element(name="SingleInvoiceLine", required=false)
    public void setSingleInvoiceLine(SingleInvoiceLine singleInvoiceLine) {
        if (this.singleInvoiceLine != null) {
            this.singleInvoiceLine.invoice = null;
        }
        if ((this.singleInvoiceLine = singleInvoiceLine) != null) {
            this.singleInvoiceLine.invoice = this;
        }
    }

    @Element(name="TaxCategorySummaries", required=false)
    public TaxCategorySummaries getTaxCategorySummaries() {
        if (this.taxCategorySummaries == null) {
            this.taxCategorySummaries = new TaxCategorySummaries();
        }
        return this.taxCategorySummaries;
    }

    @Element(name="TaxCategorySummaries", required=false)
    public void setTaxCategorySummaries(TaxCategorySummaries taxCategorySummaries) {
        this.taxCategorySummaries = taxCategorySummaries;
    }

    @Element(name="MonetarySummary", required=false)
    public MonetarySummary getMonetarySummary() {
        if (this.monetarySummary == null) {
            this.monetarySummary = new MonetarySummary();
            this.monetarySummary.invoice = this;
        }
        return this.monetarySummary;
    }

    @Element(name="MonetarySummary", required=false)
    public void setMonetarySummary(MonetarySummary monetarySummary) {
        if (this.monetarySummary != null) {
            this.monetarySummary.invoice = null;
        }
        if ((this.monetarySummary = monetarySummary) != null) {
            this.monetarySummary.invoice = this;
        }
    }

    public List<PaymentMean> getPaymentMeans() {
        return this.paymentMeans;
    }

    public void setPaymentMeans(List<PaymentMean> list) {
        this.paymentMeans = list;
    }

    @Override
    public void verify() throws InvalidValueException {
        Verify.notNull("InvoiceID", this.getInvoiceID());
        Verify.notNull("IssueDate", this.getIssueDate());
        Verify.notNullAndMatch("LocalCurrencyCode", this.getLocalCurrencyCode(), "[A-Z]{3}");
        if (this.getForeignCurrencyCode() != null && this.getForeignCurrencyCode().length() != 0 || this.getCurrRate() != null || this.getReferenceCurrRate() != null) {
            Verify.notNullAndMatch("ForeignCurrencyCode", this.getForeignCurrencyCode(), "[A-Z]{3}");
            Verify.notNull("CurrRate", this.getCurrRate());
            Verify.notNull("ReferenceCurrRate", this.getReferenceCurrRate());
        }
        this.getSupplierParty().verify();
        this.getCustomerParty().verify();
        Verify.choice("NumberOfInvoiceLines SingleInvoiceLine", this.getNumberOfInvoiceLines(), this.getSingleInvoiceLine());
        Verify.nullOrVerify(this.getSingleInvoiceLine());
        Verify.nullOrPositive("NumberOfInvoiceLines", this.getNumberOfInvoiceLines());
        Verify.notNullAndVerify("TaxCategorySummaries", this.getTaxCategorySummaries());
        this.getMonetarySummary().verify();
        if (this.getPaymentMeans() != null) {
            Verify.enumList("PaymentMeans", this.getPaymentMeans(), PaymentMean.class);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof InvoiceBase)) {
            return false;
        }
        InvoiceBase invoiceBase = (InvoiceBase)object;
        if (this.currRate == null ? invoiceBase.currRate != null : !this.currRate.equals(invoiceBase.currRate)) {
            return false;
        }
        if (!this.getCustomerParty().equals(invoiceBase.getCustomerParty())) {
            return false;
        }
        if (this.deliveryNoteID == null ? invoiceBase.deliveryNoteID != null : !this.deliveryNoteID.equals(invoiceBase.deliveryNoteID)) {
            return false;
        }
        if (this.foreignCurrencyCode == null ? invoiceBase.foreignCurrencyCode != null : !this.foreignCurrencyCode.equals(invoiceBase.foreignCurrencyCode)) {
            return false;
        }
        if (this.invoiceDescription == null ? invoiceBase.invoiceDescription != null : !this.invoiceDescription.equals(invoiceBase.invoiceDescription)) {
            return false;
        }
        if (this.invoiceID == null ? invoiceBase.invoiceID != null : !this.invoiceID.equals(invoiceBase.invoiceID)) {
            return false;
        }
        if (this.issueDate == null ? invoiceBase.issueDate != null : !this.issueDate.equals(invoiceBase.issueDate)) {
            return false;
        }
        if (this.localCurrencyCode == null ? invoiceBase.localCurrencyCode != null : !this.localCurrencyCode.equals(invoiceBase.localCurrencyCode)) {
            return false;
        }
        if (!this.getMonetarySummary().equals(invoiceBase.getMonetarySummary())) {
            return false;
        }
        if (this.numberOfInvoiceLines == null ? invoiceBase.numberOfInvoiceLines != null : !this.numberOfInvoiceLines.equals(invoiceBase.numberOfInvoiceLines)) {
            return false;
        }
        if (this.orderID == null ? invoiceBase.orderID != null : !this.orderID.equals(invoiceBase.orderID)) {
            return false;
        }
        if (this.paymentMeans == null ? invoiceBase.paymentMeans != null : !this.paymentMeans.equals(invoiceBase.paymentMeans)) {
            return false;
        }
        if (this.referenceCurrRate == null ? invoiceBase.referenceCurrRate != null : !this.referenceCurrRate.equals(invoiceBase.referenceCurrRate)) {
            return false;
        }
        if (this.singleInvoiceLine == null ? invoiceBase.singleInvoiceLine != null : !this.singleInvoiceLine.equals(invoiceBase.singleInvoiceLine)) {
            return false;
        }
        if (!this.getSupplierParty().equals(invoiceBase.getSupplierParty())) {
            return false;
        }
        if (!this.getTaxCategorySummaries().equals(invoiceBase.getTaxCategorySummaries())) {
            return false;
        }
        return !(this.taxPointDate == null ? invoiceBase.taxPointDate != null : !this.taxPointDate.equals(invoiceBase.taxPointDate));
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.currRate == null ? 0 : this.currRate.hashCode());
        n2 = 31 * n2 + (this.customerParty == null ? 0 : this.customerParty.hashCode());
        n2 = 31 * n2 + (this.deliveryNoteID == null ? 0 : this.deliveryNoteID.hashCode());
        n2 = 31 * n2 + (this.foreignCurrencyCode == null ? 0 : this.foreignCurrencyCode.hashCode());
        n2 = 31 * n2 + (this.invoiceDescription == null ? 0 : this.invoiceDescription.hashCode());
        n2 = 31 * n2 + (this.invoiceID == null ? 0 : this.invoiceID.hashCode());
        n2 = 31 * n2 + (this.issueDate == null ? 0 : this.issueDate.hashCode());
        n2 = 31 * n2 + (this.localCurrencyCode == null ? 0 : this.localCurrencyCode.hashCode());
        n2 = 31 * n2 + this.getMonetarySummary().hashCode();
        n2 = 31 * n2 + (this.numberOfInvoiceLines == null ? 0 : this.numberOfInvoiceLines.hashCode());
        n2 = 31 * n2 + (this.orderID == null ? 0 : this.orderID.hashCode());
        n2 = 31 * n2 + (this.paymentMeans == null ? 0 : this.paymentMeans.hashCode());
        n2 = 31 * n2 + (this.referenceCurrRate == null ? 0 : this.referenceCurrRate.hashCode());
        n2 = 31 * n2 + (this.singleInvoiceLine == null ? 0 : this.singleInvoiceLine.hashCode());
        n2 = 31 * n2 + this.getSupplierParty().hashCode();
        n2 = 31 * n2 + this.getTaxCategorySummaries().hashCode();
        n2 = 31 * n2 + (this.taxPointDate == null ? 0 : this.taxPointDate.hashCode());
        return n2;
    }
}

