/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.document.invoiceitems;

import com.bysquare.document.IVerifiable;
import com.bysquare.document.InvalidValueException;
import com.bysquare.document.Verify;
import com.bysquare.document.invoiceitems.DeliveryNoteReference;
import com.bysquare.document.invoiceitems.OrderReference;
import java.util.Date;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;

@Order(elements={"OrderReference", "DeliveryNoteReference", "ItemName", "ItemEANCode", "PeriodFromDate", "PeriodToDate", "InvoicedQuantity", "UnitPriceTaxExclusiveAmount", "UnitPriceTaxInclusiveAmount", "UnitPriceTaxAmount", "LineTaxExclusiveAmount", "LineTaxInclusiveAmount", "LineTaxAmount", "ClassifiedTaxCategory"})
@Root(name="InvoiceLine", strict=false)
public class InvoiceLine
implements IVerifiable {
    @Element(name="OrderReference", required=false)
    protected OrderReference orderReference;
    @Element(name="DeliveryNoteReference", required=false)
    protected DeliveryNoteReference deliveryNoteReference;
    protected String itemName;
    protected String itemEANCode;
    @Element(name="PeriodFromDate", required=false)
    protected Date periodFromDate;
    @Element(name="PeriodToDate", required=false)
    protected Date periodToDate;
    protected Double invoicedQuantity;
    protected Double unitPriceTaxExclusiveAmount;
    protected Double unitPriceTaxAmount;
    protected Double classifiedTaxCategory;

    public OrderReference getOrderReference() {
        return this.orderReference;
    }

    public void setOrderReference(OrderReference orderReference) {
        this.orderReference = orderReference;
    }

    public DeliveryNoteReference getDeliveryNoteReference() {
        return this.deliveryNoteReference;
    }

    public void setDeliveryNoteReference(DeliveryNoteReference deliveryNoteReference) {
        this.deliveryNoteReference = deliveryNoteReference;
    }

    @Element(name="ItemName", required=false)
    public String getItemName() {
        return this.itemName;
    }

    @Element(name="ItemName", required=false)
    public void setItemName(String string) {
        this.itemName = Verify.trim(string);
    }

    @Element(name="ItemEANCode", required=false)
    public String getItemEANCode() {
        return this.itemEANCode;
    }

    @Element(name="ItemEANCode", required=false)
    public void setItemEANCode(String string) {
        this.itemEANCode = Verify.trimAll(string);
    }

    public Date getPeriodFromDate() {
        return this.periodFromDate;
    }

    public void setPeriodFromDate(Date date) {
        this.periodFromDate = date;
    }

    public Date getPeriodToDate() {
        return this.periodToDate;
    }

    public void setPeriodToDate(Date date) {
        this.periodToDate = date;
    }

    @Element(name="InvoicedQuantity", required=false)
    public Double getInvoicedQuantity() {
        if (this.invoicedQuantity == null) {
            this.invoicedQuantity = 0.0;
        }
        return this.invoicedQuantity;
    }

    @Element(name="InvoicedQuantity", required=false)
    public void setInvoicedQuantity(Double d2) {
        this.invoicedQuantity = d2;
    }

    @Element(name="UnitPriceTaxExclusiveAmount", required=true)
    public Double getUnitPriceTaxExclusiveAmount() {
        if (this.unitPriceTaxExclusiveAmount == null) {
            this.unitPriceTaxExclusiveAmount = 0.0;
        }
        return this.unitPriceTaxExclusiveAmount;
    }

    @Element(name="UnitPriceTaxExclusiveAmount", required=true)
    public void setUnitPriceTaxExclusiveAmount(Double d2) {
        this.unitPriceTaxExclusiveAmount = d2;
    }

    @Element(name="UnitPriceTaxInclusiveAmount", required=false)
    public Double getUnitPriceTaxInclusiveAmount() {
        return this.getUnitPriceTaxExclusiveAmount() + this.getUnitPriceTaxAmount();
    }

    @Deprecated
    @Element(name="UnitPriceTaxInclusiveAmount", required=false)
    public void setUnitPriceTaxInclusiveAmount(Double d2) {
    }

    @Element(name="UnitPriceTaxAmount", required=false)
    public Double getUnitPriceTaxAmount() {
        if (this.unitPriceTaxAmount == null) {
            this.unitPriceTaxAmount = 0.0;
        }
        return this.unitPriceTaxAmount;
    }

    @Element(name="UnitPriceTaxAmount", required=false)
    public void setUnitPriceTaxAmount(Double d2) {
        this.unitPriceTaxAmount = d2;
    }

    @Element(name="LineTaxExclusiveAmount", required=false)
    public Double getLineTaxExclusiveAmount() {
        return this.getUnitPriceTaxExclusiveAmount() * this.getInvoicedQuantity();
    }

    @Deprecated
    @Element(name="LineTaxExclusiveAmount", required=false)
    public void setLineTaxExclusiveAmount(Double d2) {
    }

    @Element(name="LineTaxInclusiveAmount", required=false)
    public Double getLineTaxInclusiveAmount() {
        return this.getUnitPriceTaxInclusiveAmount() * this.getInvoicedQuantity();
    }

    @Deprecated
    @Element(name="LineTaxInclusiveAmount", required=false)
    public void setLineTaxInclusiveAmount(Double d2) {
    }

    @Element(name="LineTaxAmount", required=false)
    public Double getLineTaxAmount() {
        return this.getUnitPriceTaxAmount() * this.getInvoicedQuantity();
    }

    @Deprecated
    @Element(name="LineTaxAmount", required=false)
    public void setLineTaxAmount(Double d2) {
    }

    @Element(name="ClassifiedTaxCategory", required=false)
    public Double getClassifiedTaxCategory() {
        if (this.classifiedTaxCategory == null) {
            this.classifiedTaxCategory = 0.0;
        }
        return this.classifiedTaxCategory;
    }

    @Element(name="ClassifiedTaxCategory", required=false)
    public void setClassifiedTaxCategory(Double d2) {
        this.classifiedTaxCategory = d2;
    }

    public void verify() throws InvalidValueException {
        Verify.nullOrVerify(this.orderReference);
        Verify.nullOrVerify(this.deliveryNoteReference);
        Verify.choice("ItemName ItemEANCode", this.getItemName(), this.getItemEANCode());
        Verify.periodFromToDate(this.getPeriodFromDate(), this.getPeriodToDate());
        Verify.notNullAndPercentage("ClassifiedTaxCategory", this.classifiedTaxCategory);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof InvoiceLine)) {
            return false;
        }
        InvoiceLine invoiceLine = (InvoiceLine)object;
        if (!this.getClassifiedTaxCategory().equals(invoiceLine.getClassifiedTaxCategory())) {
            return false;
        }
        if (this.deliveryNoteReference == null ? invoiceLine.deliveryNoteReference != null : !this.deliveryNoteReference.equals(invoiceLine.deliveryNoteReference)) {
            return false;
        }
        if (!this.getInvoicedQuantity().equals(invoiceLine.getInvoicedQuantity())) {
            return false;
        }
        if (this.itemEANCode == null ? invoiceLine.itemEANCode != null : !this.itemEANCode.equals(invoiceLine.itemEANCode)) {
            return false;
        }
        if (this.itemName == null ? invoiceLine.itemName != null : !this.itemName.equals(invoiceLine.itemName)) {
            return false;
        }
        if (this.orderReference == null ? invoiceLine.orderReference != null : !this.orderReference.equals(invoiceLine.orderReference)) {
            return false;
        }
        if (this.periodFromDate == null ? invoiceLine.periodFromDate != null : !this.periodFromDate.equals(invoiceLine.periodFromDate)) {
            return false;
        }
        if (this.periodToDate == null ? invoiceLine.periodToDate != null : !this.periodToDate.equals(invoiceLine.periodToDate)) {
            return false;
        }
        if (!this.getUnitPriceTaxAmount().equals(invoiceLine.getUnitPriceTaxAmount())) {
            return false;
        }
        return this.getUnitPriceTaxExclusiveAmount().equals(invoiceLine.getUnitPriceTaxExclusiveAmount());
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + this.getClassifiedTaxCategory().hashCode();
        n2 = 31 * n2 + (this.deliveryNoteReference == null ? 0 : this.deliveryNoteReference.hashCode());
        n2 = 31 * n2 + this.getInvoicedQuantity().hashCode();
        n2 = 31 * n2 + (this.itemEANCode == null ? 0 : this.itemEANCode.hashCode());
        n2 = 31 * n2 + (this.itemName == null ? 0 : this.itemName.hashCode());
        n2 = 31 * n2 + (this.orderReference == null ? 0 : this.orderReference.hashCode());
        n2 = 31 * n2 + (this.periodFromDate == null ? 0 : this.periodFromDate.hashCode());
        n2 = 31 * n2 + (this.periodToDate == null ? 0 : this.periodToDate.hashCode());
        n2 = 31 * n2 + this.getUnitPriceTaxAmount().hashCode();
        n2 = 31 * n2 + this.getUnitPriceTaxExclusiveAmount().hashCode();
        return n2;
    }
}

