/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.logo;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public abstract class Logo {
    protected static final int TYPE = 6;
    protected final BufferedImage logo;
    protected final int width;
    protected final int height;
    protected final double ratio;

    protected Logo(BufferedImage bufferedImage, boolean bl) {
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        if (bl) {
            this.logo = new BufferedImage(this.width, this.height, 6);
            Graphics2D graphics2D = this.logo.createGraphics();
            graphics2D.setBackground(Color.WHITE);
            graphics2D.clearRect(0, 0, this.width, this.height);
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.dispose();
        } else {
            this.logo = bufferedImage;
        }
        this.ratio = (double)this.width / (double)this.height;
    }

    public void paint(Graphics graphics, int n2, int n3) {
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, n2, n3);
        int n4 = 0;
        int n5 = 0;
        if (this.ratio < (double)n2 / (double)n3) {
            int n6 = n2;
            n2 = (int)Math.round(this.ratio * (double)n3);
            n4 = n6 - n2 >> 1;
        } else {
            int n7 = n3;
            n3 = (int)Math.round((double)n2 / this.ratio);
            n5 = n7 - n3 >> 1;
        }
        graphics.drawImage(this.logo, n4, n5, n2, n3, null);
    }

    public abstract BufferedImage wrap(Image var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Variation {
        DARK,
        MEDIUM,
        LIGHT,
        GRAY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        PAY,
        INVOICE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Rotation {
        BOTTOM,
        TOP,
        LEFT,
        RIGHT;

    }
}

