/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.logo;

import com.bysquare.Header;
import com.bysquare.logo.Logo;

public class LogoKey
implements Cloneable {
    private boolean frame = true;
    private Logo.Rotation rotation = Logo.Rotation.BOTTOM;
    private String string;
    private Header.Type type = Header.Type.Pay;
    private Logo.Variation variation = Logo.Variation.DARK;

    public LogoKey clone() {
        try {
            return (LogoKey)super.clone();
        }
        catch (Throwable throwable) {
            return new LogoKey();
        }
    }

    public void copyFrom(LogoKey logoKey) {
        if (logoKey == null) {
            throw new NullPointerException("Logo key cannot be null. ");
        }
        this.rotation = logoKey.rotation;
        this.variation = logoKey.variation;
        this.type = logoKey.type;
        this.frame = logoKey.frame;
        this.string = logoKey.string;
    }

    public boolean equals(Object object) {
        if (object instanceof LogoKey) {
            LogoKey logoKey = (LogoKey)object;
            return this.type == logoKey.type && this.rotation == logoKey.rotation && this.variation == logoKey.variation && this.frame == logoKey.frame;
        }
        return false;
    }

    public boolean getFrame() {
        return this.frame;
    }

    public Logo.Rotation getRotation() {
        return this.rotation;
    }

    public Header.Type getType() {
        return this.type;
    }

    public Logo.Variation getVariation() {
        return this.variation;
    }

    public int hashCode() {
        return this.rotation.hashCode() + this.variation.hashCode() + this.type.hashCode() + (this.frame ? -1 : 0);
    }

    public void setFrame(boolean bl) {
        this.frame = bl;
        this.string = null;
    }

    public void setRotation(Logo.Rotation rotation) {
        if (rotation == null) {
            throw new NullPointerException("Logo rotation cannot be null. ");
        }
        this.rotation = rotation;
        this.string = null;
    }

    public void setType(Header.Type type) {
        if (type == null) {
            throw new NullPointerException("Logo type cannot be null. ");
        }
        this.type = type;
        this.string = null;
    }

    public void setVariation(Logo.Variation variation) {
        if (variation == null) {
            throw new NullPointerException("Logo variation cannot be null. ");
        }
        this.variation = variation;
        this.string = null;
    }

    public String toString() {
        if (this.string == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.type.name().toLowerCase());
            stringBuilder.append("-");
            stringBuilder.append(this.rotation.name().toLowerCase());
            stringBuilder.append("-");
            stringBuilder.append(this.variation.name().toLowerCase());
            if (!this.frame) {
                stringBuilder.append("-no_frame");
            }
            this.string = stringBuilder.toString();
        }
        return this.string;
    }
}

