/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.sequence;

import com.bysquare.document.BysquareDocument;
import com.bysquare.sequence.BadFormatException;
import com.bysquare.sequence.InvoiceBaseEncoder;
import com.bysquare.sequence.InvoiceItemsBaseEncoder;
import com.bysquare.sequence.PayBaseEncoder;
import com.bysquare.sequence.SequenceLimitExceededException;
import com.bysquare.sequence.Truncation;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.PriorityQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SequenceEncoder {
    public static final int DEFAULT_LIMIT = 550;
    public static final int DEFAULT_MAXPRIORITY = 0;
    private final SimpleDateFormat dateFormat;
    private final DecimalFormat decimalFormat;
    private int limit = 550;
    private int maxPriority = Integer.MAX_VALUE;
    private boolean truncated;
    private String[] fields;
    private int index;
    private PriorityQueue<Truncation> truncations;

    private static char[] getChars(String[] stringArray) {
        char[] cArray = new char[SequenceEncoder.getLength(stringArray)];
        int n2 = 0;
        boolean bl = false;
        for (String string : stringArray) {
            if (bl) {
                cArray[n2++] = 9;
            }
            if (string != null) {
                string.getChars(0, string.length(), cArray, n2);
                n2 += string.length();
            }
            bl = true;
        }
        return cArray;
    }

    public static SequenceEncoder getInstance(int n2) {
        switch (n2) {
            case 0: {
                return new PayBaseEncoder();
            }
            case 1: {
                return new InvoiceBaseEncoder();
            }
            case 2: {
                return new InvoiceItemsBaseEncoder();
            }
        }
        return null;
    }

    private static int getLength(String[] stringArray) {
        int n2 = stringArray.length - 1;
        for (String string : stringArray) {
            if (string == null) continue;
            n2 += string.length();
        }
        return n2;
    }

    SequenceEncoder() {
        this.decimalFormat = new DecimalFormat("#.########", new DecimalFormatSymbols(Locale.US));
        this.dateFormat = new SimpleDateFormat("yyyyMMdd");
        this.dateFormat.setLenient(false);
    }

    protected void add(Date date) {
        if (date != null) {
            this.addInternal(this.dateFormat.format(date));
        } else {
            this.skip();
        }
    }

    protected void add(Double d2) {
        if (d2 != null) {
            this.addInternal(this.decimalFormat.format(d2));
        } else {
            this.skip();
        }
    }

    protected <E extends Enum<E>> void add(E e2) {
        if (e2 != null) {
            this.addInternal(Integer.toString(e2.ordinal()));
        } else {
            this.skip();
        }
    }

    protected void add(int n2) {
        this.addInternal(Integer.toString(n2));
    }

    protected void add(Integer n2) {
        if (n2 != null) {
            this.addInternal(Integer.toString(n2));
        } else {
            this.skip();
        }
    }

    protected <E extends Enum<E>> void add(List<E> list) {
        if (list != null && !list.isEmpty()) {
            int n2 = 0;
            for (Enum enum_ : list) {
                n2 |= 1 << enum_.ordinal();
            }
            if (n2 != 0) {
                this.addInternal(Integer.toString(n2));
            } else {
                this.skip();
            }
        } else {
            this.skip();
        }
    }

    protected void add(String string) {
        if (string != null) {
            this.addInternal(string.replace('\t', ' '));
        } else {
            this.skip();
        }
    }

    protected void add(String string, int n2, int n3) {
        if (string != null) {
            this.truncations.add(new Truncation(this.index, n2, n3));
            this.addInternal(string.replace('\t', ' '));
        } else {
            this.skip();
        }
    }

    private void addInternal(String string) {
        this.fields[this.index++] = string;
    }

    public String encode(BysquareDocument bysquareDocument) throws BadFormatException {
        this.index = 0;
        this.truncated = false;
        int n2 = this.getFieldCount(bysquareDocument);
        this.fields = new String[n2];
        this.truncations = new PriorityQueue();
        try {
            this.encodeInternal(bysquareDocument);
            if (this.limit > 0) {
                this.truncate();
            }
            String string = new String(SequenceEncoder.getChars(this.fields));
            return string;
        }
        catch (BadFormatException badFormatException) {
            throw badFormatException;
        }
        catch (Throwable throwable) {
            throw new BadFormatException(throwable);
        }
        finally {
            this.fields = null;
            this.truncations = null;
        }
    }

    protected abstract void encodeInternal(BysquareDocument var1);

    protected abstract int getFieldCount(BysquareDocument var1);

    public void setLimit(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Sequence limit cannot be negative.");
        }
        this.limit = n2;
    }

    public void setMaxPriority(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Maximum priority cannot be negative.");
        }
        this.maxPriority = n2;
    }

    protected void skip() {
        ++this.index;
    }

    private void truncate() throws SequenceLimitExceededException {
        int n2 = SequenceEncoder.getLength(this.fields);
        while (n2 > this.limit) {
            String string;
            Truncation truncation = this.truncations.poll();
            if (truncation == null || truncation.priority >= this.maxPriority) {
                string = "Data length (%s) exceeds the limit (%s).";
                String string2 = String.format(string, n2, this.limit);
                throw new SequenceLimitExceededException(string2);
            }
            string = this.fields[truncation.index];
            if (string.length() <= truncation.maxLength) continue;
            int n3 = Math.min(string.length() - truncation.maxLength, n2 - this.limit);
            this.fields[truncation.index] = string.substring(0, string.length() - n3);
            n2 -= n3;
            this.truncated = true;
        }
    }

    public final boolean wasTruncated() {
        return this.truncated;
    }
}

