/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.xml.helper;

import com.bysquare.xml.XMLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simpleframework.xml.convert.Converter;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnumListConverter<T extends Enum<T>>
implements Converter<List<T>> {
    private final Map<String, T> map;
    private final String name;

    protected EnumListConverter(Class<T> clazz) {
        this.name = clazz.getSimpleName();
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        this.map = new HashMap<String, T>(enumArray.length);
        for (Enum enum_ : enumArray) {
            this.map.put(enum_.toString(), enum_);
        }
    }

    @Override
    public final List<T> read(InputNode inputNode) throws Exception {
        String string = inputNode.getValue();
        ArrayList<Enum> arrayList = new ArrayList<Enum>();
        if (string == null) {
            return arrayList;
        }
        String[] stringArray = string.split(" ");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Enum enum_ = (Enum)this.map.get(stringArray[i2]);
            if (enum_ == null) {
                throw new XMLException(this.name, (Object)stringArray[i2]);
            }
            arrayList.add(enum_);
        }
        return arrayList;
    }

    @Override
    public final void write(OutputNode outputNode, List<T> list) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        for (Enum enum_ : list) {
            stringBuilder.append(enum_);
            stringBuilder.append(" ");
        }
        if (stringBuilder.length() > 0) {
            outputNode.setValue(stringBuilder.substring(0, stringBuilder.length() - 1));
        }
        outputNode.getAttributes().remove("class");
    }
}

