/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

public final class BitArray {
    private int[] bits;
    private int size;

    public BitArray() {
        this.size = 0;
        this.bits = new int[1];
    }

    public BitArray(int size) {
        this.size = size;
        this.bits = BitArray.makeArray(size);
    }

    BitArray(int[] bits, int size) {
        this.bits = bits;
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public int getSizeInBytes() {
        return (this.size + 7) / 8;
    }

    private void ensureCapacity(int size) {
        if (size > this.bits.length * 32) {
            int[] newBits = BitArray.makeArray(size);
            System.arraycopy(this.bits, 0, newBits, 0, this.bits.length);
            this.bits = newBits;
        }
    }

    public boolean get(int i2) {
        return (this.bits[i2 / 32] & 1 << (i2 & 0x1F)) != 0;
    }

    public void set(int i2) {
        int n2 = i2 / 32;
        this.bits[n2] = this.bits[n2] | 1 << (i2 & 0x1F);
    }

    public void flip(int i2) {
        int n2 = i2 / 32;
        this.bits[n2] = this.bits[n2] ^ 1 << (i2 & 0x1F);
    }

    public int getNextSet(int from) {
        if (from >= this.size) {
            return this.size;
        }
        int bitsOffset = from / 32;
        int currentBits = this.bits[bitsOffset];
        currentBits &= ~((1 << (from & 0x1F)) - 1);
        while (currentBits == 0) {
            if (++bitsOffset == this.bits.length) {
                return this.size;
            }
            currentBits = this.bits[bitsOffset];
        }
        int result = bitsOffset * 32 + Integer.numberOfTrailingZeros(currentBits);
        return result > this.size ? this.size : result;
    }

    public int getNextUnset(int from) {
        if (from >= this.size) {
            return this.size;
        }
        int bitsOffset = from / 32;
        int currentBits = ~this.bits[bitsOffset];
        currentBits &= ~((1 << (from & 0x1F)) - 1);
        while (currentBits == 0) {
            if (++bitsOffset == this.bits.length) {
                return this.size;
            }
            currentBits = ~this.bits[bitsOffset];
        }
        int result = bitsOffset * 32 + Integer.numberOfTrailingZeros(currentBits);
        return result > this.size ? this.size : result;
    }

    public void setBulk(int i2, int newBits) {
        this.bits[i2 / 32] = newBits;
    }

    public void setRange(int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException();
        }
        if (end == start) {
            return;
        }
        int firstInt = start / 32;
        int lastInt = --end / 32;
        int i2 = firstInt;
        while (i2 <= lastInt) {
            int mask;
            int lastBit;
            int firstBit = i2 > firstInt ? 0 : start & 0x1F;
            int n2 = lastBit = i2 < lastInt ? 31 : end & 0x1F;
            if (firstBit == 0 && lastBit == 31) {
                mask = -1;
            } else {
                mask = 0;
                for (int j2 = firstBit; j2 <= lastBit; ++j2) {
                    mask |= 1 << j2;
                }
            }
            int n3 = i2++;
            this.bits[n3] = this.bits[n3] | mask;
        }
    }

    public void clear() {
        int max = this.bits.length;
        for (int i2 = 0; i2 < max; ++i2) {
            this.bits[i2] = 0;
        }
    }

    public boolean isRange(int start, int end, boolean value) {
        if (end < start) {
            throw new IllegalArgumentException();
        }
        if (end == start) {
            return true;
        }
        int firstInt = start / 32;
        int lastInt = --end / 32;
        for (int i2 = firstInt; i2 <= lastInt; ++i2) {
            int mask;
            int lastBit;
            int firstBit = i2 > firstInt ? 0 : start & 0x1F;
            int n2 = lastBit = i2 < lastInt ? 31 : end & 0x1F;
            if (firstBit == 0 && lastBit == 31) {
                mask = -1;
            } else {
                mask = 0;
                for (int j2 = firstBit; j2 <= lastBit; ++j2) {
                    mask |= 1 << j2;
                }
            }
            if ((this.bits[i2] & mask) == (value ? mask : 0)) continue;
            return false;
        }
        return true;
    }

    public void appendBit(boolean bit) {
        this.ensureCapacity(this.size + 1);
        if (bit) {
            int n2 = this.size / 32;
            this.bits[n2] = this.bits[n2] | 1 << (this.size & 0x1F);
        }
        ++this.size;
    }

    public void appendBits(int value, int numBits) {
        if (numBits < 0 || numBits > 32) {
            throw new IllegalArgumentException("Num bits must be between 0 and 32");
        }
        this.ensureCapacity(this.size + numBits);
        for (int numBitsLeft = numBits; numBitsLeft > 0; --numBitsLeft) {
            this.appendBit((value >> numBitsLeft - 1 & 1) == 1);
        }
    }

    public void appendBitArray(BitArray other) {
        int otherSize = other.size;
        this.ensureCapacity(this.size + otherSize);
        for (int i2 = 0; i2 < otherSize; ++i2) {
            this.appendBit(other.get(i2));
        }
    }

    public void xor(BitArray other) {
        if (this.bits.length != other.bits.length) {
            throw new IllegalArgumentException("Sizes don't match");
        }
        for (int i2 = 0; i2 < this.bits.length; ++i2) {
            int n2 = i2;
            this.bits[n2] = this.bits[n2] ^ other.bits[i2];
        }
    }

    public void toBytes(int bitOffset, byte[] array, int offset, int numBytes) {
        for (int i2 = 0; i2 < numBytes; ++i2) {
            int theByte = 0;
            for (int j2 = 0; j2 < 8; ++j2) {
                if (this.get(bitOffset)) {
                    theByte |= 1 << 7 - j2;
                }
                ++bitOffset;
            }
            array[offset + i2] = (byte)theByte;
        }
    }

    public int[] getBitArray() {
        return this.bits;
    }

    public void reverse() {
        int[] newBits = new int[this.bits.length];
        int len = (this.size - 1) / 32;
        int oldBitsLen = len + 1;
        for (int i2 = 0; i2 < oldBitsLen; ++i2) {
            long x = this.bits[i2];
            x = x >> 1 & 0x55555555L | (x & 0x55555555L) << 1;
            x = x >> 2 & 0x33333333L | (x & 0x33333333L) << 2;
            x = x >> 4 & 0xF0F0F0FL | (x & 0xF0F0F0FL) << 4;
            x = x >> 8 & 0xFF00FFL | (x & 0xFF00FFL) << 8;
            x = x >> 16 & 0xFFFFL | (x & 0xFFFFL) << 16;
            newBits[len - i2] = (int)x;
        }
        if (this.size != oldBitsLen * 32) {
            int leftOffset = oldBitsLen * 32 - this.size;
            int mask = 1;
            for (int i3 = 0; i3 < 31 - leftOffset; ++i3) {
                mask = mask << 1 | 1;
            }
            int currentInt = newBits[0] >> leftOffset & mask;
            for (int i4 = 1; i4 < oldBitsLen; ++i4) {
                int nextInt = newBits[i4];
                newBits[i4 - 1] = currentInt |= nextInt << 32 - leftOffset;
                currentInt = nextInt >> leftOffset & mask;
            }
            newBits[oldBitsLen - 1] = currentInt;
        }
        this.bits = newBits;
    }

    private static int[] makeArray(int size) {
        return new int[(size + 31) / 32];
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.size);
        for (int i2 = 0; i2 < this.size; ++i2) {
            if ((i2 & 7) == 0) {
                result.append(' ');
            }
            result.append(this.get(i2) ? (char)'X' : '.');
        }
        return result.toString();
    }
}

