/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder.ec;

import com.google.zxing.ChecksumException;
import com.google.zxing.pdf417.decoder.ec.ModulusGF;
import com.google.zxing.pdf417.decoder.ec.ModulusPoly;

public final class ErrorCorrection {
    private final ModulusGF field = ModulusGF.PDF417_GF;

    public int decode(int[] received, int numECCodewords, int[] erasures) throws ChecksumException {
        ModulusPoly poly = new ModulusPoly(this.field, received);
        int[] S2 = new int[numECCodewords];
        boolean error = false;
        for (int i2 = numECCodewords; i2 > 0; --i2) {
            int eval;
            S2[numECCodewords - i2] = eval = poly.evaluateAt(this.field.exp(i2));
            if (eval == 0) continue;
            error = true;
        }
        if (!error) {
            return 0;
        }
        ModulusPoly knownErrors = this.field.getOne();
        for (int erasure : erasures) {
            int b2 = this.field.exp(received.length - 1 - erasure);
            ModulusPoly term = new ModulusPoly(this.field, new int[]{this.field.subtract(0, b2), 1});
            knownErrors = knownErrors.multiply(term);
        }
        ModulusPoly syndrome = new ModulusPoly(this.field, S2);
        ModulusPoly[] sigmaOmega = this.runEuclideanAlgorithm(this.field.buildMonomial(numECCodewords, 1), syndrome, numECCodewords);
        ModulusPoly sigma = sigmaOmega[0];
        ModulusPoly omega = sigmaOmega[1];
        int[] errorLocations = this.findErrorLocations(sigma);
        int[] errorMagnitudes = this.findErrorMagnitudes(omega, sigma, errorLocations);
        for (int i3 = 0; i3 < errorLocations.length; ++i3) {
            int position = received.length - 1 - this.field.log(errorLocations[i3]);
            if (position < 0) {
                throw ChecksumException.getChecksumInstance();
            }
            received[position] = this.field.subtract(received[position], errorMagnitudes[i3]);
        }
        return errorLocations.length;
    }

    private ModulusPoly[] runEuclideanAlgorithm(ModulusPoly a2, ModulusPoly b2, int R) throws ChecksumException {
        if (a2.getDegree() < b2.getDegree()) {
            ModulusPoly temp = a2;
            a2 = b2;
            b2 = temp;
        }
        ModulusPoly rLast = a2;
        ModulusPoly r2 = b2;
        ModulusPoly tLast = this.field.getZero();
        ModulusPoly t = this.field.getOne();
        while (r2.getDegree() >= R / 2) {
            ModulusPoly rLastLast = rLast;
            ModulusPoly tLastLast = tLast;
            rLast = r2;
            tLast = t;
            if (rLast.isZero()) {
                throw ChecksumException.getChecksumInstance();
            }
            r2 = rLastLast;
            ModulusPoly q2 = this.field.getZero();
            int denominatorLeadingTerm = rLast.getCoefficient(rLast.getDegree());
            int dltInverse = this.field.inverse(denominatorLeadingTerm);
            while (r2.getDegree() >= rLast.getDegree() && !r2.isZero()) {
                int degreeDiff = r2.getDegree() - rLast.getDegree();
                int scale = this.field.multiply(r2.getCoefficient(r2.getDegree()), dltInverse);
                q2 = q2.add(this.field.buildMonomial(degreeDiff, scale));
                r2 = r2.subtract(rLast.multiplyByMonomial(degreeDiff, scale));
            }
            t = q2.multiply(tLast).subtract(tLastLast).negative();
        }
        int sigmaTildeAtZero = t.getCoefficient(0);
        if (sigmaTildeAtZero == 0) {
            throw ChecksumException.getChecksumInstance();
        }
        int inverse = this.field.inverse(sigmaTildeAtZero);
        ModulusPoly sigma = t.multiply(inverse);
        ModulusPoly omega = r2.multiply(inverse);
        return new ModulusPoly[]{sigma, omega};
    }

    private int[] findErrorLocations(ModulusPoly errorLocator) throws ChecksumException {
        int numErrors = errorLocator.getDegree();
        int[] result = new int[numErrors];
        int e2 = 0;
        for (int i2 = 1; i2 < this.field.getSize() && e2 < numErrors; ++i2) {
            if (errorLocator.evaluateAt(i2) != 0) continue;
            result[e2] = this.field.inverse(i2);
            ++e2;
        }
        if (e2 != numErrors) {
            throw ChecksumException.getChecksumInstance();
        }
        return result;
    }

    private int[] findErrorMagnitudes(ModulusPoly errorEvaluator, ModulusPoly errorLocator, int[] errorLocations) {
        int errorLocatorDegree = errorLocator.getDegree();
        int[] formalDerivativeCoefficients = new int[errorLocatorDegree];
        for (int i2 = 1; i2 <= errorLocatorDegree; ++i2) {
            formalDerivativeCoefficients[errorLocatorDegree - i2] = this.field.multiply(i2, errorLocator.getCoefficient(i2));
        }
        ModulusPoly formalDerivative = new ModulusPoly(this.field, formalDerivativeCoefficients);
        int s2 = errorLocations.length;
        int[] result = new int[s2];
        for (int i3 = 0; i3 < s2; ++i3) {
            int xiInverse = this.field.inverse(errorLocations[i3]);
            int numerator = this.field.subtract(0, errorEvaluator.evaluateAt(xiInverse));
            int denominator = this.field.inverse(formalDerivative.evaluateAt(xiInverse));
            result[i3] = this.field.multiply(numerator, denominator);
        }
        return result;
    }
}

