/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.awt.geom;

import com.itextpdf.awt.geom.Dimension;
import com.itextpdf.awt.geom.Point;
import com.itextpdf.awt.geom.Rectangle2D;
import com.itextpdf.awt.geom.Shape;
import java.io.Serializable;

public class Rectangle
extends Rectangle2D
implements Shape,
Serializable {
    private static final long serialVersionUID = -4345857070255674764L;
    public double x;
    public double y;
    public double width;
    public double height;

    public Rectangle() {
        this.setBounds(0, 0, 0, 0);
    }

    public Rectangle(Point p2) {
        this.setBounds(p2.x, p2.y, 0.0, 0.0);
    }

    public Rectangle(Point p2, Dimension d2) {
        this.setBounds(p2.x, p2.y, d2.width, d2.height);
    }

    public Rectangle(double x, double y, double width, double height) {
        this.setBounds(x, y, width, height);
    }

    public Rectangle(int width, int height) {
        this.setBounds(0, 0, width, height);
    }

    public Rectangle(Rectangle r2) {
        this.setBounds(r2.x, r2.y, r2.width, r2.height);
    }

    public Rectangle(com.itextpdf.text.Rectangle r2) {
        r2.normalize();
        this.setBounds(r2.getLeft(), r2.getBottom(), r2.getWidth(), r2.getHeight());
    }

    public Rectangle(Dimension d2) {
        this.setBounds(0.0, 0.0, d2.width, d2.height);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public boolean isEmpty() {
        return this.width <= 0.0 || this.height <= 0.0;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(int mx, int my) {
        this.setSize((double)mx, (double)my);
    }

    public void setSize(double width, double height) {
        this.width = width;
        this.height = height;
    }

    public void setSize(Dimension d2) {
        this.setSize(d2.width, d2.height);
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public void setLocation(int mx, int my) {
        this.setLocation((double)mx, (double)my);
    }

    public void setLocation(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setLocation(Point p2) {
        this.setLocation(p2.x, p2.y);
    }

    public void setRect(double x, double y, double width, double height) {
        int x1 = (int)Math.floor(x);
        int y1 = (int)Math.floor(y);
        int x2 = (int)Math.ceil(x + width);
        int y2 = (int)Math.ceil(y + height);
        this.setBounds(x1, y1, x2 - x1, y2 - y1);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Rectangle2D getBounds2D() {
        return this.getBounds();
    }

    public void setBounds(int x, int y, int width, int height) {
        this.setBounds((double)x, (double)y, (double)width, (double)height);
    }

    public void setBounds(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.height = height;
        this.width = width;
    }

    public void setBounds(Rectangle r2) {
        this.setBounds(r2.x, r2.y, r2.width, r2.height);
    }

    public void grow(int mx, int my) {
        this.translate((double)mx, (double)my);
    }

    public void grow(double dx, double dy) {
        this.x -= dx;
        this.y -= dy;
        this.width += dx + dx;
        this.height += dy + dy;
    }

    public void translate(int mx, int my) {
        this.translate((double)mx, (double)my);
    }

    public void translate(double mx, double my) {
        this.x += mx;
        this.y += my;
    }

    public void add(int px, int py) {
        this.add((double)px, (double)py);
    }

    public void add(double px, double py) {
        double x1 = Math.min(this.x, px);
        double x2 = Math.max(this.x + this.width, px);
        double y1 = Math.min(this.y, py);
        double y2 = Math.max(this.y + this.height, py);
        this.setBounds(x1, y1, x2 - x1, y2 - y1);
    }

    public void add(Point p2) {
        this.add(p2.x, p2.y);
    }

    public void add(Rectangle r2) {
        double x1 = Math.min(this.x, r2.x);
        double x2 = Math.max(this.x + this.width, r2.x + r2.width);
        double y1 = Math.min(this.y, r2.y);
        double y2 = Math.max(this.y + this.height, r2.y + r2.height);
        this.setBounds(x1, y1, x2 - x1, y2 - y1);
    }

    public boolean contains(int px, int py) {
        return this.contains((double)px, (double)py);
    }

    public boolean contains(double px, double py) {
        if (this.isEmpty()) {
            return false;
        }
        if (px < this.x || py < this.y) {
            return false;
        }
        return (px -= this.x) < this.width && (py -= this.y) < this.height;
    }

    public boolean contains(Point p2) {
        return this.contains(p2.x, p2.y);
    }

    public boolean contains(int rx, int ry, int rw, int rh) {
        return this.contains(rx, ry) && this.contains(rx + rw - 1, ry + rh - 1);
    }

    public boolean contains(double rx, double ry, double rw, double rh) {
        return this.contains(rx, ry) && this.contains(rx + rw - 0.01, ry + rh - 0.01);
    }

    public boolean contains(Rectangle r2) {
        return this.contains(r2.x, r2.y, r2.width, r2.height);
    }

    public Rectangle2D createIntersection(Rectangle2D r2) {
        if (r2 instanceof Rectangle) {
            return this.intersection((Rectangle)r2);
        }
        Rectangle2D.Double dst = new Rectangle2D.Double();
        Rectangle2D.intersect(this, r2, dst);
        return dst;
    }

    public Rectangle intersection(Rectangle r2) {
        double x1 = Math.max(this.x, r2.x);
        double y1 = Math.max(this.y, r2.y);
        double x2 = Math.min(this.x + this.width, r2.x + r2.width);
        double y2 = Math.min(this.y + this.height, r2.y + r2.height);
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }

    public boolean intersects(Rectangle r2) {
        return !this.intersection(r2).isEmpty();
    }

    public int outcode(double px, double py) {
        int code = 0;
        if (this.width <= 0.0) {
            code |= 5;
        } else if (px < this.x) {
            code |= 1;
        } else if (px > this.x + this.width) {
            code |= 4;
        }
        if (this.height <= 0.0) {
            code |= 0xA;
        } else if (py < this.y) {
            code |= 2;
        } else if (py > this.y + this.height) {
            code |= 8;
        }
        return code;
    }

    public Rectangle2D createUnion(Rectangle2D r2) {
        if (r2 instanceof Rectangle) {
            return this.union((Rectangle)r2);
        }
        Rectangle2D.Double dst = new Rectangle2D.Double();
        Rectangle2D.union(this, r2, dst);
        return dst;
    }

    public Rectangle union(Rectangle r2) {
        Rectangle dst = new Rectangle(this);
        dst.add(r2);
        return dst;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Rectangle) {
            Rectangle r2 = (Rectangle)obj;
            return r2.x == this.x && r2.y == this.y && r2.width == this.width && r2.height == this.height;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
    }
}

