/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view.itext;

import com.itextpdf.rups.model.TreeNodeFactory;
import com.itextpdf.rups.view.itext.treenodes.PdfPageTreeNode;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PageEnumerator
implements Enumeration<PdfPageTreeNode> {
    protected List<PdfPageTreeNode> pages = new ArrayList<PdfPageTreeNode>();
    protected TreeNodeFactory factory;
    protected int cursor = 0;

    public PageEnumerator(PdfDictionary catalog, TreeNodeFactory factory) {
        this.factory = factory;
        this.expand(catalog.getAsIndirectObject(PdfName.PAGES), catalog.getAsDict(PdfName.PAGES));
    }

    @Override
    public boolean hasMoreElements() {
        return this.cursor < this.pages.size();
    }

    @Override
    public PdfPageTreeNode nextElement() {
        return this.pages.get(this.cursor++);
    }

    public void expand(PdfIndirectReference ref, PdfDictionary dict) {
        if (dict == null) {
            return;
        }
        if (dict.isPages()) {
            PdfArray kids = dict.getAsArray(PdfName.KIDS);
            if (kids != null) {
                for (int i2 = 0; i2 < kids.size(); ++i2) {
                    this.expand(kids.getAsIndirectObject(i2), kids.getAsDict(i2));
                }
            }
        } else if (dict.isPage()) {
            this.pages.add((PdfPageTreeNode)this.factory.getNode(ref.getNumber()));
        }
    }
}

