/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view.itext;

import com.itextpdf.rups.view.icons.IconFetcher;
import com.itextpdf.rups.view.models.DictionaryTableModel;
import com.itextpdf.rups.view.models.DictionaryTableModelButton;
import com.itextpdf.rups.view.models.PdfArrayTableModel;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfObject;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class PdfObjectPanel
extends JPanel
implements Observer {
    private static final String TEXT = "text";
    private static final String TABLE = "table";
    protected CardLayout layout = new CardLayout();
    JTable table = new JTable();
    JTextArea text = new JTextArea();
    private JTableButtonMouseListener mouseListener;
    private static final long serialVersionUID = 1302283071087762494L;

    public PdfObjectPanel() {
        this.setLayout(this.layout);
        JScrollPane dict_scrollpane = new JScrollPane();
        dict_scrollpane.setViewportView(this.table);
        this.add((Component)dict_scrollpane, TABLE);
        JScrollPane text_scrollpane = new JScrollPane();
        text_scrollpane.setViewportView(this.text);
        this.add((Component)text_scrollpane, TEXT);
        this.mouseListener = new JTableButtonMouseListener(this.table);
        this.table.addMouseListener(this.mouseListener);
    }

    public void clear() {
        this.text.setText(null);
        this.layout.show(this, TEXT);
    }

    public void update(Observable observable, Object obj) {
        this.clear();
    }

    public void render(PdfObject object) {
        if (object == null) {
            this.text.setText(null);
            this.layout.show(this, TEXT);
            this.repaint();
            this.text.repaint();
            return;
        }
        switch (object.type()) {
            case 6: 
            case 7: {
                this.table.setModel(new DictionaryTableModel((PdfDictionary)object));
                this.table.getColumn("").setCellRenderer(new DictionaryTableModelButton(IconFetcher.getIcon("cross.png"), IconFetcher.getIcon("add.png")));
                this.layout.show(this, TABLE);
                this.repaint();
                break;
            }
            case 5: {
                this.table.setModel(new PdfArrayTableModel((PdfArray)object));
                this.layout.show(this, TABLE);
                this.repaint();
                break;
            }
            default: {
                this.text.setText(object.toString());
                this.layout.show(this, TEXT);
            }
        }
    }

    private class JTableButtonMouseListener
    extends MouseAdapter {
        private final JTable table;

        public JTableButtonMouseListener(JTable table) {
            this.table = table;
        }

        public void mouseClicked(MouseEvent e2) {
            int selectedColumn = this.table.getSelectedColumn();
            if (selectedColumn != 2) {
                return;
            }
            int selectedRow = this.table.getSelectedRow();
            int rowCount = this.table.getRowCount();
            if (rowCount == 1 || rowCount - 1 == selectedRow) {
                String keyField = (String)this.table.getValueAt(selectedRow, 0);
                String valueField = (String)this.table.getValueAt(selectedRow, 1);
                if (keyField == null) {
                    return;
                }
                if ("".equalsIgnoreCase(keyField.trim())) {
                    return;
                }
                if (valueField == null) {
                    valueField = "";
                }
                HashMap<String, Integer> choiceMap = new HashMap<String, Integer>(9);
                choiceMap.put("Boolean", 1);
                choiceMap.put("Number", 2);
                choiceMap.put("String", 3);
                choiceMap.put("Name", 4);
                choiceMap.put("Array", 5);
                choiceMap.put("Dictionary", 6);
                choiceMap.put("Stream", 7);
                Object[] choices = new String[choiceMap.size()];
                choiceMap.keySet().toArray(choices);
                int defaultChoice = 0;
                String input = (String)JOptionPane.showInputDialog(this.table, "What is the type of the new value?", "Value Type", 3, null, choices, choices[defaultChoice]);
                if (input == null) {
                    return;
                }
                ((DictionaryTableModel)this.table.getModel()).addRow(keyField, valueField, (Integer)choiceMap.get(input));
                return;
            }
            if (selectedRow < rowCount - 1 && selectedRow >= 0) {
                ((DictionaryTableModel)this.table.getModel()).removeRow(selectedRow);
            }
        }
    }
}

