/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view.itext;

import com.itextpdf.rups.controller.PdfReaderController;
import com.itextpdf.rups.model.ObjectLoader;
import com.itextpdf.rups.model.TreeNodeFactory;
import com.itextpdf.rups.view.icons.IconTreeCellRenderer;
import com.itextpdf.rups.view.itext.treenodes.PdfObjectTreeNode;
import com.itextpdf.rups.view.itext.treenodes.PdfTrailerTreeNode;
import com.itextpdf.rups.view.itext.treenodes.StructureTreeNode;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class StructureTree
extends JTree
implements TreeSelectionListener,
Observer {
    protected PdfReaderController controller;
    private static final long serialVersionUID = 4205940990483252858L;

    public StructureTree(PdfReaderController controller) {
        this.controller = controller;
        this.setCellRenderer(new IconTreeCellRenderer());
        this.setModel(new DefaultTreeModel(new StructureTreeNode()));
        this.addTreeSelectionListener(this);
    }

    public void update(Observable observable, Object obj) {
        if (obj == null) {
            this.setModel(new DefaultTreeModel(new StructureTreeNode()));
            this.repaint();
            return;
        }
        if (obj instanceof ObjectLoader) {
            PdfTrailerTreeNode trailer;
            PdfObjectTreeNode catalog;
            ObjectLoader loader = (ObjectLoader)obj;
            TreeNodeFactory factory = loader.getNodes();
            PdfObjectTreeNode structuretree = factory.getChildNode(catalog = factory.getChildNode(trailer = this.controller.getPdfTree().getRoot(), PdfName.ROOT), PdfName.STRUCTTREEROOT);
            if (structuretree == null) {
                return;
            }
            StructureTreeNode root = new StructureTreeNode();
            PdfObjectTreeNode kids = factory.getChildNode(structuretree, PdfName.K);
            this.loadKids(factory, root, kids);
            this.setModel(new DefaultTreeModel(root));
        }
    }

    private void loadKids(TreeNodeFactory factory, StructureTreeNode structure_node, PdfObjectTreeNode object_node) {
        if (object_node == null) {
            return;
        }
        factory.expandNode(object_node);
        if (object_node.isDictionary()) {
            PdfDictionary dict = (PdfDictionary)object_node.getPdfObject();
            if (dict.checkType(PdfName.MCR)) {
                structure_node.add(new StructureTreeNode(factory.getChildNode(object_node, PdfName.MCID), "bullet_go.png"));
                return;
            }
            if (dict.checkType(PdfName.OBJR)) {
                structure_node.add(new StructureTreeNode(factory.getChildNode(object_node, PdfName.OBJ), "bullet_go.png"));
                return;
            }
            StructureTreeNode leaf = new StructureTreeNode(object_node, "chart_organisation.png");
            structure_node.add(leaf);
            PdfObjectTreeNode kids = factory.getChildNode(object_node, PdfName.K);
            this.loadKids(factory, leaf, kids);
        } else if (object_node.isArray()) {
            Enumeration<TreeNode> children = object_node.children();
            while (children.hasMoreElements()) {
                this.loadKids(factory, structure_node, (PdfObjectTreeNode)children.nextElement());
            }
        } else if (object_node.isIndirectReference()) {
            this.loadKids(factory, structure_node, (PdfObjectTreeNode)object_node.getFirstChild());
        } else {
            StructureTreeNode leaf = new StructureTreeNode(object_node, "bullet_go.png");
            structure_node.add(leaf);
        }
    }

    public void valueChanged(TreeSelectionEvent e2) {
        if (this.controller == null) {
            return;
        }
        StructureTreeNode selectednode = (StructureTreeNode)this.getLastSelectedPathComponent();
        PdfObjectTreeNode node = selectednode.getCorrespondingPdfObjectNode();
        if (node != null) {
            this.controller.selectNode(node);
        }
    }
}

