/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view.itext.treenodes;

import com.itextpdf.rups.view.icons.IconFetcher;
import com.itextpdf.rups.view.icons.IconTreeNode;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XdpTreeNode
extends IconTreeNode {
    private static final long serialVersionUID = -6431790925424045933L;

    public XdpTreeNode(Node node) {
        super(null, node);
        if (node instanceof Element) {
            Element element = (Element)node;
            this.addChildNodes(element.attributes());
        }
        if (node instanceof Branch) {
            Branch branch = (Branch)node;
            this.addChildNodes(branch.content());
        }
        if (node instanceof Attribute) {
            this.icon = IconFetcher.getIcon("attribute.png");
            return;
        }
        if (node instanceof Text) {
            this.icon = IconFetcher.getIcon("text.png");
            return;
        }
        if (node instanceof ProcessingInstruction) {
            this.icon = IconFetcher.getIcon("pi.png");
            return;
        }
        if (node instanceof Document) {
            this.icon = IconFetcher.getIcon("xfa.png");
            return;
        }
        this.icon = IconFetcher.getIcon("tag.png");
    }

    private void addChildNodes(List<Node> list) {
        for (Node node : list) {
            Node n2 = node;
            if (n2 instanceof Namespace || n2 instanceof Comment) continue;
            this.add(new XdpTreeNode(n2));
        }
    }

    public Node getNode() {
        return (Node)this.getUserObject();
    }

    @Override
    public String toString() {
        Node node = this.getNode();
        if (node instanceof Element) {
            Element e2 = (Element)node;
            return e2.getName();
        }
        if (node instanceof Attribute) {
            Attribute a2 = (Attribute)node;
            StringBuffer buf = new StringBuffer();
            buf.append(a2.getName());
            buf.append("=\"");
            buf.append(a2.getValue());
            buf.append('\"');
            return buf.toString();
        }
        if (node instanceof Text) {
            Text t = (Text)node;
            return t.getText();
        }
        if (node instanceof ProcessingInstruction) {
            ProcessingInstruction pi = (ProcessingInstruction)node;
            StringBuffer buf = new StringBuffer("<?");
            buf.append(pi.getName());
            buf.append(' ');
            buf.append(pi.getText());
            buf.append("?>");
            return buf.toString();
        }
        if (node instanceof Document) {
            return "XFA Document";
        }
        return this.getNode().toString();
    }
}

