/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNameTree;
import com.itextpdf.text.pdf.PdfNumberTree;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfStructureElement;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.interfaces.IPdfStructureElement;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfStructureTreeRoot
extends PdfDictionary
implements IPdfStructureElement {
    private HashMap<Integer, PdfObject> parentTree = new HashMap();
    private PdfIndirectReference reference;
    private PdfDictionary classMap = null;
    protected HashMap<PdfName, PdfObject> classes = null;
    private HashMap<Integer, PdfIndirectReference> numTree = null;
    private HashMap<String, PdfObject> idTreeMap;
    private PdfWriter writer;

    PdfStructureTreeRoot(PdfWriter writer) {
        super(PdfName.STRUCTTREEROOT);
        this.writer = writer;
        this.reference = writer.getPdfIndirectReference();
    }

    private void createNumTree() throws IOException {
        if (this.numTree != null) {
            return;
        }
        this.numTree = new HashMap();
        for (Integer i2 : this.parentTree.keySet()) {
            PdfObject obj = this.parentTree.get(i2);
            if (obj.isArray()) {
                PdfArray ar = (PdfArray)obj;
                this.numTree.put(i2, this.writer.addToBody(ar).getIndirectReference());
                continue;
            }
            if (!(obj instanceof PdfIndirectReference)) continue;
            this.numTree.put(i2, (PdfIndirectReference)obj);
        }
    }

    public void mapRole(PdfName used, PdfName standard) {
        PdfDictionary rm = (PdfDictionary)this.get(PdfName.ROLEMAP);
        if (rm == null) {
            rm = new PdfDictionary();
            this.put(PdfName.ROLEMAP, rm);
        }
        rm.put(used, standard);
    }

    public void mapClass(PdfName name, PdfObject object) {
        if (this.classMap == null) {
            this.classMap = new PdfDictionary();
            this.classes = new HashMap();
        }
        this.classes.put(name, object);
    }

    void putIDTree(String record, PdfObject reference) {
        if (this.idTreeMap == null) {
            this.idTreeMap = new HashMap();
        }
        this.idTreeMap.put(record, reference);
    }

    public PdfObject getMappedClass(PdfName name) {
        if (this.classes == null) {
            return null;
        }
        return this.classes.get(name);
    }

    public PdfWriter getWriter() {
        return this.writer;
    }

    public HashMap<Integer, PdfIndirectReference> getNumTree() throws IOException {
        if (this.numTree == null) {
            this.createNumTree();
        }
        return this.numTree;
    }

    public PdfIndirectReference getReference() {
        return this.reference;
    }

    void setPageMark(int page, PdfIndirectReference struc) {
        Integer i2 = page;
        PdfArray ar = (PdfArray)this.parentTree.get(i2);
        if (ar == null) {
            ar = new PdfArray();
            this.parentTree.put(i2, ar);
        }
        ar.add(struc);
    }

    void setAnnotationMark(int structParentIndex, PdfIndirectReference struc) {
        this.parentTree.put(structParentIndex, struc);
    }

    private void nodeProcess(PdfDictionary struc, PdfIndirectReference reference) throws IOException {
        PdfObject obj = struc.get(PdfName.K);
        if (obj != null && obj.isArray()) {
            PdfArray ar = (PdfArray)obj;
            for (int k2 = 0; k2 < ar.size(); ++k2) {
                PdfDictionary dictionary = ar.getAsDict(k2);
                if (dictionary == null || !PdfName.STRUCTELEM.equals(dictionary.get(PdfName.TYPE)) || !(ar.getPdfObject(k2) instanceof PdfStructureElement)) continue;
                PdfStructureElement e2 = (PdfStructureElement)dictionary;
                ar.set(k2, e2.getReference());
                this.nodeProcess(e2, e2.getReference());
            }
        }
        if (reference != null) {
            this.writer.addToBody((PdfObject)struc, reference);
        }
    }

    void buildTree() throws IOException {
        this.createNumTree();
        PdfDictionary dicTree = PdfNumberTree.writeTree(this.numTree, this.writer);
        if (dicTree != null) {
            this.put(PdfName.PARENTTREE, this.writer.addToBody(dicTree).getIndirectReference());
        }
        if (this.classMap != null && !this.classes.isEmpty()) {
            for (Map.Entry<PdfName, PdfObject> entry : this.classes.entrySet()) {
                PdfObject value = entry.getValue();
                if (value.isDictionary()) {
                    this.classMap.put(entry.getKey(), this.writer.addToBody(value).getIndirectReference());
                    continue;
                }
                if (!value.isArray()) continue;
                PdfArray newArray = new PdfArray();
                PdfArray array = (PdfArray)value;
                for (int i2 = 0; i2 < array.size(); ++i2) {
                    if (!array.getPdfObject(i2).isDictionary()) continue;
                    newArray.add(this.writer.addToBody(array.getAsDict(i2)).getIndirectReference());
                }
                this.classMap.put(entry.getKey(), newArray);
            }
            this.put(PdfName.CLASSMAP, this.writer.addToBody(this.classMap).getIndirectReference());
        }
        if (this.idTreeMap != null && !this.idTreeMap.isEmpty()) {
            PdfDictionary dic = PdfNameTree.writeTree(this.idTreeMap, this.writer);
            this.put(PdfName.IDTREE, dic);
        }
        this.nodeProcess(this, this.reference);
    }

    @Override
    public PdfObject getAttribute(PdfName name) {
        PdfDictionary attr = this.getAsDict(PdfName.A);
        if (attr != null && attr.contains(name)) {
            return attr.get(name);
        }
        return null;
    }

    @Override
    public void setAttribute(PdfName name, PdfObject obj) {
        PdfDictionary attr = this.getAsDict(PdfName.A);
        if (attr == null) {
            attr = new PdfDictionary();
            this.put(PdfName.A, attr);
        }
        attr.put(name, obj);
    }
}

