/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.internal;

import com.itextpdf.text.pdf.PdfAConformanceLevel;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.RefKey;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PdfAChecker {
    protected PdfAConformanceLevel conformanceLevel;
    protected HashMap<RefKey, PdfObject> cachedObjects = new HashMap();
    private HashSet<PdfName> keysForCheck = this.initKeysForCheck();
    private static byte[] emptyByteArray = new byte[0];

    PdfAChecker(PdfAConformanceLevel conformanceLevel) {
        this.conformanceLevel = conformanceLevel;
    }

    protected abstract HashSet<PdfName> initKeysForCheck();

    public void cacheObject(PdfIndirectReference iref, PdfObject obj) {
        if (obj.type() == 0) {
            this.cachedObjects.put(new RefKey(iref), obj);
        } else if (obj instanceof PdfDictionary) {
            this.cachedObjects.put(new RefKey(iref), this.cleverPdfDictionaryClone((PdfDictionary)obj));
        } else if (obj.isArray()) {
            this.cachedObjects.put(new RefKey(iref), this.cleverPdfArrayClone((PdfArray)obj));
        }
    }

    public abstract void close(PdfWriter var1);

    private PdfObject cleverPdfArrayClone(PdfArray array) {
        PdfArray newArray = new PdfArray();
        for (int i2 = 0; i2 < array.size(); ++i2) {
            PdfObject obj = array.getPdfObject(i2);
            if (obj instanceof PdfDictionary) {
                newArray.add(this.cleverPdfDictionaryClone((PdfDictionary)obj));
                continue;
            }
            newArray.add(obj);
        }
        return newArray;
    }

    private PdfObject cleverPdfDictionaryClone(PdfDictionary dict) {
        PdfDictionary newDict;
        if (dict.isStream()) {
            newDict = new PdfStream(emptyByteArray);
            newDict.remove(PdfName.LENGTH);
        } else {
            newDict = new PdfDictionary();
        }
        for (PdfName key : dict.getKeys()) {
            if (!this.keysForCheck.contains(key)) continue;
            newDict.put(key, dict.get(key));
        }
        return newDict;
    }

    protected PdfObject getDirectObject(PdfObject obj) {
        PdfObject curr;
        if (obj == null) {
            return null;
        }
        int count = 0;
        while (obj instanceof PdfIndirectReference && (curr = obj.isIndirect() ? PdfReader.getPdfObject(obj) : this.cachedObjects.get(new RefKey((PdfIndirectReference)obj))) != null) {
            obj = curr;
            if (count++ <= 10) continue;
            break;
        }
        return obj;
    }

    protected PdfDictionary getDirectDictionary(PdfObject obj) {
        if ((obj = this.getDirectObject(obj)) != null && obj instanceof PdfDictionary) {
            return (PdfDictionary)obj;
        }
        return null;
    }

    protected PdfStream getDirectStream(PdfObject obj) {
        if ((obj = this.getDirectObject(obj)) != null && obj.isStream()) {
            return (PdfStream)obj;
        }
        return null;
    }

    protected PdfArray getDirectArray(PdfObject obj) {
        if ((obj = this.getDirectObject(obj)) != null && obj.isArray()) {
            return (PdfArray)obj;
        }
        return null;
    }

    protected abstract void checkFont(PdfWriter var1, int var2, Object var3);

    protected abstract void checkImage(PdfWriter var1, int var2, Object var3);

    protected abstract void checkInlineImage(PdfWriter var1, int var2, Object var3);

    protected abstract void checkFormXObj(PdfWriter var1, int var2, Object var3);

    protected abstract void checkGState(PdfWriter var1, int var2, Object var3);

    protected abstract void checkLayer(PdfWriter var1, int var2, Object var3);

    protected abstract void checkTrailer(PdfWriter var1, int var2, Object var3);

    protected abstract void checkStream(PdfWriter var1, int var2, Object var3);

    protected abstract void checkFileSpec(PdfWriter var1, int var2, Object var3);

    protected abstract void checkPdfObject(PdfWriter var1, int var2, Object var3);

    protected abstract void checkCanvas(PdfWriter var1, int var2, Object var3);

    protected abstract void checkColor(PdfWriter var1, int var2, Object var3);

    protected abstract void checkAnnotation(PdfWriter var1, int var2, Object var3);

    protected abstract void checkAction(PdfWriter var1, int var2, Object var3);

    protected abstract void checkForm(PdfWriter var1, int var2, Object var3);

    protected abstract void checkStructElem(PdfWriter var1, int var2, Object var3);

    protected abstract void checkOutputIntent(PdfWriter var1, int var2, Object var3);

    void checkPdfAConformance(PdfWriter writer, int key, Object obj1) {
        if (writer == null || !writer.isPdfIso()) {
            return;
        }
        switch (key) {
            case 4: {
                this.checkFont(writer, key, obj1);
                break;
            }
            case 5: {
                this.checkImage(writer, key, obj1);
                break;
            }
            case 6: {
                this.checkGState(writer, key, obj1);
                break;
            }
            case 7: {
                this.checkLayer(writer, key, obj1);
                break;
            }
            case 8: {
                this.checkTrailer(writer, key, obj1);
                break;
            }
            case 9: {
                this.checkStream(writer, key, obj1);
                break;
            }
            case 10: {
                this.checkFileSpec(writer, key, obj1);
                break;
            }
            case 11: {
                this.checkPdfObject(writer, key, obj1);
                break;
            }
            case 12: {
                this.checkCanvas(writer, key, obj1);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.checkColor(writer, key, obj1);
                break;
            }
            case 13: {
                this.checkAnnotation(writer, key, obj1);
                break;
            }
            case 14: {
                this.checkAction(writer, key, obj1);
                break;
            }
            case 15: {
                this.checkForm(writer, key, obj1);
                break;
            }
            case 16: {
                if (!PdfAChecker.checkStructure(this.conformanceLevel)) break;
                this.checkStructElem(writer, key, obj1);
                break;
            }
            case 17: {
                this.checkInlineImage(writer, key, obj1);
                break;
            }
            case 19: {
                this.checkOutputIntent(writer, key, obj1);
                break;
            }
            case 20: {
                this.checkFormXObj(writer, key, obj1);
                break;
            }
        }
    }

    public static boolean checkStructure(PdfAConformanceLevel conformanceLevel) {
        return conformanceLevel == PdfAConformanceLevel.PDF_A_1A || conformanceLevel == PdfAConformanceLevel.PDF_A_2A || conformanceLevel == PdfAConformanceLevel.PDF_A_3A;
    }

    protected static boolean checkFlag(int flags, int flag) {
        return (flags & flag) != 0;
    }
}

