/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.mc;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfNumberTree;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.mc.StructureItem;
import com.itextpdf.text.pdf.mc.StructureMCID;
import com.itextpdf.text.pdf.mc.StructureObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructureItems
extends ArrayList<StructureItem> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(StructureItems.class);
    protected PdfDictionary structTreeRoot;
    protected HashMap<Integer, PdfObject> parentTree;
    private static final long serialVersionUID = -8247348202717165564L;

    public StructureItems(PdfReader reader) throws DocumentException {
        PdfDictionary catalog = reader.getCatalog();
        this.structTreeRoot = catalog.getAsDict(PdfName.STRUCTTREEROOT);
        if (this.structTreeRoot == null) {
            throw new DocumentException(MessageLocalization.getComposedMessage("can.t.read.document.structure", new Object[0]));
        }
        this.parentTree = PdfNumberTree.readTree(this.structTreeRoot.getAsDict(PdfName.PARENTTREE));
        this.structTreeRoot.remove(PdfName.STRUCTPARENTS);
        PdfObject object = this.structTreeRoot.getDirectObject(PdfName.K);
        if (object == null) {
            return;
        }
        switch (object.type()) {
            case 6: {
                LOGGER.info("StructTreeRoot refers to dictionary");
                this.processStructElems((PdfDictionary)object, this.structTreeRoot.getAsIndirectObject(PdfName.K));
                break;
            }
            case 5: {
                LOGGER.info("StructTreeRoot refers to array");
                PdfArray array = (PdfArray)object;
                for (int i2 = 0; i2 < array.size(); ++i2) {
                    this.processStructElems(array.getAsDict(i2), array.getAsIndirectObject(i2));
                }
                break;
            }
        }
    }

    protected void processStructElems(PdfDictionary structElem, PdfIndirectReference ref) {
        LOGGER.info(String.format("addStructureItems(%s, %s)", structElem, ref));
        if (structElem == null) {
            return;
        }
        this.processStructElemKids(structElem, ref, structElem.getDirectObject(PdfName.K));
    }

    protected void processStructElemKids(PdfDictionary structElem, PdfIndirectReference ref, PdfObject object) {
        LOGGER.info(String.format("addStructureItem(%s, %s, %s)", structElem, ref, object));
        if (object == null) {
            return;
        }
        switch (object.type()) {
            case 2: {
                StructureMCID item = new StructureMCID(structElem.getAsIndirectObject(PdfName.PG), (PdfNumber)object);
                this.add(item);
                LOGGER.info("Added " + item);
                break;
            }
            case 5: {
                PdfArray array = (PdfArray)object;
                for (int i2 = 0; i2 < array.size(); ++i2) {
                    this.processStructElemKids(structElem, array.getAsIndirectObject(i2), array.getDirectObject(i2));
                }
                break;
            }
            case 6: {
                PdfDictionary dict = (PdfDictionary)object;
                if (dict.checkType(PdfName.MCR)) {
                    StructureMCID item = new StructureMCID(dict);
                    this.add(item);
                    LOGGER.info("Added " + item);
                    break;
                }
                if (dict.checkType(PdfName.OBJR)) {
                    StructureObject item = new StructureObject(structElem, ref, dict);
                    this.add(item);
                    LOGGER.info("Added " + item);
                    break;
                }
                this.processStructElems(dict, ref);
            }
        }
    }

    public void removeFromParentTree(PdfNumber structParent) {
        this.parentTree.remove(structParent.intValue());
    }

    public int processMCID(PdfNumber structParents, PdfIndirectReference ref) throws DocumentException {
        if (ref == null) {
            throw new DocumentException(MessageLocalization.getComposedMessage("can.t.read.document.structure", new Object[0]));
        }
        PdfObject object = this.parentTree.get(structParents.intValue());
        PdfArray array = (PdfArray)PdfReader.getPdfObject(object);
        for (int i2 = 0; i2 < array.size(); ++i2) {
            if (array.getAsIndirectObject(i2) != null) continue;
            array.set(i2, ref);
            return i2;
        }
        array.add(ref);
        return array.size() - 1;
    }

    public void writeParentTree(PdfWriter writer) throws IOException {
        if (this.structTreeRoot == null) {
            return;
        }
        Object[] numbers = new Integer[this.parentTree.size()];
        numbers = this.parentTree.keySet().toArray(numbers);
        Arrays.sort(numbers);
        this.structTreeRoot.put(PdfName.PARENTTREENEXTKEY, new PdfNumber((Integer)numbers[numbers.length - 1] + 1));
        this.structTreeRoot.put(PdfName.PARENTTREE, PdfNumberTree.writeTree(this.parentTree, writer));
    }
}

