/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.ocg;

import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.ocg.OCGParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCGRemover {
    public void removeLayers(PdfReader reader, String ... layers) throws IOException {
        int n2 = reader.getNumberOfPages();
        for (int i2 = 1; i2 <= n2; ++i2) {
            reader.setPageContent(i2, reader.getPageContent(i2));
        }
        HashSet<String> ocgs = new HashSet<String>();
        for (int i3 = 0; i3 < layers.length; ++i3) {
            ocgs.add(layers[i3]);
        }
        OCGParser parser = new OCGParser(ocgs);
        for (int i4 = 1; i4 <= n2; ++i4) {
            PdfDictionary page = reader.getPageN(i4);
            this.parse(parser, page);
            page.remove(PdfName.PIECEINFO);
            this.removeAnnots(page, ocgs);
            this.removeProperties(page, ocgs);
        }
        PdfDictionary root = reader.getCatalog();
        PdfDictionary ocproperties = root.getAsDict(PdfName.OCPROPERTIES);
        if (ocproperties != null) {
            PdfArray ocgsArray;
            this.removeOCGsFromArray(ocproperties, PdfName.OCGS, ocgs);
            PdfDictionary d2 = ocproperties.getAsDict(PdfName.D);
            if (d2 != null) {
                this.removeOCGsFromArray(d2, PdfName.ON, ocgs);
                this.removeOCGsFromArray(d2, PdfName.OFF, ocgs);
                this.removeOCGsFromArray(d2, PdfName.LOCKED, ocgs);
                this.removeOCGsFromArray(d2, PdfName.RBGROUPS, ocgs);
                this.removeOCGsFromArray(d2, PdfName.ORDER, ocgs);
                this.removeOCGsFromArray(d2, PdfName.AS, ocgs);
            }
            if ((ocgsArray = ocproperties.getAsArray(PdfName.OCGS)) != null && ocgsArray.isEmpty()) {
                root.remove(PdfName.OCPROPERTIES);
                if (PdfName.USEOC.equals(root.getAsName(PdfName.PAGEMODE))) {
                    root.remove(PdfName.PAGEMODE);
                }
            }
        }
        reader.removeUnusedObjects();
    }

    private void removeOCGsFromArray(PdfDictionary dict, PdfName name, Set<String> ocgs) {
        if (dict == null) {
            return;
        }
        PdfArray array = dict.getAsArray(name);
        if (array == null) {
            return;
        }
        this.removeOCGsFromArray(array, ocgs);
    }

    private void removeOCGsFromArray(PdfArray array, Set<String> ocgs) {
        if (array == null) {
            return;
        }
        ArrayList<Integer> remove = new ArrayList<Integer>();
        int i2 = array.size();
        while (i2 > 0) {
            PdfObject o2;
            if ((o2 = array.getDirectObject(--i2)).isDictionary()) {
                PdfDictionary dict = (PdfDictionary)o2;
                if (this.isToBeRemoved(dict, ocgs)) {
                    remove.add(i2);
                } else {
                    this.removeOCGsFromArray(dict, PdfName.OCGS, ocgs);
                }
            }
            if (!o2.isArray()) continue;
            this.removeOCGsFromArray((PdfArray)o2, ocgs);
        }
        for (Integer i3 : remove) {
            array.remove(i3);
        }
    }

    private void removeAnnots(PdfDictionary page, Set<String> ocgs) {
        PdfArray annots = page.getAsArray(PdfName.ANNOTS);
        if (annots == null) {
            return;
        }
        ArrayList<Integer> remove = new ArrayList<Integer>();
        int i2 = annots.size();
        while (i2 > 0) {
            PdfDictionary annot;
            if (this.isToBeRemoved((annot = annots.getAsDict(--i2)).getAsDict(PdfName.OC), ocgs)) {
                remove.add(i2);
                continue;
            }
            this.removeOCGsFromArray(annot.getAsDict(PdfName.A), PdfName.STATE, ocgs);
        }
        for (Integer i3 : remove) {
            annots.remove(i3);
        }
    }

    private void removeProperties(PdfDictionary page, Set<String> ocgs) {
        PdfDictionary resources = page.getAsDict(PdfName.RESOURCES);
        if (resources == null) {
            return;
        }
        PdfDictionary properties = resources.getAsDict(PdfName.PROPERTIES);
        if (properties == null) {
            return;
        }
        Set<PdfName> names = properties.getKeys();
        ArrayList<PdfName> remove = new ArrayList<PdfName>();
        for (PdfName name : names) {
            PdfDictionary dict = properties.getAsDict(name);
            if (this.isToBeRemoved(dict, ocgs)) {
                remove.add(name);
                continue;
            }
            this.removeOCGsFromArray(dict, PdfName.OCGS, ocgs);
        }
        for (PdfName name : remove) {
            properties.remove(name);
        }
    }

    private boolean isToBeRemoved(PdfDictionary ocg, Set<String> names) {
        if (ocg == null) {
            return false;
        }
        PdfString n2 = ocg.getAsString(PdfName.NAME);
        if (n2 == null) {
            return false;
        }
        return names.contains(n2.toString());
    }

    private void parse(OCGParser parser, PdfDictionary page) throws IOException {
        PRStream stream = (PRStream)page.getAsStream(PdfName.CONTENTS);
        PdfDictionary resources = page.getAsDict(PdfName.RESOURCES);
        parser.parse(stream, resources);
    }
}

