/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.pdf.DocumentFont;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.parser.GraphicsState;
import com.itextpdf.text.pdf.parser.LineSegment;
import com.itextpdf.text.pdf.parser.MarkedContentInfo;
import com.itextpdf.text.pdf.parser.Matrix;
import com.itextpdf.text.pdf.parser.Vector;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextRenderInfo {
    private final PdfString string;
    private String text = null;
    private final Matrix textToUserSpaceTransformMatrix;
    private final GraphicsState gs;
    private Float unscaledWidth = null;
    private final Collection<MarkedContentInfo> markedContentInfos;

    TextRenderInfo(PdfString string, GraphicsState gs, Matrix textMatrix, Collection<MarkedContentInfo> markedContentInfo) {
        this.string = string;
        this.textToUserSpaceTransformMatrix = textMatrix.multiply(gs.ctm);
        this.gs = gs;
        this.markedContentInfos = new ArrayList<MarkedContentInfo>(markedContentInfo);
    }

    private TextRenderInfo(TextRenderInfo parent, PdfString string, float horizontalOffset) {
        this.string = string;
        this.textToUserSpaceTransformMatrix = new Matrix(horizontalOffset, 0.0f).multiply(parent.textToUserSpaceTransformMatrix);
        this.gs = parent.gs;
        this.markedContentInfos = parent.markedContentInfos;
    }

    public String getText() {
        if (this.text == null) {
            this.text = this.decode(this.string);
        }
        return this.text;
    }

    public PdfString getPdfString() {
        return this.string;
    }

    public boolean hasMcid(int mcid) {
        return this.hasMcid(mcid, false);
    }

    public boolean hasMcid(int mcid, boolean checkTheTopmostLevelOnly) {
        if (checkTheTopmostLevelOnly) {
            if (this.markedContentInfos instanceof ArrayList) {
                Integer infoMcid = this.getMcid();
                return infoMcid != null ? infoMcid == mcid : false;
            }
        } else {
            for (MarkedContentInfo info : this.markedContentInfos) {
                if (!info.hasMcid() || info.getMcid() != mcid) continue;
                return true;
            }
        }
        return false;
    }

    public Integer getMcid() {
        if (this.markedContentInfos instanceof ArrayList) {
            ArrayList mci = (ArrayList)this.markedContentInfos;
            MarkedContentInfo info = mci.size() > 0 ? (MarkedContentInfo)mci.get(mci.size() - 1) : null;
            return info != null && info.hasMcid() ? Integer.valueOf(info.getMcid()) : null;
        }
        return null;
    }

    float getUnscaledWidth() {
        if (this.unscaledWidth == null) {
            this.unscaledWidth = Float.valueOf(this.getPdfStringWidth(this.string, false));
        }
        return this.unscaledWidth.floatValue();
    }

    public LineSegment getBaseline() {
        return this.getUnscaledBaselineWithOffset(0.0f + this.gs.rise).transformBy(this.textToUserSpaceTransformMatrix);
    }

    public LineSegment getUnscaledBaseline() {
        return this.getUnscaledBaselineWithOffset(0.0f + this.gs.rise);
    }

    public LineSegment getAscentLine() {
        float ascent = this.gs.getFont().getFontDescriptor(1, this.gs.getFontSize());
        return this.getUnscaledBaselineWithOffset(ascent + this.gs.rise).transformBy(this.textToUserSpaceTransformMatrix);
    }

    public LineSegment getDescentLine() {
        float descent = this.gs.getFont().getFontDescriptor(3, this.gs.getFontSize());
        return this.getUnscaledBaselineWithOffset(descent + this.gs.rise).transformBy(this.textToUserSpaceTransformMatrix);
    }

    private LineSegment getUnscaledBaselineWithOffset(float yOffset) {
        String unicodeStr = this.string.toUnicodeString();
        float correctedUnscaledWidth = this.getUnscaledWidth() - (this.gs.characterSpacing + (unicodeStr.length() > 0 && unicodeStr.charAt(unicodeStr.length() - 1) == ' ' ? this.gs.wordSpacing : 0.0f)) * this.gs.horizontalScaling;
        return new LineSegment(new Vector(0.0f, yOffset, 1.0f), new Vector(correctedUnscaledWidth, yOffset, 1.0f));
    }

    public DocumentFont getFont() {
        return this.gs.getFont();
    }

    public float getRise() {
        if (this.gs.rise == 0.0f) {
            return 0.0f;
        }
        return this.convertHeightFromTextSpaceToUserSpace(this.gs.rise);
    }

    private float convertWidthFromTextSpaceToUserSpace(float width) {
        LineSegment textSpace = new LineSegment(new Vector(0.0f, 0.0f, 1.0f), new Vector(width, 0.0f, 1.0f));
        LineSegment userSpace = textSpace.transformBy(this.textToUserSpaceTransformMatrix);
        return userSpace.getLength();
    }

    private float convertHeightFromTextSpaceToUserSpace(float height) {
        LineSegment textSpace = new LineSegment(new Vector(0.0f, 0.0f, 1.0f), new Vector(0.0f, height, 1.0f));
        LineSegment userSpace = textSpace.transformBy(this.textToUserSpaceTransformMatrix);
        return userSpace.getLength();
    }

    public float getSingleSpaceWidth() {
        return this.convertWidthFromTextSpaceToUserSpace(this.getUnscaledFontSpaceWidth());
    }

    public int getTextRenderMode() {
        return this.gs.renderMode;
    }

    public BaseColor getFillColor() {
        return this.gs.fillColor;
    }

    public BaseColor getStrokeColor() {
        return this.gs.strokeColor;
    }

    private float getUnscaledFontSpaceWidth() {
        char charToUse = ' ';
        if (this.gs.font.getWidth(charToUse) == 0) {
            charToUse = '\u00a0';
        }
        return this.getStringWidth(String.valueOf(charToUse));
    }

    private float getStringWidth(String string) {
        float totalWidth = 0.0f;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            float w = (float)this.gs.font.getWidth(c2) / 1000.0f;
            float wordSpacing = c2 == ' ' ? this.gs.wordSpacing : 0.0f;
            totalWidth += (w * this.gs.fontSize + this.gs.characterSpacing + wordSpacing) * this.gs.horizontalScaling;
        }
        return totalWidth;
    }

    private float getPdfStringWidth(PdfString string, boolean singleCharString) {
        if (singleCharString) {
            float[] widthAndWordSpacing = this.getWidthAndWordSpacing(string, singleCharString);
            return (widthAndWordSpacing[0] * this.gs.fontSize + this.gs.characterSpacing + widthAndWordSpacing[1]) * this.gs.horizontalScaling;
        }
        float totalWidth = 0.0f;
        for (PdfString str : this.splitString(string)) {
            totalWidth += this.getPdfStringWidth(str, true);
        }
        return totalWidth;
    }

    public List<TextRenderInfo> getCharacterRenderInfos() {
        ArrayList<TextRenderInfo> rslt = new ArrayList<TextRenderInfo>(this.string.length());
        PdfString[] strings = this.splitString(this.string);
        float totalWidth = 0.0f;
        for (int i2 = 0; i2 < strings.length; ++i2) {
            float[] widthAndWordSpacing = this.getWidthAndWordSpacing(strings[i2], true);
            TextRenderInfo subInfo = new TextRenderInfo(this, strings[i2], totalWidth);
            rslt.add(subInfo);
            totalWidth += (widthAndWordSpacing[0] * this.gs.fontSize + this.gs.characterSpacing + widthAndWordSpacing[1]) * this.gs.horizontalScaling;
        }
        for (TextRenderInfo tri : rslt) {
            tri.getUnscaledWidth();
        }
        return rslt;
    }

    private float[] getWidthAndWordSpacing(PdfString string, boolean singleCharString) {
        if (!singleCharString) {
            throw new UnsupportedOperationException();
        }
        float[] result = new float[2];
        String decoded = this.decode(string);
        result[0] = (float)this.gs.font.getWidth(this.getCharCode(decoded)) / 1000.0f;
        result[1] = decoded.equals(" ") ? this.gs.wordSpacing : 0.0f;
        return result;
    }

    private String decode(PdfString in) {
        byte[] bytes = in.getBytes();
        return this.gs.font.decode(bytes, 0, bytes.length);
    }

    private int getCharCode(String string) {
        try {
            byte[] b2 = string.getBytes("UTF-16BE");
            int value = 0;
            for (int i2 = 0; i2 < b2.length - 1; ++i2) {
                value += b2[i2] & 0xFF;
                value <<= 8;
            }
            if (b2.length > 0) {
                value += b2[b2.length - 1] & 0xFF;
            }
            return value;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return 0;
        }
    }

    private PdfString[] splitString(PdfString string) {
        ArrayList<PdfString> strings = new ArrayList<PdfString>();
        String stringValue = string.toString();
        for (int i2 = 0; i2 < stringValue.length(); ++i2) {
            PdfString newString = new PdfString(stringValue.substring(i2, i2 + 1), string.getEncoding());
            String text = this.decode(newString);
            if (text.length() == 0 && i2 < stringValue.length() - 1) {
                newString = new PdfString(stringValue.substring(i2, i2 + 2), string.getEncoding());
                ++i2;
            }
            strings.add(newString);
        }
        return strings.toArray(new PdfString[strings.size()]);
    }
}

