/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.pdfcleanup;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.DocWriter;
import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.BadPdfFormatException;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfImage;
import com.itextpdf.text.pdf.PdfLiteral;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.parser.ContentOperator;
import com.itextpdf.text.pdf.parser.PdfContentStreamProcessor;
import com.itextpdf.text.pdf.pdfcleanup.PdfCleanUpContentChunk;
import com.itextpdf.text.pdf.pdfcleanup.PdfCleanUpContext;
import com.itextpdf.text.pdf.pdfcleanup.PdfCleanUpRenderListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PdfCleanUpContentOperator
implements ContentOperator {
    private static final byte[] TStar = DocWriter.getISOBytes("T*\n");
    private static final byte[] Tw = DocWriter.getISOBytes(" Tw ");
    private static final byte[] TcTStar = DocWriter.getISOBytes(" Tc T*\n");
    private static final byte[] TJ = DocWriter.getISOBytes("] TJ\n");
    private static final byte[] Tc = DocWriter.getISOBytes(" Tc\n");
    private static final Set<String> textShowingOperators = new HashSet<String>(){
        {
            this.add("TJ");
            this.add("Tj");
            this.add("'");
            this.add("\"");
        }
    };
    protected PdfCleanUpRenderListener cleanUpStrategy;
    protected ContentOperator originalContentOperator;

    public static void populateOperators(PdfContentStreamProcessor contentProcessor, PdfCleanUpRenderListener pdfCleanUpRenderListener) {
        String[] operators;
        for (String operator : operators = new String[]{"DefaultOperator", "q", "Q", "g", "G", "rg", "RG", "k", "K", "cs", "CS", "sc", "SC", "scn", "SCN", "cm", "gs", "Tc", "Tw", "Tz", "TL", "Tf", "Tr", "Ts", "BT", "ET", "BMC", "BDC", "EMC", "Td", "TD", "Tm", "T*", "Tj", "'", "\"", "TJ", "Do"}) {
            PdfCleanUpContentOperator contentOperator = new PdfCleanUpContentOperator(pdfCleanUpRenderListener);
            contentOperator.originalContentOperator = contentProcessor.registerContentOperator(operator, contentOperator);
        }
    }

    public PdfCleanUpContentOperator(PdfCleanUpRenderListener cleanUpStrategy) {
        this.cleanUpStrategy = cleanUpStrategy;
    }

    @Override
    public void invoke(PdfContentStreamProcessor pdfContentStreamProcessor, PdfLiteral operator, ArrayList<PdfObject> operands) throws Exception {
        PdfStream xObj;
        PdfDictionary xObjResources;
        String operatorStr = operator.toString();
        PdfContentByte canvas = this.cleanUpStrategy.getContext().getCanvas();
        PRStream xFormStream = null;
        Map<Integer, Float> structuredTJoperands = null;
        if ("Do".equals(operatorStr) && operands.size() == 2 && operands.get(0).isName() && (xObjResources = this.cleanUpStrategy.getContext().getResources().getAsDict(PdfName.XOBJECT)) != null && (xObj = xObjResources.getAsStream((PdfName)operands.get(0))) instanceof PRStream && xObj.getAsName(PdfName.SUBTYPE) != null && xObj.getAsName(PdfName.SUBTYPE).compareTo(PdfName.FORM) == 0) {
            xFormStream = (PRStream)xObj;
            this.cleanUpStrategy.registerNewContext(xObj.getAsDict(PdfName.RESOURCES), null);
        }
        this.originalContentOperator.invoke(pdfContentStreamProcessor, operator, operands);
        List<PdfCleanUpContentChunk> chunks = this.cleanUpStrategy.getChunks();
        boolean disableOutput = false;
        if (xFormStream != null) {
            xFormStream.setData(this.cleanUpStrategy.getContext().getCanvas().toPdf(this.cleanUpStrategy.getContext().getCanvas().getPdfWriter()));
            this.cleanUpStrategy.popContext();
            canvas = this.cleanUpStrategy.getContext().getCanvas();
        }
        if ("Do".equals(operatorStr)) {
            if (chunks.size() > 0 && chunks.get(0).isImage()) {
                PdfCleanUpContentChunk chunk = chunks.get(0);
                if (chunk.isVisible()) {
                    PdfDictionary xObjResources2 = this.cleanUpStrategy.getContext().getResources().getAsDict(PdfName.XOBJECT);
                    PRStream imageStream = (PRStream)xObjResources2.getAsStream((PdfName)operands.get(0));
                    this.updateImage(imageStream, chunk.getNewImageData());
                } else {
                    disableOutput = true;
                }
            }
        } else if ("q".equals(operatorStr)) {
            this.cleanUpStrategy.getContext().saveGraphicsState();
        } else if ("Q".equals(operatorStr)) {
            this.cleanUpStrategy.getContext().restoreGraphicsState();
        } else if ("Tf".equals(operatorStr)) {
            this.cleanUpStrategy.getContext().setFontSize(((PdfNumber)operands.get(1)).floatValue());
        } else if ("Tc".equals(operatorStr)) {
            this.cleanUpStrategy.getContext().setCharacterSpacing(((PdfNumber)operands.get(0)).floatValue());
        } else if ("Tw".equals(operatorStr)) {
            this.cleanUpStrategy.getContext().setWordSpacing(((PdfNumber)operands.get(0)).floatValue());
        } else if ("Tz".equals(operatorStr)) {
            this.cleanUpStrategy.getContext().setHorizontalScaling(((PdfNumber)operands.get(0)).floatValue());
        } else if (textShowingOperators.contains(operatorStr) && !this.allChunksAreVisible(this.cleanUpStrategy.getChunks())) {
            disableOutput = true;
            if ("'".equals(operatorStr)) {
                canvas.getInternalBuffer().append(TStar);
            } else if ("\"".equals(operatorStr)) {
                operands.get(0).toPdf(canvas.getPdfWriter(), canvas.getInternalBuffer());
                canvas.getInternalBuffer().append(Tw);
                operands.get(1).toPdf(canvas.getPdfWriter(), canvas.getInternalBuffer());
                canvas.getInternalBuffer().append(TcTStar);
                this.cleanUpStrategy.getContext().setCharacterSpacing(((PdfNumber)operands.get(1)).floatValue());
            } else if ("TJ".equals(operatorStr)) {
                structuredTJoperands = this.structureTJarray((PdfArray)operands.get(0));
            }
            this.renderChunks(structuredTJoperands, chunks, canvas);
        } else if ("\"".equals(operatorStr)) {
            this.cleanUpStrategy.getContext().setCharacterSpacing(((PdfNumber)operands.get(1)).floatValue());
        }
        if (!disableOutput) {
            int index = 0;
            for (PdfObject o2 : operands) {
                PdfCleanUpContentOperator.toPdf(o2, canvas.getPdfWriter(), canvas.getInternalBuffer());
                canvas.getInternalBuffer().append(operands.size() > ++index ? (byte)32 : 10);
            }
        }
        this.cleanUpStrategy.clearChunks();
    }

    private boolean allChunksAreVisible(List<PdfCleanUpContentChunk> chunks) {
        for (PdfCleanUpContentChunk chunk : chunks) {
            if (chunk.isVisible()) continue;
            return false;
        }
        return true;
    }

    private static void toPdf(PdfObject object, PdfWriter writer, OutputStream os) throws IOException {
        if (object instanceof PdfDictionary) {
            os.write(60);
            os.write(60);
            ArrayList<PdfName> keys = new ArrayList<PdfName>(((PdfDictionary)object).getKeys());
            Collections.sort(keys);
            for (PdfName key : keys) {
                PdfCleanUpContentOperator.toPdf(key, writer, os);
                PdfObject value = ((PdfDictionary)object).get(key);
                int type = value.type();
                if (type != 5 && type != 6 && type != 4 && type != 3) {
                    os.write(32);
                }
                PdfCleanUpContentOperator.toPdf(value, writer, os);
            }
            os.write(62);
            os.write(62);
        } else {
            object.toPdf(writer, os);
        }
    }

    private Map<Integer, Float> structureTJarray(PdfArray array) {
        HashMap<Integer, Float> structuredTJoperands = new HashMap<Integer, Float>();
        if (array.size() == 0) {
            return structuredTJoperands;
        }
        Integer previousStrNum = 0;
        structuredTJoperands.put(previousStrNum, Float.valueOf(0.0f));
        for (int i2 = 0; i2 < array.size(); ++i2) {
            PdfObject currentObj = array.getPdfObject(i2);
            if (currentObj instanceof PdfString && ((PdfString)currentObj).toUnicodeString().length() > 0) {
                previousStrNum = previousStrNum + 1;
                structuredTJoperands.put(previousStrNum, Float.valueOf(0.0f));
                continue;
            }
            Float oldOffset = (Float)structuredTJoperands.get(previousStrNum);
            structuredTJoperands.put(previousStrNum, Float.valueOf(oldOffset.floatValue() + ((PdfNumber)currentObj).floatValue()));
        }
        return structuredTJoperands;
    }

    private void renderChunks(Map<Integer, Float> structuredTJoperands, List<PdfCleanUpContentChunk> chunks, PdfContentByte canvas) throws IOException {
        canvas.setCharacterSpacing(0.0f);
        canvas.setWordSpacing(0.0f);
        canvas.getInternalBuffer().append((byte)91);
        float characterSpacing = this.cleanUpStrategy.getContext().getCharacterSpacing();
        float convertedCharacterSpacing = -characterSpacing * 1000.0f / this.cleanUpStrategy.getContext().getFontSize();
        float wordSpacing = this.cleanUpStrategy.getContext().getWordSpacing();
        float convertedWordSpacing = -wordSpacing * 1000.0f / this.cleanUpStrategy.getContext().getFontSize();
        float shift = structuredTJoperands != null ? structuredTJoperands.get(0).floatValue() : 0.0f;
        PdfCleanUpContentChunk prevChunk = null;
        for (PdfCleanUpContentChunk chunk : chunks) {
            if (prevChunk != null && prevChunk.getNumOfStrChunkBelongsTo() != chunk.getNumOfStrChunkBelongsTo() && structuredTJoperands != null) {
                shift += structuredTJoperands.get(prevChunk.getNumOfStrChunkBelongsTo()).floatValue();
            }
            if (chunk.isVisible()) {
                if (Float.compare(shift, 0.0f) != 0 && Float.compare(shift, -0.0f) != 0) {
                    canvas.getInternalBuffer().append(shift).append(' ');
                }
                chunk.getText().toPdf(canvas.getPdfWriter(), canvas.getInternalBuffer());
                canvas.getInternalBuffer().append(' ');
                shift = convertedCharacterSpacing + (this.isSpace(chunk) ? convertedWordSpacing : 0.0f);
            } else {
                float unscaledChunkWidth = this.getUnscaledChunkWidth(chunk);
                shift += unscaledChunkWidth;
            }
            prevChunk = chunk;
        }
        if (Float.compare(shift, 0.0f) != 0 && Float.compare(shift, -0.0f) != 0) {
            canvas.getInternalBuffer().append(shift);
        }
        canvas.getInternalBuffer().append(TJ);
        if (Float.compare(characterSpacing, 0.0f) != 0 && Float.compare(characterSpacing, -0.0f) != 0) {
            new PdfNumber(characterSpacing).toPdf(canvas.getPdfWriter(), canvas.getInternalBuffer());
            canvas.getInternalBuffer().append(Tc);
        }
        if (Float.compare(wordSpacing, 0.0f) != 0 && Float.compare(wordSpacing, -0.0f) != 0) {
            new PdfNumber(wordSpacing).toPdf(canvas.getPdfWriter(), canvas.getInternalBuffer());
            canvas.getInternalBuffer().append(Tw);
        }
    }

    private float getUnscaledChunkWidth(PdfCleanUpContentChunk chunk) {
        PdfCleanUpContext context = this.cleanUpStrategy.getContext();
        float fontSize = context.getFontSize();
        float characterSpacing = context.getCharacterSpacing();
        float wordSpacing = context.getWordSpacing();
        float horizontalScaling = context.getHorizontalScaling();
        float scaledChunkWidth = (chunk.getEndX() - chunk.getStartX()) * 100.0f + (characterSpacing + (this.isSpace(chunk) ? wordSpacing : 0.0f)) * horizontalScaling;
        return -scaledChunkWidth * 1000.0f / (horizontalScaling * fontSize);
    }

    private boolean isSpace(PdfCleanUpContentChunk chunk) {
        return chunk.getText().toUnicodeString().equals(" ");
    }

    private void updateImage(PRStream imageStream, byte[] newData) throws BadElementException, IOException, BadPdfFormatException {
        PdfImage image = new PdfImage(Image.getInstance(newData), "", null);
        if (imageStream.contains(PdfName.SMASK)) {
            image.put(PdfName.SMASK, imageStream.get(PdfName.SMASK));
        }
        if (imageStream.contains(PdfName.MASK)) {
            image.put(PdfName.MASK, imageStream.get(PdfName.MASK));
        }
        if (imageStream.contains(PdfName.SMASKINDATA)) {
            image.put(PdfName.SMASKINDATA, imageStream.get(PdfName.SMASKINDATA));
        }
        imageStream.clear();
        imageStream.putAll(image);
        imageStream.setDataRaw(image.getBytes());
    }
}

