/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.pdfcleanup;

import com.itextpdf.awt.geom.AffineTransform;
import com.itextpdf.awt.geom.Point;
import com.itextpdf.awt.geom.Point2D;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.parser.ImageRenderInfo;
import com.itextpdf.text.pdf.parser.LineSegment;
import com.itextpdf.text.pdf.parser.Matrix;
import com.itextpdf.text.pdf.parser.RenderFilter;
import com.itextpdf.text.pdf.parser.TextRenderInfo;
import com.itextpdf.text.pdf.pdfcleanup.PdfCleanUpCoveredArea;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

class PdfCleanUpRegionFilter
extends RenderFilter {
    private Rectangle rectangle;

    public PdfCleanUpRegionFilter(Rectangle rectangle) {
        this.rectangle = rectangle;
    }

    public boolean allowText(TextRenderInfo renderInfo) {
        LineSegment ascent = renderInfo.getAscentLine();
        LineSegment descent = renderInfo.getDescentLine();
        Rectangle r1 = new Rectangle(Math.min(descent.getStartPoint().get(0), descent.getEndPoint().get(0)), descent.getStartPoint().get(1), Math.max(descent.getStartPoint().get(0), descent.getEndPoint().get(0)), ascent.getEndPoint().get(1));
        Rectangle r2 = this.rectangle;
        return this.intersect(r1, r2);
    }

    public boolean allowImage(ImageRenderInfo renderInfo) {
        throw new NotImplementedException();
    }

    protected PdfCleanUpCoveredArea intersection(ImageRenderInfo renderInfo) {
        Rectangle imageRect = this.calcImageRect(renderInfo);
        if (imageRect == null) {
            return null;
        }
        Rectangle intersectionRect = this.intersection(imageRect, this.rectangle);
        Rectangle transformedIntersection = null;
        if (intersectionRect != null) {
            transformedIntersection = this.shearCoordinatesAndInverseY(imageRect.getLeft(), imageRect.getTop(), intersectionRect);
        }
        return new PdfCleanUpCoveredArea(transformedIntersection, imageRect.equals(intersectionRect));
    }

    private boolean intersect(Rectangle r1, Rectangle r2) {
        return r1.getLeft() < r2.getRight() && r1.getRight() > r2.getLeft() && r1.getBottom() < r2.getTop() && r1.getTop() > r2.getBottom();
    }

    private Rectangle calcImageRect(ImageRenderInfo renderInfo) {
        Matrix ctm = renderInfo.getImageCTM();
        if (ctm == null) {
            return null;
        }
        AffineTransform t = new AffineTransform(ctm.get(0), ctm.get(1), ctm.get(3), ctm.get(4), ctm.get(6), ctm.get(7));
        Point2D p1 = t.transform(new Point(0, 0), null);
        Point2D p2 = t.transform(new Point(0, 1), null);
        Point2D p3 = t.transform(new Point(1, 0), null);
        Point2D p4 = t.transform(new Point(1, 1), null);
        List<Double> xs = Arrays.asList(p1.getX(), p2.getX(), p3.getX(), p4.getX());
        List<Double> ys = Arrays.asList(p1.getY(), p2.getY(), p3.getY(), p4.getY());
        double left = Collections.min(xs);
        double bottom = Collections.min(ys);
        double right = Collections.max(xs);
        double top = Collections.max(ys);
        return new Rectangle((float)left, (float)bottom, (float)right, (float)top);
    }

    private Rectangle intersection(Rectangle rect1, Rectangle rect2) {
        com.itextpdf.awt.geom.Rectangle awtRect1 = new com.itextpdf.awt.geom.Rectangle(rect1);
        com.itextpdf.awt.geom.Rectangle awtRect2 = new com.itextpdf.awt.geom.Rectangle(rect2);
        com.itextpdf.awt.geom.Rectangle awtIntersection = awtRect1.intersection(awtRect2);
        return awtIntersection.isEmpty() ? null : new Rectangle(awtIntersection);
    }

    private Rectangle shearCoordinatesAndInverseY(float dx, float dy, Rectangle rect) {
        AffineTransform affineTransform = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, -dx, dy);
        Point2D leftBottom = affineTransform.transform(new Point(rect.getLeft(), rect.getBottom()), null);
        Point2D rightTop = affineTransform.transform(new Point(rect.getRight(), rect.getTop()), null);
        return new Rectangle((float)leftBottom.getX(), (float)leftBottom.getY(), (float)rightTop.getX(), (float)rightTop.getY());
    }
}

