/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.pdfcleanup;

import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfBoolean;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.parser.ImageRenderInfo;
import com.itextpdf.text.pdf.parser.LineSegment;
import com.itextpdf.text.pdf.parser.PdfImageObject;
import com.itextpdf.text.pdf.parser.RenderListener;
import com.itextpdf.text.pdf.parser.TextRenderInfo;
import com.itextpdf.text.pdf.pdfcleanup.PdfCleanUpContentChunk;
import com.itextpdf.text.pdf.pdfcleanup.PdfCleanUpContext;
import com.itextpdf.text.pdf.pdfcleanup.PdfCleanUpCoveredArea;
import com.itextpdf.text.pdf.pdfcleanup.PdfCleanUpRegionFilter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.Imaging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PdfCleanUpRenderListener
implements RenderListener {
    private static final Color CLEANED_AREA_FILL_COLOR = Color.WHITE;
    private PdfStamper pdfStamper;
    private List<PdfCleanUpRegionFilter> filters;
    private List<PdfCleanUpContentChunk> chunks = new ArrayList<PdfCleanUpContentChunk>();
    private Stack<PdfCleanUpContext> contextStack = new Stack();
    private int strNumber = 1;

    public PdfCleanUpRenderListener(PdfStamper pdfStamper, List<PdfCleanUpRegionFilter> filters) {
        this.pdfStamper = pdfStamper;
        this.filters = filters;
    }

    @Override
    public void renderText(TextRenderInfo renderInfo) {
        if (renderInfo.getPdfString().toUnicodeString().length() == 0) {
            return;
        }
        for (TextRenderInfo ri : renderInfo.getCharacterRenderInfos()) {
            boolean textIsInsideRegion = this.textIsInsideRegion(ri);
            LineSegment baseline = ri.getUnscaledBaseline();
            this.chunks.add(new PdfCleanUpContentChunk(ri.getPdfString(), baseline.getStartPoint(), baseline.getEndPoint(), !textIsInsideRegion, this.strNumber));
        }
        ++this.strNumber;
    }

    @Override
    public void renderImage(ImageRenderInfo renderInfo) {
        List<Rectangle> areasToBeCleaned = this.getImageAreasToBeCleaned(renderInfo);
        if (areasToBeCleaned == null) {
            this.chunks.add(new PdfCleanUpContentChunk(false, null));
        } else {
            try {
                PdfImageObject pdfImage = renderInfo.getImage();
                byte[] imageBytes = this.processImage(pdfImage.getImageAsBytes(), areasToBeCleaned);
                if (renderInfo.getRef() == null && pdfImage != null) {
                    PdfDictionary dict = pdfImage.getDictionary();
                    PdfObject imageMask = dict.get(PdfName.IMAGEMASK);
                    Image image = Image.getInstance(imageBytes);
                    if (imageMask == null) {
                        imageMask = dict.get(PdfName.IM);
                    }
                    if (imageMask != null && imageMask.equals(PdfBoolean.PDFTRUE)) {
                        image.makeMask();
                    }
                    PdfContentByte canvas = this.getContext().getCanvas();
                    canvas.addImage(image, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, true);
                } else if (pdfImage != null && imageBytes != pdfImage.getImageAsBytes()) {
                    this.chunks.add(new PdfCleanUpContentChunk(true, imageBytes));
                }
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    @Override
    public void beginTextBlock() {
    }

    @Override
    public void endTextBlock() {
    }

    public List<PdfCleanUpContentChunk> getChunks() {
        return this.chunks;
    }

    public PdfCleanUpContext getContext() {
        return this.contextStack.peek();
    }

    public void registerNewContext(PdfDictionary resources, PdfContentByte canvas) {
        canvas = canvas == null ? new PdfContentByte(this.pdfStamper.getWriter()) : canvas;
        this.contextStack.push(new PdfCleanUpContext(resources, canvas));
    }

    public void popContext() {
        this.contextStack.pop();
    }

    public void clearChunks() {
        this.chunks.clear();
        this.strNumber = 1;
    }

    private boolean textIsInsideRegion(TextRenderInfo renderInfo) {
        for (PdfCleanUpRegionFilter filter : this.filters) {
            if (!filter.allowText(renderInfo)) continue;
            return true;
        }
        return false;
    }

    private List<Rectangle> getImageAreasToBeCleaned(ImageRenderInfo renderInfo) {
        ArrayList<Rectangle> areasToBeCleaned = new ArrayList<Rectangle>();
        for (PdfCleanUpRegionFilter filter : this.filters) {
            PdfCleanUpCoveredArea coveredArea = filter.intersection(renderInfo);
            if (coveredArea == null || coveredArea.matchesObjRect()) {
                return null;
            }
            if (coveredArea.getRect() == null) continue;
            areasToBeCleaned.add(coveredArea.getRect());
        }
        return areasToBeCleaned;
    }

    private byte[] processImage(byte[] imageBytes, List<Rectangle> areasToBeCleaned) {
        if (areasToBeCleaned.isEmpty()) {
            return imageBytes;
        }
        try {
            BufferedImage image = Imaging.getBufferedImage((byte[])imageBytes);
            ImageInfo imageInfo = Imaging.getImageInfo((byte[])imageBytes);
            this.cleanImage(image, areasToBeCleaned);
            if (imageInfo.getFormat() == ImageFormats.JPEG) {
                return this.getJPGBytes(image);
            }
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            if (imageInfo.getFormat() == ImageFormats.TIFF) {
                params.put("COMPRESSION", 5);
            }
            return Imaging.writeImageToBytes((BufferedImage)image, (ImageFormat)imageInfo.getFormat(), params);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    private void cleanImage(BufferedImage image, List<Rectangle> areasToBeCleaned) {
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(CLEANED_AREA_FILL_COLOR);
        for (Rectangle rect : areasToBeCleaned) {
            int x = (int)Math.ceil(rect.getLeft());
            int y = (int)Math.ceil(rect.getTop());
            int width = (int)Math.floor(rect.getRight()) - x;
            int height = (int)Math.floor(rect.getBottom()) - y;
            graphics.fillRect(x, y, width, height);
        }
        graphics.dispose();
    }

    private byte[] getJPGBytes(BufferedImage image) {
        ByteArrayOutputStream outputStream = null;
        try {
            ImageWriter jpgWriter = ImageIO.getImageWritersByFormatName("jpg").next();
            ImageWriteParam jpgWriteParam = jpgWriter.getDefaultWriteParam();
            jpgWriteParam.setCompressionMode(2);
            jpgWriteParam.setCompressionQuality(1.0f);
            outputStream = new ByteArrayOutputStream();
            jpgWriter.setOutput(new MemoryCacheImageOutputStream(outputStream));
            IIOImage outputImage = new IIOImage(image, null, null);
            jpgWriter.write(null, outputImage, jpgWriteParam);
            jpgWriter.dispose();
            outputStream.flush();
            byte[] byArray = outputStream.toByteArray();
            this.closeOutputStream(outputStream);
            return byArray;
        }
        catch (Exception e2) {
            try {
                throw new RuntimeException(e2);
            }
            catch (Throwable throwable) {
                this.closeOutputStream(outputStream);
                throw throwable;
            }
        }
    }

    private void closeOutputStream(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
    }
}

