/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css;

import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CssFile;
import com.itextpdf.tool.xml.css.CssFiles;
import com.itextpdf.tool.xml.css.CssRule;
import com.itextpdf.tool.xml.css.CssUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssFilesImpl
implements CssFiles {
    private final List<CssFile> files = new ArrayList<CssFile>();
    private final CssUtils utils = CssUtils.getInstance();

    public CssFilesImpl() {
    }

    public CssFilesImpl(CssFile css) {
        this();
        this.add(css);
    }

    @Override
    public boolean hasFiles() {
        return !this.files.isEmpty();
    }

    @Override
    public Map<String, String> getCSS(Tag t) {
        HashMap<String, String> aggregatedProps = new HashMap<String, String>();
        this.populateCss(t, aggregatedProps);
        return aggregatedProps;
    }

    public void populateCss(Tag t, Map<String, String> aggregatedProps) {
        ArrayList<CssRule> rules = new ArrayList<CssRule>();
        for (CssFile cssFile : this.files) {
            rules.addAll(cssFile.get(t));
        }
        Collections.sort(rules);
        for (CssRule rule : rules) {
            this.populateOneCss(aggregatedProps, rule.getNormalDeclarations());
        }
        for (CssRule rule : rules) {
            this.populateOneCss(aggregatedProps, rule.getImportantDeclarations());
        }
    }

    public void populateOneCss(Map<String, String> aggregatedProps, Map<String, String> cssDeclaration) {
        HashMap<String, String> css = new HashMap<String, String>();
        for (Map.Entry<String, String> e2 : cssDeclaration.entrySet()) {
            String key = this.utils.stripDoubleSpacesTrimAndToLowerCase(e2.getKey());
            String value = this.utils.stripDoubleSpacesAndTrim(e2.getValue());
            if ("border".equalsIgnoreCase(key)) {
                css.putAll(this.utils.parseBorder(value));
                continue;
            }
            if ("border-top".equalsIgnoreCase(key)) {
                css.putAll(this.utils.parseBorder(value, "border-top"));
                continue;
            }
            if ("border-bottom".equalsIgnoreCase(key)) {
                css.putAll(this.utils.parseBorder(value, "border-bottom"));
                continue;
            }
            if ("border-left".equalsIgnoreCase(key)) {
                css.putAll(this.utils.parseBorder(value, "border-left"));
                continue;
            }
            if ("border-right".equalsIgnoreCase(key)) {
                css.putAll(this.utils.parseBorder(value, "border-right"));
                continue;
            }
            if ("margin".equalsIgnoreCase(key)) {
                Map<String, String> margins = this.utils.parseBoxValues(value, "margin-", "");
                for (String marginKey : margins.keySet()) {
                    if (css.containsKey(marginKey)) continue;
                    css.put(marginKey, margins.get(marginKey));
                }
                continue;
            }
            if ("border-width".equalsIgnoreCase(key)) {
                css.putAll(this.utils.parseBoxValues(value, "border-", "-width"));
                continue;
            }
            if ("border-style".equalsIgnoreCase(key)) {
                css.putAll(this.utils.parseBoxValues(value, "border-", "-style"));
                continue;
            }
            if ("border-color".equalsIgnoreCase(key)) {
                css.putAll(this.utils.parseBoxValues(value, "border-", "-color"));
                continue;
            }
            if ("padding".equalsIgnoreCase(key)) {
                Map<String, String> paddings = this.utils.parseBoxValues(value, "padding-", "");
                for (String paddingKey : paddings.keySet()) {
                    if (css.containsKey(paddingKey)) continue;
                    css.put(paddingKey, paddings.get(paddingKey));
                }
                continue;
            }
            if ("font".equalsIgnoreCase(key)) {
                css.putAll(this.utils.processFont(value));
                continue;
            }
            if ("list-style".equalsIgnoreCase(key)) {
                css.putAll(this.utils.processListStyle(value));
                continue;
            }
            if ("background".equalsIgnoreCase(key)) {
                Map<String, String> backgroundStyles = this.utils.processBackground(value);
                for (String backgroundKey : backgroundStyles.keySet()) {
                    if (css.containsKey(backgroundKey)) continue;
                    css.put(backgroundKey, backgroundStyles.get(backgroundKey));
                }
                continue;
            }
            css.put(key, value);
        }
        aggregatedProps.putAll(css);
    }

    @Override
    public void add(CssFile css) {
        if (css != null) {
            this.files.add(css);
        }
    }

    @Override
    public void clear() {
        Iterator<CssFile> iterator = this.files.iterator();
        while (iterator.hasNext()) {
            CssFile next = iterator.next();
            if (next.isPersistent()) continue;
            iterator.remove();
        }
    }
}

