/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css;

import com.itextpdf.tool.xml.css.CssSelector;
import com.itextpdf.tool.xml.css.CssSelectorItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssRule
implements Comparable<CssRule> {
    private CssSelector selector;
    private Map<String, String> normalDeclarations;
    private Map<String, String> importantDeclarations;
    private static final Pattern importantMatcher = Pattern.compile(".*!\\s*important$");

    public CssRule(List<CssSelectorItem> selector, Map<String, String> declarations) {
        this.selector = new CssSelector(selector);
        this.normalDeclarations = declarations;
        this.importantDeclarations = new HashMap<String, String>();
        for (Map.Entry<String, String> declaration : this.normalDeclarations.entrySet()) {
            int exclIndex = declaration.getValue().indexOf(33);
            if (exclIndex <= 0 || !importantMatcher.matcher(declaration.getValue()).matches()) continue;
            this.importantDeclarations.put(declaration.getKey(), declaration.getValue().substring(0, exclIndex).trim());
        }
        for (String key : this.importantDeclarations.keySet()) {
            this.normalDeclarations.remove(key);
        }
    }

    public CssSelector getSelector() {
        return this.selector;
    }

    public Map<String, String> getNormalDeclarations() {
        return this.normalDeclarations;
    }

    public Map<String, String> getImportantDeclarations() {
        return this.importantDeclarations;
    }

    public String toString() {
        return String.format("%s { count: %d } #spec:%d", this.selector.toString(), this.normalDeclarations.size() + this.importantDeclarations.size(), this.selector.calculateSpecifity());
    }

    @Override
    public int compareTo(CssRule o2) {
        return this.selector.calculateSpecifity() - o2.selector.calculateSpecifity();
    }
}

