/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css.apply;

import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.css.FontSizeTranslator;
import com.itextpdf.tool.xml.css.apply.MarginMemory;
import com.itextpdf.tool.xml.html.pdfelement.NoNewLineParagraph;
import java.util.Map;

public class NoNewLineParagraphCssApplier {
    private final CssUtils utils = CssUtils.getInstance();

    public NoNewLineParagraph apply(NoNewLineParagraph p2, Tag t, MarginMemory configuration) {
        float fontSize = FontSizeTranslator.getInstance().getFontSize(t);
        float lmb = 0.0f;
        boolean hasLMB = false;
        Map<String, String> css = t.getCSS();
        for (Map.Entry<String, String> entry : css.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if ("margin-top".equalsIgnoreCase(key)) {
                p2.setSpacingBefore(p2.getSpacingBefore() + this.utils.calculateMarginTop(value, fontSize, configuration));
                continue;
            }
            if ("padding-top".equalsIgnoreCase(key)) {
                p2.setSpacingBefore(p2.getSpacingBefore() + this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("margin-bottom".equalsIgnoreCase(key)) {
                float after = this.utils.parseValueToPt(value, fontSize);
                p2.setSpacingAfter(p2.getSpacingAfter() + after);
                lmb = after;
                hasLMB = true;
                continue;
            }
            if ("padding-bottom".equalsIgnoreCase(key)) {
                p2.setSpacingAfter(p2.getSpacingAfter() + this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("margin-left".equalsIgnoreCase(key)) {
                p2.setIndentationLeft(p2.getIndentationLeft() + this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("margin-right".equalsIgnoreCase(key)) {
                p2.setIndentationRight(p2.getIndentationRight() + this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("padding-left".equalsIgnoreCase(key)) {
                p2.setIndentationLeft(p2.getIndentationLeft() + this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("padding-right".equalsIgnoreCase(key)) {
                p2.setIndentationRight(p2.getIndentationRight() + this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("text-align".equalsIgnoreCase(key)) {
                if ("right".equalsIgnoreCase(value)) {
                    p2.setAlignment(2);
                    continue;
                }
                if ("center".equalsIgnoreCase(value)) {
                    p2.setAlignment(1);
                    continue;
                }
                if ("left".equalsIgnoreCase(value)) {
                    p2.setAlignment(0);
                    continue;
                }
                if (!"justify".equalsIgnoreCase(value)) continue;
                p2.setAlignment(3);
                continue;
            }
            if (!"text-indent".equalsIgnoreCase(key)) continue;
            p2.setFirstLineIndent(this.utils.parseValueToPt(value, fontSize));
        }
        if (null != t.getParent()) {
            String parent = t.getParent().getName();
            if (css.get("margin-top") == null && configuration.getRootTags().contains(parent)) {
                p2.setSpacingBefore(p2.getSpacingBefore() + this.utils.calculateMarginTop(fontSize + "pt", 0.0f, configuration));
            }
            if (css.get("margin-bottom") == null && configuration.getRootTags().contains(parent)) {
                p2.setSpacingAfter(p2.getSpacingAfter() + fontSize);
                css.put("margin-bottom", fontSize + "pt");
                lmb = fontSize;
                hasLMB = true;
            }
            if (p2.getAlignment() == -1) {
                p2.setAlignment(0);
            }
        }
        if (hasLMB) {
            configuration.setLastMarginBottom(Float.valueOf(lmb));
        }
        return p2;
    }
}

