/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.html;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.draw.LineSeparator;
import com.itextpdf.tool.xml.NoCustomContextException;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.css.FontSizeTranslator;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.html.CssAppliers;
import com.itextpdf.tool.xml.html.CssAppliersAware;
import com.itextpdf.tool.xml.html.HTMLUtils;
import com.itextpdf.tool.xml.html.TagProcessor;
import com.itextpdf.tool.xml.html.pdfelement.NoNewLineParagraph;
import com.itextpdf.tool.xml.pipeline.css.CSSResolver;
import com.itextpdf.tool.xml.pipeline.css.CssResolverPipeline;
import com.itextpdf.tool.xml.pipeline.ctx.ObjectContext;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipeline;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import com.itextpdf.tool.xml.util.ParentTreeUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTagProcessor
implements TagProcessor,
CssAppliersAware {
    private final FontSizeTranslator fontsizeTrans = FontSizeTranslator.getInstance();
    private CssAppliers cssAppliers;
    private List<Tag> tree;

    public CSSResolver getCSSResolver(WorkerContext context) throws NoCustomContextException {
        return (CSSResolver)((ObjectContext)context.get(CssResolverPipeline.class.getName())).get();
    }

    public HtmlPipelineContext getHtmlPipelineContext(WorkerContext context) throws NoCustomContextException {
        return (HtmlPipelineContext)context.get(HtmlPipeline.class.getName());
    }

    @Override
    public final List<Element> startElement(WorkerContext ctx, Tag tag) {
        String pagebreak;
        float fontSize = this.fontsizeTrans.translateFontSize(tag);
        if (fontSize != -1.0f) {
            tag.getCSS().put("font-size", fontSize + "pt");
        }
        if (null != (pagebreak = tag.getCSS().get("page-break-before")) && "always".equalsIgnoreCase(pagebreak)) {
            ArrayList<Element> list = new ArrayList<Element>(2);
            list.add(Chunk.NEXTPAGE);
            list.addAll(this.start(ctx, tag));
            return list;
        }
        return this.start(ctx, tag);
    }

    public List<Element> start(WorkerContext ctx, Tag tag) {
        return new ArrayList<Element>(0);
    }

    @Override
    public List<Element> content(WorkerContext ctx, Tag tag, String content) {
        return new ArrayList<Element>(0);
    }

    private String getParentDirection() {
        Tag tag;
        String result = null;
        Iterator<Tag> i$ = this.tree.iterator();
        while (i$.hasNext() && (result = (tag = i$.next()).getAttributes().get("dir")) == null && (result = tag.getCSS().get("direction")) == null) {
        }
        return result;
    }

    protected int getRunDirection(Tag tag) {
        String dirValue = tag.getAttributes().get("dir");
        if (dirValue == null && (dirValue = tag.getCSS().get("direction")) == null) {
            this.tree = new ParentTreeUtil().getParentTagTree(tag, this.tree);
            dirValue = this.getParentDirection();
        }
        if ("rtl".equalsIgnoreCase(dirValue)) {
            return 3;
        }
        if ("ltr".equalsIgnoreCase(dirValue)) {
            return 2;
        }
        return 0;
    }

    protected List<Element> textContent(WorkerContext ctx, Tag tag, String content) {
        List<Chunk> sanitizedChunks = HTMLUtils.sanitize(content, false);
        ArrayList<Element> l2 = new ArrayList<Element>(1);
        for (Chunk sanitized : sanitizedChunks) {
            try {
                l2.add(this.getCssAppliers().apply(sanitized, tag, this.getHtmlPipelineContext(ctx)));
            }
            catch (NoCustomContextException e2) {
                throw new RuntimeWorkerException(e2);
            }
        }
        return l2;
    }

    @Override
    public final List<Element> endElement(WorkerContext ctx, Tag tag, List<Element> currentContent) {
        ArrayList<Element> list = new ArrayList();
        if (currentContent.isEmpty()) {
            list = this.end(ctx, tag, currentContent);
        } else {
            ArrayList<Element> elements = new ArrayList<Element>();
            for (Element el : currentContent) {
                if (el instanceof Chunk && ((Chunk)el).hasAttributes() && ((Chunk)el).getAttributes().containsKey("NEWPAGE")) {
                    if (elements.size() > 0) {
                        list.addAll(this.end(ctx, tag, elements));
                        elements.clear();
                    }
                    list.add(el);
                    continue;
                }
                elements.add(el);
            }
            if (elements.size() > 0) {
                list.addAll(this.end(ctx, tag, elements));
                elements.clear();
            }
        }
        String pagebreak = tag.getCSS().get("page-break-after");
        if (null != pagebreak && "always".equalsIgnoreCase(pagebreak)) {
            list.add(Chunk.NEXTPAGE);
        }
        return list;
    }

    public List<Element> end(WorkerContext ctx, Tag tag, List<Element> currentContent) {
        return new ArrayList<Element>(currentContent);
    }

    @Override
    public boolean isStackOwner() {
        return false;
    }

    public List<Element> currentContentToParagraph(List<Element> currentContent, boolean addNewLines, boolean applyCSS, Tag tag, WorkerContext ctx) {
        try {
            ArrayList<Element> list = new ArrayList<Element>();
            if (currentContent.size() > 0) {
                if (addNewLines) {
                    Paragraph p2 = this.createParagraph();
                    p2.setMultipliedLeading(1.2f);
                    for (Element e2 : currentContent) {
                        if (e2 instanceof LineSeparator) {
                            try {
                                HtmlPipelineContext htmlPipelineContext = this.getHtmlPipelineContext(ctx);
                                Chunk newLine = (Chunk)this.getCssAppliers().apply(new Chunk(Chunk.NEWLINE), tag, htmlPipelineContext);
                                p2.add(newLine);
                            }
                            catch (NoCustomContextException e1) {
                                throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e1);
                            }
                        }
                        p2.add(e2);
                    }
                    if (p2.trim()) {
                        if (applyCSS) {
                            p2 = (Paragraph)this.getCssAppliers().apply(p2, tag, this.getHtmlPipelineContext(ctx));
                        }
                        list.add(p2);
                    }
                } else {
                    NoNewLineParagraph p3 = new NoNewLineParagraph(Float.NaN);
                    p3.setMultipliedLeading(1.2f);
                    for (Element e3 : currentContent) {
                        p3.add(e3);
                    }
                    p3 = (NoNewLineParagraph)this.getCssAppliers().apply(p3, tag, this.getHtmlPipelineContext(ctx));
                    list.add(p3);
                }
            }
            return list;
        }
        catch (NoCustomContextException e4) {
            throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e4);
        }
    }

    public final List<Element> currentContentToParagraph(List<Element> currentContent, boolean addNewLines) {
        return this.currentContentToParagraph(currentContent, addNewLines, false, null, null);
    }

    @Override
    public void setCssAppliers(CssAppliers cssAppliers) {
        this.cssAppliers = cssAppliers;
    }

    @Override
    public CssAppliers getCssAppliers() {
        return this.cssAppliers;
    }

    protected Paragraph createParagraph() {
        return new Paragraph(Float.NaN);
    }
}

