/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.html;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.WritableDirectElement;
import com.itextpdf.text.log.Level;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.pdf.PdfDestination;
import com.itextpdf.text.pdf.PdfOutline;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.tool.xml.NoCustomContextException;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.html.AbstractTagProcessor;
import com.itextpdf.tool.xml.html.HeaderNode;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import com.itextpdf.tool.xml.util.ParentTreeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Header
extends AbstractTagProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Header.class);

    @Override
    public List<Element> content(WorkerContext ctx, Tag tag, String content) {
        return this.textContent(ctx, tag, content);
    }

    @Override
    public List<Element> end(WorkerContext ctx, final Tag tag, List<Element> currentContent) {
        ArrayList<Element> l2 = new ArrayList<Element>(1);
        ParentTreeUtil pt = new ParentTreeUtil();
        if (currentContent.size() > 0) {
            List<Element> currentContentToParagraph;
            block6: {
                currentContentToParagraph = this.currentContentToParagraph(currentContent, true, true, tag, ctx);
                try {
                    final HtmlPipelineContext context = this.getHtmlPipelineContext(ctx);
                    boolean oldBookmark = context.autoBookmark();
                    if (!pt.getParentTree(tag).isEmpty() && pt.getParentTree(tag).contains("td")) {
                        context.autoBookmark(false);
                    }
                    if (context.autoBookmark()) {
                        final Paragraph title = new Paragraph();
                        for (Element w : currentContentToParagraph) {
                            title.add(w);
                        }
                        l2.add(new WritableDirectElement(){

                            public void write(PdfWriter writer, Document doc) throws DocumentException {
                                PdfDestination destination = new PdfDestination(0, 20.0f, writer.getVerticalPosition(false), 0.0f);
                                Map<String, Object> memory = context.getMemory();
                                HeaderNode tree = (HeaderNode)memory.get("header.autobookmark.RootNode");
                                int level = Header.this.getLevel(tag);
                                if (null == tree) {
                                    tree = new HeaderNode(0, writer.getRootOutline(), null);
                                } else {
                                    int lastLevel = tree.level();
                                    if (lastLevel == level) {
                                        tree = tree.parent();
                                    } else if (lastLevel > level) {
                                        while (lastLevel >= level) {
                                            lastLevel = tree.parent().level();
                                            tree = tree.parent();
                                        }
                                    }
                                }
                                if (LOGGER.isLogging(Level.TRACE)) {
                                    LOGGER.trace(String.format(LocaleMessages.getInstance().getMessage("html.tag.h.create"), title.toString()));
                                }
                                HeaderNode node = new HeaderNode(level, new PdfOutline(tree.outline(), destination, title), tree);
                                memory.put("header.autobookmark.RootNode", node);
                            }
                        });
                    }
                    context.autoBookmark(oldBookmark);
                }
                catch (NoCustomContextException e2) {
                    if (!LOGGER.isLogging(Level.ERROR)) break block6;
                    LOGGER.error(LocaleMessages.getInstance().getMessage("html.tag.h.disabled"), e2);
                }
            }
            l2.addAll(currentContentToParagraph);
        }
        return l2;
    }

    private int getLevel(Tag tag) {
        return Integer.parseInt(Character.toString(tag.getName().charAt(1)));
    }

    @Override
    public boolean isStackOwner() {
        return true;
    }
}

