/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.html;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.ListItem;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.draw.LineSeparator;
import com.itextpdf.text.pdf.draw.VerticalPositionMark;
import com.itextpdf.tool.xml.NoCustomContextException;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.html.AbstractTagProcessor;
import com.itextpdf.tool.xml.html.HTMLUtils;
import com.itextpdf.tool.xml.html.pdfelement.TabbedChunk;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParaGraph
extends AbstractTagProcessor {
    @Override
    public List<Element> content(WorkerContext ctx, Tag tag, String content) {
        List<Chunk> sanitizedChunks = HTMLUtils.sanitize(content, false);
        ArrayList<Element> l2 = new ArrayList<Element>(1);
        for (Chunk sanitized : sanitizedChunks) {
            TabbedChunk tabbedChunk;
            HtmlPipelineContext myctx;
            try {
                myctx = this.getHtmlPipelineContext(ctx);
            }
            catch (NoCustomContextException e2) {
                throw new RuntimeWorkerException(e2);
            }
            if (null != tag.getCSS().get("tab-interval")) {
                tabbedChunk = new TabbedChunk(sanitized.getContent());
                if (null != this.getLastChild(tag) && null != this.getLastChild(tag).getCSS().get("xfa-tab-count")) {
                    tabbedChunk.setTabCount(Integer.parseInt(this.getLastChild(tag).getCSS().get("xfa-tab-count")));
                }
                l2.add(this.getCssAppliers().apply(tabbedChunk, tag, myctx));
                continue;
            }
            if (null != this.getLastChild(tag) && null != this.getLastChild(tag).getCSS().get("xfa-tab-count")) {
                tabbedChunk = new TabbedChunk(sanitized.getContent());
                tabbedChunk.setTabCount(Integer.parseInt(this.getLastChild(tag).getCSS().get("xfa-tab-count")));
                l2.add(this.getCssAppliers().apply(tabbedChunk, tag, myctx));
                continue;
            }
            l2.add(this.getCssAppliers().apply(sanitized, tag, myctx));
        }
        return l2;
    }

    private Tag getLastChild(Tag tag) {
        if (0 != tag.getChildren().size()) {
            return tag.getChildren().get(tag.getChildren().size() - 1);
        }
        return null;
    }

    @Override
    public List<Element> end(WorkerContext ctx, Tag tag, List<Element> currentContent) {
        ArrayList<Element> l2 = new ArrayList<Element>(1);
        if (currentContent.size() > 0) {
            ArrayList<Element> elements = new ArrayList<Element>();
            ArrayList<ListItem> listItems = new ArrayList<ListItem>();
            for (Element el : currentContent) {
                if (el instanceof ListItem) {
                    if (!elements.isEmpty()) {
                        this.processParagraphItems(ctx, tag, elements, l2);
                        elements.clear();
                    }
                    listItems.add((ListItem)el);
                    continue;
                }
                if (!listItems.isEmpty()) {
                    this.processListItems(ctx, tag, listItems, l2);
                    listItems.clear();
                }
                elements.add(el);
            }
            if (!elements.isEmpty()) {
                this.processParagraphItems(ctx, tag, elements, l2);
                elements.clear();
            } else if (!listItems.isEmpty()) {
                this.processListItems(ctx, tag, listItems, l2);
                listItems.clear();
            }
        }
        return l2;
    }

    protected void processParagraphItems(WorkerContext ctx, Tag tag, List<Element> paragraphItems, List<Element> l2) {
        Map<String, String> css;
        Paragraph p2 = new Paragraph();
        p2.setMultipliedLeading(1.2f);
        Element lastElement = paragraphItems.get(paragraphItems.size() - 1);
        if (lastElement instanceof Chunk && Chunk.NEWLINE.getContent().equals(((Chunk)lastElement).getContent())) {
            paragraphItems.remove(paragraphItems.size() - 1);
        }
        if (null != (css = tag.getCSS()).get("tab-interval")) {
            this.addTabIntervalContent(ctx, tag, paragraphItems, p2, css.get("tab-interval"));
            l2.add(p2);
        } else if (null != css.get("tab-stops")) {
            this.addTabStopsContent(paragraphItems, p2, css.get("tab-stops"));
            l2.add(p2);
        } else if (null != css.get("xfa-tab-stops")) {
            this.addTabStopsContent(paragraphItems, p2, css.get("xfa-tab-stops"));
            l2.add(p2);
        } else {
            Element firstElement;
            List<Element> paraList = this.currentContentToParagraph(paragraphItems, true, true, tag, ctx);
            if (!l2.isEmpty() && !paraList.isEmpty() && (firstElement = paraList.get(0)) instanceof Paragraph) {
                ((Paragraph)firstElement).setSpacingBefore(0.0f);
            }
            for (Element e2 : paraList) {
                l2.add(e2);
            }
        }
    }

    protected void processListItems(WorkerContext ctx, Tag tag, List<ListItem> listItems, List<Element> l2) {
        try {
            Element latestElement;
            com.itextpdf.text.List list = new com.itextpdf.text.List();
            list.setAlignindent(false);
            list = (com.itextpdf.text.List)this.getCssAppliers().apply(list, tag, this.getHtmlPipelineContext(ctx));
            list.setIndentationLeft(0.0f);
            int i2 = 0;
            for (ListItem li : listItems) {
                li = (ListItem)this.getCssAppliers().apply(li, tag, this.getHtmlPipelineContext(ctx));
                if (i2 != listItems.size() - 1) {
                    li.setSpacingAfter(0.0f);
                }
                if (i2 != 0) {
                    li.setSpacingBefore(0.0f);
                }
                ++i2;
                li.setMultipliedLeading(1.2f);
                list.add(li);
            }
            if (!l2.isEmpty() && (latestElement = l2.get(l2.size() - 1)) instanceof Paragraph) {
                ((Paragraph)latestElement).setSpacingAfter(0.0f);
            }
            l2.add(list);
        }
        catch (NoCustomContextException e2) {
            throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e2);
        }
    }

    private void addTabIntervalContent(WorkerContext ctx, Tag tag, List<Element> currentContent, Paragraph p2, String value) {
        float width = 0.0f;
        for (Element e2 : currentContent) {
            if (e2 instanceof TabbedChunk) {
                TabbedChunk tab = new TabbedChunk(new VerticalPositionMark(), width += (float)((TabbedChunk)e2).getTabCount() * CssUtils.getInstance().parsePxInCmMmPcToPt(value), false);
                p2.add(new Chunk(tab));
                p2.add(new Chunk((TabbedChunk)e2));
                continue;
            }
            if (e2 instanceof LineSeparator) {
                try {
                    HtmlPipelineContext htmlPipelineContext = this.getHtmlPipelineContext(ctx);
                    Chunk newLine = (Chunk)this.getCssAppliers().apply(new Chunk(Chunk.NEWLINE), tag, htmlPipelineContext);
                    p2.add(newLine);
                }
                catch (NoCustomContextException e1) {
                    throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e1);
                }
            }
            p2.add(e2);
        }
    }

    private void addTabStopsContent(List<Element> currentContent, Paragraph p2, String value) {
        ArrayList<TabbedChunk> tabs = new ArrayList<TabbedChunk>();
        String[] alignAndWidth = value.split(" ");
        float tabWidth = 0.0f;
        int i2 = 0;
        for (int j2 = 1; j2 < alignAndWidth.length; j2 += 2) {
            TabbedChunk tab = new TabbedChunk(new VerticalPositionMark(), tabWidth += CssUtils.getInstance().parsePxInCmMmPcToPt(alignAndWidth[j2]), true, alignAndWidth[i2]);
            tabs.add(tab);
            i2 += 2;
        }
        int tabsPerRow = tabs.size();
        int currentTab = 0;
        for (Element e2 : currentContent) {
            if (!(e2 instanceof TabbedChunk)) continue;
            if (currentTab == tabsPerRow) {
                currentTab = 0;
            }
            if (((TabbedChunk)e2).getTabCount() == 0) continue;
            p2.add(new Chunk((Chunk)tabs.get(currentTab)));
            p2.add(new Chunk((TabbedChunk)e2));
            ++currentTab;
        }
    }

    @Override
    public boolean isStackOwner() {
        return true;
    }
}

