/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.net;

import com.itextpdf.text.log.Level;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.net.FileRetrieve;
import com.itextpdf.tool.xml.net.ReadingProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class FileRetrieveImpl
implements FileRetrieve {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileRetrieveImpl.class);
    private final List<File> rootdirs = new CopyOnWriteArrayList<File>();
    private final List<String> urls = new CopyOnWriteArrayList<String>();

    public FileRetrieveImpl() {
    }

    public FileRetrieveImpl(String ... strings) {
        this();
        for (String s2 : strings) {
            if (s2.startsWith("http") || s2.startsWith("https")) {
                this.urls.add(s2);
                continue;
            }
            File f2 = new File(s2);
            if (!f2.isDirectory()) continue;
            this.rootdirs.add(f2);
        }
    }

    public FileRetrieveImpl(File rootdir) {
        this();
        if (rootdir.isDirectory()) {
            this.rootdirs.add(rootdir);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processFromHref(String href, ReadingProcessor processor) throws IOException {
        boolean isfile;
        File f2;
        URL url;
        block9: {
            if (LOGGER.isLogging(Level.DEBUG)) {
                LOGGER.debug(String.format(LocaleMessages.getInstance().getMessage("retrieve.file.from"), href));
            }
            url = null;
            f2 = null;
            isfile = false;
            try {
                url = new URL(href);
            }
            catch (MalformedURLException e2) {
                try {
                    url = this.detectWithRootUrls(href);
                }
                catch (MalformedURLException e1) {
                    f2 = new File(href);
                    isfile = true;
                    if (f2.isFile() && f2.canRead()) break block9;
                    isfile = false;
                    for (File root : this.rootdirs) {
                        f2 = new File(root, href);
                        if (!f2.isFile() || !f2.canRead()) continue;
                        isfile = true;
                        break;
                    }
                }
            }
        }
        InputStream in = null;
        if (null != url) {
            in = url.openStream();
        } else {
            if (!isfile) {
                throw new IOException(LocaleMessages.getInstance().getMessage("retrieve.file.from.nothing"));
            }
            in = new FileInputStream(f2);
        }
        this.read(processor, in);
    }

    private URL detectWithRootUrls(String href) throws MalformedURLException {
        for (String root : this.urls) {
            try {
                return new URL(root + href);
            }
            catch (MalformedURLException e2) {
            }
        }
        throw new MalformedURLException();
    }

    public void processFromStream(InputStream in, ReadingProcessor processor) throws IOException {
        this.read(processor, in);
    }

    private void read(ReadingProcessor processor, InputStream in) throws IOException {
        try {
            int inbit = -1;
            while ((inbit = in.read()) != -1) {
                processor.process(inbit);
            }
        }
        catch (IOException e2) {
            throw e2;
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
            }
            catch (IOException e3) {
                throw new RuntimeWorkerException(e3);
            }
        }
    }

    public void addRootDir(File dir) {
        this.rootdirs.add(dir);
    }

    public void addURL(String url) {
        this.urls.add(url);
    }
}

