/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.crypto.AESCipher;
import com.lowagie.text.pdf.crypto.ARCFOUREncryption;
import com.lowagie.text.pdf.crypto.IVGenerator;
import java.io.IOException;
import java.io.OutputStream;

public class OutputStreamEncryption
extends OutputStream {
    protected OutputStream out;
    protected ARCFOUREncryption arcfour;
    protected AESCipher cipher;
    private byte[] sb = new byte[1];
    private static final int AES_128 = 4;
    private boolean aes;
    private boolean finished;

    public OutputStreamEncryption(OutputStream outputStream, byte[] byArray, int n2, int n3, int n4) {
        try {
            this.out = outputStream;
            boolean bl = this.aes = n4 == 4;
            if (this.aes) {
                byte[] byArray2 = IVGenerator.getIV();
                byte[] byArray3 = new byte[n3];
                System.arraycopy(byArray, n2, byArray3, 0, n3);
                this.cipher = new AESCipher(true, byArray3, byArray2);
                this.write(byArray2);
            } else {
                this.arcfour = new ARCFOUREncryption();
                this.arcfour.prepareARCFOURKey(byArray, n2, n3);
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public OutputStreamEncryption(OutputStream outputStream, byte[] byArray, int n2) {
        this(outputStream, byArray, 0, byArray.length, n2);
    }

    public void close() throws IOException {
        this.finish();
        this.out.close();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(int n2) throws IOException {
        this.sb[0] = (byte)n2;
        this.write(this.sb, 0, 1);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (this.aes) {
            byte[] byArray2 = this.cipher.update(byArray, n2, n3);
            if (byArray2 == null || byArray2.length == 0) {
                return;
            }
            this.out.write(byArray2, 0, byArray2.length);
        } else {
            byte[] byArray3 = new byte[Math.min(n3, 4192)];
            while (n3 > 0) {
                int n4 = Math.min(n3, byArray3.length);
                this.arcfour.encryptARCFOUR(byArray, n2, n4, byArray3, 0);
                this.out.write(byArray3, 0, n4);
                n3 -= n4;
                n2 += n4;
            }
        }
    }

    public void finish() throws IOException {
        if (!this.finished) {
            this.finished = true;
            if (this.aes) {
                byte[] byArray;
                try {
                    byArray = this.cipher.doFinal();
                }
                catch (Exception exception) {
                    throw new ExceptionConverter(exception);
                }
                this.out.write(byArray, 0, byArray.length);
            }
        }
    }
}

