/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.PortInUseException;
import gnu.io.RS485Port;
import gnu.io.RS485PortEvent;
import gnu.io.RS485PortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;

final class RS485
extends RS485Port {
    private int fd;
    static boolean dsrFlag;
    private final RS485OutputStream out = new RS485OutputStream();
    private final RS485InputStream in = new RS485InputStream();
    private int speed = 9600;
    private int dataBits = 8;
    private int stopBits = 1;
    private int parity = 0;
    private int flowmode = 0;
    private int timeout = 0;
    private int threshold = 0;
    private int InputBuffer = 0;
    private int OutputBuffer = 0;
    private RS485PortEventListener SPEventListener;
    private MonitorThread monThread;
    private int dataAvailable = 0;

    private static native void Initialize();

    public RS485(String string) throws PortInUseException {
        this.fd = this.open(string);
    }

    private native int open(String var1) throws PortInUseException;

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public void setRS485PortParams(int n2, int n3, int n4, int n5) throws UnsupportedCommOperationException {
        this.nativeSetRS485PortParams(n2, n3, n4, n5);
        this.speed = n2;
        this.dataBits = n3;
        this.stopBits = n4;
        this.parity = n5;
    }

    private native void nativeSetRS485PortParams(int var1, int var2, int var3, int var4) throws UnsupportedCommOperationException;

    public int getBaudRate() {
        return this.speed;
    }

    public int getDataBits() {
        return this.dataBits;
    }

    public int getStopBits() {
        return this.stopBits;
    }

    public int getParity() {
        return this.parity;
    }

    public void setFlowControlMode(int n2) {
        try {
            this.setflowcontrol(n2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        this.flowmode = n2;
    }

    public int getFlowControlMode() {
        return this.flowmode;
    }

    native void setflowcontrol(int var1) throws IOException;

    public void enableReceiveFraming(int n2) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException("Not supported");
    }

    public void disableReceiveFraming() {
    }

    public boolean isReceiveFramingEnabled() {
        return false;
    }

    public int getReceiveFramingByte() {
        return 0;
    }

    public native int NativegetReceiveTimeout();

    public native boolean NativeisReceiveTimeoutEnabled();

    public native void NativeEnableReceiveTimeoutThreshold(int var1, int var2, int var3);

    public void disableReceiveTimeout() {
        this.enableReceiveTimeout(0);
    }

    public void enableReceiveTimeout(int n2) {
        if (n2 >= 0) {
            this.timeout = n2;
            this.NativeEnableReceiveTimeoutThreshold(n2, this.threshold, this.InputBuffer);
        } else {
            System.out.println("Invalid timeout");
        }
    }

    public boolean isReceiveTimeoutEnabled() {
        return this.NativeisReceiveTimeoutEnabled();
    }

    public int getReceiveTimeout() {
        return this.NativegetReceiveTimeout();
    }

    public void enableReceiveThreshold(int n2) {
        if (n2 >= 0) {
            this.threshold = n2;
            this.NativeEnableReceiveTimeoutThreshold(this.timeout, this.threshold, this.InputBuffer);
        } else {
            System.out.println("Invalid Threshold");
        }
    }

    public void disableReceiveThreshold() {
        this.enableReceiveThreshold(0);
    }

    public int getReceiveThreshold() {
        return this.threshold;
    }

    public boolean isReceiveThresholdEnabled() {
        return this.threshold > 0;
    }

    public void setInputBufferSize(int n2) {
        this.InputBuffer = n2;
    }

    public int getInputBufferSize() {
        return this.InputBuffer;
    }

    public void setOutputBufferSize(int n2) {
        this.OutputBuffer = n2;
    }

    public int getOutputBufferSize() {
        return this.OutputBuffer;
    }

    public native boolean isDTR();

    public native void setDTR(boolean var1);

    public native void setRTS(boolean var1);

    private native void setDSR(boolean var1);

    public native boolean isCTS();

    public native boolean isDSR();

    public native boolean isCD();

    public native boolean isRI();

    public native boolean isRTS();

    public native void sendBreak(int var1);

    private native void writeByte(int var1) throws IOException;

    private native void writeArray(byte[] var1, int var2, int var3) throws IOException;

    private native void drain() throws IOException;

    private native int nativeavailable() throws IOException;

    private native int readByte() throws IOException;

    private native int readArray(byte[] var1, int var2, int var3) throws IOException;

    native void eventLoop();

    public void sendEvent(int n2, boolean bl) {
        switch (n2) {
            case 1: {
                this.dataAvailable = 1;
                if (this.monThread.Data) break;
                return;
            }
            case 2: {
                if (this.monThread.Output) break;
                return;
            }
            case 3: {
                if (this.monThread.CTS) break;
                return;
            }
            case 4: {
                if (this.monThread.DSR) break;
                return;
            }
            case 5: {
                if (this.monThread.RI) break;
                return;
            }
            case 6: {
                if (this.monThread.CD) break;
                return;
            }
            case 7: {
                if (this.monThread.OE) break;
                return;
            }
            case 8: {
                if (this.monThread.PE) break;
                return;
            }
            case 9: {
                if (this.monThread.FE) break;
                return;
            }
            case 10: {
                if (this.monThread.BI) break;
                return;
            }
            default: {
                System.err.println("unknown event:" + n2);
                return;
            }
        }
        RS485PortEvent rS485PortEvent = new RS485PortEvent(this, n2, !bl, bl);
        if (this.SPEventListener != null) {
            this.SPEventListener.RS485Event(rS485PortEvent);
        }
    }

    public void addEventListener(RS485PortEventListener rS485PortEventListener) throws TooManyListenersException {
        if (this.SPEventListener != null) {
            throw new TooManyListenersException();
        }
        this.SPEventListener = rS485PortEventListener;
        this.monThread = new MonitorThread();
        this.monThread.start();
    }

    public void removeEventListener() {
        this.SPEventListener = null;
        if (this.monThread != null) {
            this.monThread.interrupt();
            this.monThread = null;
        }
    }

    public void notifyOnDataAvailable(boolean bl) {
        this.monThread.Data = bl;
    }

    public void notifyOnOutputEmpty(boolean bl) {
        this.monThread.Output = bl;
    }

    public void notifyOnCTS(boolean bl) {
        this.monThread.CTS = bl;
    }

    public void notifyOnDSR(boolean bl) {
        this.monThread.DSR = bl;
    }

    public void notifyOnRingIndicator(boolean bl) {
        this.monThread.RI = bl;
    }

    public void notifyOnCarrierDetect(boolean bl) {
        this.monThread.CD = bl;
    }

    public void notifyOnOverrunError(boolean bl) {
        this.monThread.OE = bl;
    }

    public void notifyOnParityError(boolean bl) {
        this.monThread.PE = bl;
    }

    public void notifyOnFramingError(boolean bl) {
        this.monThread.FE = bl;
    }

    public void notifyOnBreakInterrupt(boolean bl) {
        this.monThread.BI = bl;
    }

    private native void nativeClose();

    public void close() {
        this.setDTR(false);
        this.setDSR(false);
        this.nativeClose();
        super.close();
        this.fd = 0;
    }

    protected void finalize() {
        if (this.fd > 0) {
            this.close();
        }
    }

    static {
        System.loadLibrary("rxtxRS485");
        RS485.Initialize();
        dsrFlag = false;
    }

    class MonitorThread
    extends Thread {
        private boolean CTS = false;
        private boolean DSR = false;
        private boolean RI = false;
        private boolean CD = false;
        private boolean OE = false;
        private boolean PE = false;
        private boolean FE = false;
        private boolean BI = false;
        private boolean Data = false;
        private boolean Output = false;

        MonitorThread() {
        }

        public void run() {
            RS485.this.eventLoop();
        }
    }

    class RS485InputStream
    extends InputStream {
        RS485InputStream() {
        }

        public int read() throws IOException {
            RS485.this.dataAvailable = 0;
            return RS485.this.readByte();
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            int n4;
            RS485.this.dataAvailable = 0;
            int n5 = 0;
            int[] nArray = new int[]{byArray.length, RS485.this.InputBuffer, n3};
            for (n4 = 0; nArray[n4] == 0 && n4 < nArray.length; ++n4) {
            }
            n5 = nArray[n4];
            while (n4 < nArray.length) {
                if (nArray[n4] > 0) {
                    n5 = Math.min(n5, nArray[n4]);
                }
                ++n4;
            }
            if ((n5 = Math.min(n5, RS485.this.threshold)) == 0) {
                n5 = 1;
            }
            int n6 = this.available();
            int n7 = RS485.this.readArray(byArray, n2, n5);
            return n7;
        }

        public int available() throws IOException {
            return RS485.this.nativeavailable();
        }
    }

    class RS485OutputStream
    extends OutputStream {
        RS485OutputStream() {
        }

        public void write(int n2) throws IOException {
            RS485.this.writeByte(n2);
        }

        public void write(byte[] byArray) throws IOException {
            RS485.this.writeArray(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n2, int n3) throws IOException {
            RS485.this.writeArray(byArray, n2, n3);
        }

        public void flush() throws IOException {
            RS485.this.drain();
        }
    }
}

