/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.Buildable;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MissingMethodException;
import groovy.lang.StringWriterIOException;
import groovy.lang.Writable;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.StringGroovyMethods;

public abstract class GString
extends GroovyObjectSupport
implements Comparable,
CharSequence,
Writable,
Buildable,
Serializable {
    static final long serialVersionUID = -2638020355892246323L;
    public static final GString EMPTY = new GString(new Object[0]){

        public String[] getStrings() {
            return new String[]{""};
        }
    };
    private Object[] values;

    public GString(Object values) {
        this.values = (Object[])values;
    }

    public GString(Object[] values) {
        this.values = values;
    }

    public abstract String[] getStrings();

    public Object invokeMethod(String name, Object args) {
        try {
            return super.invokeMethod(name, args);
        }
        catch (MissingMethodException e2) {
            return InvokerHelper.invokeMethod(this.toString(), name, args);
        }
    }

    public Object[] getValues() {
        return this.values;
    }

    public GString plus(GString that) {
        ArrayList<String> stringList = new ArrayList<String>();
        ArrayList<Object> valueList = new ArrayList<Object>();
        stringList.addAll(Arrays.asList(this.getStrings()));
        valueList.addAll(Arrays.asList(this.getValues()));
        List<String> thatStrings = Arrays.asList(that.getStrings());
        if (stringList.size() > valueList.size()) {
            thatStrings = new ArrayList<String>(thatStrings);
            String s2 = (String)stringList.get(stringList.size() - 1);
            s2 = s2 + thatStrings.get(0);
            thatStrings.remove(0);
            stringList.set(stringList.size() - 1, s2);
        }
        stringList.addAll(thatStrings);
        valueList.addAll(Arrays.asList(that.getValues()));
        final String[] newStrings = new String[stringList.size()];
        stringList.toArray(newStrings);
        Object[] newValues = valueList.toArray();
        return new GString(newValues){

            public String[] getStrings() {
                return newStrings;
            }
        };
    }

    public GString plus(String that) {
        String[] currentStrings = this.getStrings();
        boolean appendToLastString = currentStrings.length > this.getValues().length;
        String[] newStrings = appendToLastString ? new String[currentStrings.length] : new String[currentStrings.length + 1];
        Object[] newValues = new Object[this.getValues().length];
        int lastIndex = currentStrings.length;
        System.arraycopy(currentStrings, 0, newStrings, 0, lastIndex);
        System.arraycopy(this.getValues(), 0, newValues, 0, this.getValues().length);
        if (appendToLastString) {
            int n2 = lastIndex - 1;
            newStrings[n2] = newStrings[n2] + that;
        } else {
            newStrings[lastIndex] = that;
        }
        final String[] finalStrings = newStrings;
        return new GString(newValues){

            public String[] getStrings() {
                return finalStrings;
            }
        };
    }

    public int getValueCount() {
        return this.values.length;
    }

    public Object getValue(int idx) {
        return this.values[idx];
    }

    public String toString() {
        StringWriter buffer = new StringWriter();
        try {
            this.writeTo(buffer);
        }
        catch (IOException e2) {
            throw new StringWriterIOException(e2);
        }
        return buffer.toString();
    }

    public Writer writeTo(Writer out) throws IOException {
        String[] s2 = this.getStrings();
        int numberOfValues = this.values.length;
        int size = s2.length;
        for (int i2 = 0; i2 < size; ++i2) {
            out.write(s2[i2]);
            if (i2 >= numberOfValues) continue;
            Object value = this.values[i2];
            if (value instanceof Closure) {
                Closure c2 = (Closure)value;
                if (c2.getMaximumNumberOfParameters() == 0) {
                    InvokerHelper.write(out, c2.call());
                    continue;
                }
                if (c2.getMaximumNumberOfParameters() == 1) {
                    c2.call((Object)out);
                    continue;
                }
                throw new GroovyRuntimeException("Trying to evaluate a GString containing a Closure taking " + c2.getMaximumNumberOfParameters() + " parameters");
            }
            InvokerHelper.write(out, value);
        }
        return out;
    }

    public void build(GroovyObject builder) {
        String[] s2 = this.getStrings();
        int numberOfValues = this.values.length;
        int size = s2.length;
        for (int i2 = 0; i2 < size; ++i2) {
            builder.getProperty("mkp");
            builder.invokeMethod("yield", new Object[]{s2[i2]});
            if (i2 >= numberOfValues) continue;
            builder.getProperty("mkp");
            builder.invokeMethod("yield", new Object[]{this.values[i2]});
        }
    }

    public boolean equals(Object that) {
        if (that instanceof GString) {
            return this.equals((GString)that);
        }
        return false;
    }

    public boolean equals(GString that) {
        return this.toString().equals(that.toString());
    }

    public int hashCode() {
        return 37 + this.toString().hashCode();
    }

    public int compareTo(Object that) {
        return this.toString().compareTo(that.toString());
    }

    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    public int length() {
        return this.toString().length();
    }

    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    public Pattern negate() {
        return StringGroovyMethods.bitwiseNegate(this.toString());
    }

    public byte[] getBytes() {
        return this.toString().getBytes();
    }

    public byte[] getBytes(String charset) throws UnsupportedEncodingException {
        return this.toString().getBytes(charset);
    }
}

