/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.Closure;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListWithDefault<T>
implements List<T> {
    private final List<T> delegate;
    private final boolean lazyDefaultValues;
    private final Closure initClosure;

    private ListWithDefault(List<T> items, boolean lazyDefaultValues, Closure initClosure) {
        this.delegate = items;
        this.lazyDefaultValues = lazyDefaultValues;
        this.initClosure = initClosure;
    }

    public static <T> List<T> newInstance(List<T> items, boolean lazyDefaultValues, Closure initClosure) {
        if (items == null) {
            throw new IllegalArgumentException("Parameter \"items\" must not be null");
        }
        if (initClosure == null) {
            throw new IllegalArgumentException("Parameter \"initClosure\" must not be null");
        }
        return new ListWithDefault<T>(items, lazyDefaultValues, initClosure);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o2) {
        return this.delegate.contains(o2);
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        return this.delegate.toArray(ts);
    }

    @Override
    public boolean add(T t) {
        return this.delegate.add(t);
    }

    @Override
    public boolean remove(Object o2) {
        return this.delegate.remove(o2);
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        return this.delegate.containsAll(objects);
    }

    @Override
    public boolean addAll(Collection<? extends T> ts) {
        return this.delegate.addAll(ts);
    }

    @Override
    public boolean addAll(int i2, Collection<? extends T> ts) {
        return this.delegate.addAll(i2, ts);
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        return this.delegate.removeAll(objects);
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        return this.delegate.retainAll(objects);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    public T getAt(int index) {
        return this.get(index);
    }

    @Override
    public T get(int index) {
        T item;
        int size = this.size();
        int normalisedIndex = this.normaliseIndex(index, size);
        if (normalisedIndex >= size || normalisedIndex < 0) {
            boolean prepend = normalisedIndex < 0;
            int gapCount = prepend ? (normalisedIndex + 1) * -1 : normalisedIndex - size;
            for (int i2 = 0; i2 < gapCount; ++i2) {
                int idx;
                int n2 = idx = prepend ? 0 : this.size();
                if (this.lazyDefaultValues) {
                    this.delegate.add(idx, null);
                    continue;
                }
                this.delegate.add(idx, this.getDefaultValue(idx));
            }
            int idx = prepend ? 0 : normalisedIndex;
            this.delegate.add(idx, this.getDefaultValue(idx));
            normalisedIndex = this.normaliseIndex(index, this.size());
        }
        if ((item = this.delegate.get(normalisedIndex)) == null && this.lazyDefaultValues) {
            item = this.getDefaultValue(normalisedIndex);
            this.delegate.set(normalisedIndex, item);
        }
        return item;
    }

    private T getDefaultValue(int idx) {
        return (T)this.initClosure.call(new Object[]{idx});
    }

    private int normaliseIndex(int index, int size) {
        if (index < 0) {
            index += size;
        }
        return index;
    }

    @Override
    public T set(int i2, T t) {
        return this.delegate.set(i2, t);
    }

    @Override
    public void add(int i2, T t) {
        this.delegate.add(i2, t);
    }

    @Override
    public T remove(int i2) {
        return this.delegate.remove(i2);
    }

    @Override
    public int indexOf(Object o2) {
        return this.delegate.indexOf(o2);
    }

    @Override
    public int lastIndexOf(Object o2) {
        return this.delegate.lastIndexOf(o2);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.delegate.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int i2) {
        return this.delegate.listIterator(i2);
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return new ListWithDefault<T>(this.delegate.subList(fromIndex, toIndex), this.lazyDefaultValues, (Closure)this.initClosure.clone());
    }
}

