/*
 * Decompiled with CFR 0.152.
 */
package groovy.ui;

import groovy.lang.GroovyShell;
import groovy.lang.Script;
import groovy.ui.GroovyMain;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;

public class GroovySocketServer
implements Runnable {
    private URL url;
    private GroovyShell groovy;
    private boolean isScriptFile;
    private String scriptFilenameOrText;
    private boolean autoOutput;

    public GroovySocketServer(GroovyShell groovy, boolean isScriptFile, String scriptFilenameOrText, boolean autoOutput, int port) {
        this.groovy = groovy;
        this.isScriptFile = isScriptFile;
        this.scriptFilenameOrText = scriptFilenameOrText;
        this.autoOutput = autoOutput;
        try {
            this.url = new URL("http", InetAddress.getLocalHost().getHostAddress(), port, "/");
            System.out.println("groovy is listening on port " + port);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        new Thread(this).start();
    }

    public void run() {
        try {
            ServerSocket serverSocket = new ServerSocket(this.url.getPort());
            while (true) {
                Script script;
                if (this.isScriptFile) {
                    GroovyMain gm = new GroovyMain();
                    script = this.groovy.parse(gm.getText(this.scriptFilenameOrText));
                } else {
                    script = this.groovy.parse(this.scriptFilenameOrText);
                }
                new GroovyClientConnection(script, this.autoOutput, serverSocket.accept());
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return;
        }
    }

    class GroovyClientConnection
    implements Runnable {
        private Script script;
        private Socket socket;
        private BufferedReader reader;
        private PrintWriter writer;
        private boolean autoOutputFlag;

        GroovyClientConnection(Script script, boolean autoOutput, Socket socket) throws IOException {
            this.script = script;
            this.autoOutputFlag = autoOutput;
            this.socket = socket;
            this.reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            this.writer = new PrintWriter(socket.getOutputStream());
            new Thread((Runnable)this, "Groovy client connection - " + socket.getInetAddress().getHostAddress()).start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String line = null;
                this.script.setProperty("out", this.writer);
                this.script.setProperty("socket", this.socket);
                this.script.setProperty("init", Boolean.TRUE);
                while ((line = this.reader.readLine()) != null) {
                    this.script.setProperty("line", line);
                    Object o2 = this.script.run();
                    this.script.setProperty("init", Boolean.FALSE);
                    if (o2 != null) {
                        if ("success".equals(o2)) {
                            break;
                        }
                        if (this.autoOutputFlag) {
                            this.writer.println(o2);
                        }
                    }
                    this.writer.flush();
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            finally {
                try {
                    this.writer.flush();
                    this.writer.close();
                }
                finally {
                    try {
                        this.socket.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
        }
    }
}

