/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermutationGenerator<E>
implements Iterator<List<E>> {
    private int[] a;
    private BigInteger numLeft;
    private BigInteger total;
    private List<E> items;

    public PermutationGenerator(Collection<E> items) {
        this.items = new ArrayList<E>(items);
        int n2 = items.size();
        if (n2 < 1) {
            throw new IllegalArgumentException("At least one item required");
        }
        this.a = new int[n2];
        this.total = PermutationGenerator.getFactorial(n2);
        this.reset();
    }

    public void reset() {
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            this.a[i2] = i2;
        }
        this.numLeft = new BigInteger(this.total.toString());
    }

    public BigInteger getTotal() {
        return this.total;
    }

    @Override
    public boolean hasNext() {
        return this.numLeft.compareTo(BigInteger.ZERO) == 1;
    }

    private static BigInteger getFactorial(int n2) {
        BigInteger fact = BigInteger.ONE;
        for (int i2 = n2; i2 > 1; --i2) {
            fact = fact.multiply(new BigInteger(Integer.toString(i2)));
        }
        return fact;
    }

    @Override
    public List<E> next() {
        if (this.numLeft.equals(this.total)) {
            this.numLeft = this.numLeft.subtract(BigInteger.ONE);
            return this.items;
        }
        int j2 = this.a.length - 2;
        while (this.a[j2] > this.a[j2 + 1]) {
            --j2;
        }
        int k2 = this.a.length - 1;
        while (this.a[j2] > this.a[k2]) {
            --k2;
        }
        int temp = this.a[k2];
        this.a[k2] = this.a[j2];
        this.a[j2] = temp;
        int r2 = this.a.length - 1;
        for (int s2 = j2 + 1; r2 > s2; --r2, ++s2) {
            temp = this.a[s2];
            this.a[s2] = this.a[r2];
            this.a[r2] = temp;
        }
        this.numLeft = this.numLeft.subtract(BigInteger.ONE);
        ArrayList<E> ans = new ArrayList<E>(this.a.length);
        for (int index : this.a) {
            ans.add(this.items.get(index));
        }
        return ans;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() not allowed for PermutationGenerator");
    }
}

