/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarcommonscli;

class OptionValidator {
    OptionValidator() {
    }

    static void validateOption(String opt) throws IllegalArgumentException {
        if (opt == null) {
            return;
        }
        if (opt.length() == 1) {
            char ch = opt.charAt(0);
            if (!OptionValidator.isValidOpt(ch)) {
                throw new IllegalArgumentException("illegal option value '" + ch + "'");
            }
        } else {
            char[] chars = opt.toCharArray();
            for (int i2 = 0; i2 < chars.length; ++i2) {
                if (OptionValidator.isValidChar(chars[i2])) continue;
                throw new IllegalArgumentException("opt contains illegal character value '" + chars[i2] + "'");
            }
        }
    }

    private static boolean isValidOpt(char c2) {
        return OptionValidator.isValidChar(c2) || c2 == ' ' || c2 == '?' || c2 == '@';
    }

    private static boolean isValidChar(char c2) {
        return Character.isJavaIdentifierPart(c2);
    }
}

