/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.iconlabel;

import java.awt.Color;
import net.sf.jasperreports.components.iconlabel.ContainerFillEnum;
import net.sf.jasperreports.components.iconlabel.IconLabelComponent;
import net.sf.jasperreports.components.iconlabel.IconLabelDirectionEnum;
import net.sf.jasperreports.components.iconlabel.IconPositionEnum;
import net.sf.jasperreports.engine.JRAlignment;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRImageAlignment;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.component.BaseFillComponent;
import net.sf.jasperreports.engine.component.ConditionalStyleAwareFillComponent;
import net.sf.jasperreports.engine.component.FillPrepareResult;
import net.sf.jasperreports.engine.component.StretchableFillComponent;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillElementContainer;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillTextField;
import net.sf.jasperreports.engine.fill.JRTemplateFrame;
import net.sf.jasperreports.engine.fill.JRTemplatePrintFrame;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.type.VerticalImageAlignEnum;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public class IconLabelComponentFill
extends BaseFillComponent
implements StretchableFillComponent,
ConditionalStyleAwareFillComponent,
JRBoxContainer,
JRAlignment,
JRImageAlignment {
    private final IconLabelComponent iconLabelComponent;
    private final JRLineBox lineBox;
    private final JRFillTextField labelTextField;
    private final JRFillTextField iconTextField;
    private JRTemplateFrame template;
    private JRTemplatePrintFrame printElement;
    private JRPrintText labelPrintText;
    private JRPrintText iconPrintText;
    private boolean iconsVisible = true;
    private IconLabelDirectionEnum direction = IconLabelDirectionEnum.HORIZONTAL;
    private int middlePadding;
    private int stretchHeight;

    public IconLabelComponentFill(IconLabelComponent iconLabelComponent, JRFillObjectFactory factory) {
        this.iconLabelComponent = iconLabelComponent;
        this.lineBox = iconLabelComponent.getLineBox().clone(this);
        this.labelTextField = (JRFillTextField)factory.getVisitResult(iconLabelComponent.getLabelTextField());
        this.iconTextField = (JRFillTextField)factory.getVisitResult(iconLabelComponent.getIconTextField());
    }

    public IconLabelComponentFill(IconLabelComponent iconLabelComponent, JRFillCloneFactory factory) {
        this.iconLabelComponent = iconLabelComponent;
        this.lineBox = iconLabelComponent.getLineBox().clone(this);
        this.labelTextField = null;
        this.iconTextField = null;
    }

    protected IconLabelComponent getIconLabelComponent() {
        return this.iconLabelComponent;
    }

    @Override
    public void evaluate(byte evaluation) throws JRException {
        this.labelTextField.evaluate(evaluation);
        this.iconTextField.evaluate(evaluation);
    }

    @Override
    public JRPrintElement fill() {
        JRComponentElement element = this.fillContext.getComponentElement();
        if (this.template == null) {
            this.template = new JRTemplateFrame(this.fillContext.getElementOrigin(), this.fillContext.getDefaultStyleProvider());
            this.template.setStyle(this.fillContext.getComponentElement().getStyle());
            this.template.setMode(this.fillContext.getComponentElement().getOwnModeValue());
            this.template.setBackcolor(this.fillContext.getComponentElement().getOwnBackcolor());
            this.template.setForecolor(this.fillContext.getComponentElement().getOwnForecolor());
            JRBoxUtil.copy(this.getLineBox(), this.template.getLineBox());
            this.template = this.deduplicate(this.template);
        }
        this.printElement = new JRTemplatePrintFrame(this.template, this.printElementOriginator);
        this.printElement.setUUID(element.getUUID());
        this.printElement.setX(element.getX());
        this.printElement.setY(this.fillContext.getElementPrintY());
        this.printElement.setWidth(element.getWidth());
        this.printElement.setHeight(this.stretchHeight);
        this.fillContext.getFiller().getPropertiesUtil().transferProperties(this.iconLabelComponent.getContext().getComponentElement(), (JRPropertiesHolder)this.printElement, "net.sf.jasperreports.print.transfer.");
        if (this.direction == IconLabelDirectionEnum.HORIZONTAL) {
            this.fillHorizontal();
        } else {
            this.fillVertical();
        }
        this.copy(this.printElement);
        return this.printElement;
    }

    public void fillHorizontal() {
        try {
            this.labelPrintText = (JRPrintText)this.labelTextField.fill();
        }
        catch (JRException e2) {
            throw new JRRuntimeException(e2);
        }
        if (this.iconLabelComponent.getLabelFill() != ContainerFillEnum.HORIZONTAL && this.iconLabelComponent.getLabelFill() != ContainerFillEnum.BOTH) {
            int calculatedLabelWidth = (int)this.labelTextField.getTextWidth() + this.labelTextField.getLineBox().getLeftPadding() + this.labelTextField.getLineBox().getRightPadding() + 3;
            this.labelPrintText.setWidth(Math.min(this.labelTextField.getWidth(), calculatedLabelWidth));
        }
        if (this.iconLabelComponent.getLabelFill() == ContainerFillEnum.VERTICAL || this.iconLabelComponent.getLabelFill() == ContainerFillEnum.BOTH) {
            this.labelPrintText.setHeight(Math.max(this.labelTextField.getStretchHeight(), this.stretchHeight - this.getLineBox().getTopPadding() - this.getLineBox().getBottomPadding()));
        }
        try {
            this.iconPrintText = (JRPrintText)this.iconTextField.fill();
        }
        catch (JRException e3) {
            throw new JRRuntimeException(e3);
        }
        this.iconPrintText.setWidth((int)this.iconTextField.getTextWidth() + this.iconTextField.getLineBox().getLeftPadding() + this.iconTextField.getLineBox().getRightPadding());
        int commonHeight = Math.max(this.labelPrintText.getHeight(), this.iconPrintText.getHeight());
        this.labelPrintText.setHeight(commonHeight);
        this.iconPrintText.setHeight(commonHeight);
        switch (this.getHorizontalImageAlign()) {
            case LEFT: {
                if (this.iconLabelComponent.getIconPosition() == IconPositionEnum.START) {
                    this.labelPrintText.setX(this.iconPrintText.getWidth() + this.middlePadding);
                    this.iconPrintText.setX(0);
                    break;
                }
                this.labelPrintText.setX(0);
                this.iconPrintText.setX(this.labelPrintText.getWidth() + this.middlePadding);
                break;
            }
            case CENTER: {
                if (this.iconLabelComponent.getIconPosition() == IconPositionEnum.START) {
                    this.iconPrintText.setX((this.iconLabelComponent.getContext().getComponentElement().getWidth() - this.getLineBox().getLeftPadding() - this.getLineBox().getRightPadding() - this.middlePadding - this.labelPrintText.getWidth() - this.iconPrintText.getWidth()) / 2);
                    this.labelPrintText.setX(this.iconPrintText.getX() + this.iconPrintText.getWidth() + this.middlePadding);
                    break;
                }
                this.labelPrintText.setX((this.iconLabelComponent.getContext().getComponentElement().getWidth() - this.getLineBox().getLeftPadding() - this.getLineBox().getRightPadding() - this.middlePadding - this.labelPrintText.getWidth() - this.iconPrintText.getWidth()) / 2);
                this.iconPrintText.setX(this.labelPrintText.getX() + this.labelPrintText.getWidth() + this.middlePadding);
                break;
            }
            case RIGHT: {
                if (this.iconLabelComponent.getIconPosition() == IconPositionEnum.START) {
                    this.labelPrintText.setX(this.iconLabelComponent.getContext().getComponentElement().getWidth() - this.getLineBox().getLeftPadding() - this.getLineBox().getRightPadding() - this.labelPrintText.getWidth());
                    this.iconPrintText.setX(this.labelPrintText.getX() - this.iconPrintText.getWidth() - this.middlePadding);
                    break;
                }
                this.iconPrintText.setX(this.iconLabelComponent.getContext().getComponentElement().getWidth() - this.getLineBox().getLeftPadding() - this.getLineBox().getRightPadding() - this.iconPrintText.getWidth());
                this.labelPrintText.setX(this.iconPrintText.getX() - this.labelPrintText.getWidth() - this.middlePadding);
            }
        }
        switch (this.getVerticalImageAlign()) {
            case TOP: {
                this.labelPrintText.setY(0);
                this.iconPrintText.setY(0);
                break;
            }
            case MIDDLE: {
                this.labelPrintText.setY((this.stretchHeight - this.getLineBox().getTopPadding() - this.getLineBox().getBottomPadding() - this.labelPrintText.getHeight()) / 2);
                this.iconPrintText.setY((this.stretchHeight - this.getLineBox().getTopPadding() - this.getLineBox().getBottomPadding() - this.iconPrintText.getHeight()) / 2);
                break;
            }
            case BOTTOM: {
                this.labelPrintText.setY(this.stretchHeight - this.getLineBox().getTopPadding() - this.getLineBox().getBottomPadding() - this.labelPrintText.getHeight());
                this.iconPrintText.setY(this.stretchHeight - this.getLineBox().getTopPadding() - this.getLineBox().getBottomPadding() - this.iconPrintText.getHeight());
            }
        }
    }

    public void fillVertical() {
        try {
            this.labelPrintText = (JRPrintText)this.labelTextField.fill();
        }
        catch (JRException e2) {
            throw new JRRuntimeException(e2);
        }
        if (this.iconLabelComponent.getLabelFill() == ContainerFillEnum.VERTICAL || this.iconLabelComponent.getLabelFill() == ContainerFillEnum.BOTH) {
            this.labelPrintText.setHeight(Math.max(this.labelTextField.getStretchHeight(), this.stretchHeight - (this.direction == IconLabelDirectionEnum.HORIZONTAL ? 0 : this.iconTextField.getStretchHeight() + this.middlePadding) - this.getLineBox().getTopPadding() - this.getLineBox().getBottomPadding()));
        }
        try {
            this.iconPrintText = (JRPrintText)this.iconTextField.fill();
        }
        catch (JRException e3) {
            throw new JRRuntimeException(e3);
        }
        switch (this.getHorizontalImageAlign()) {
            case LEFT: {
                this.labelPrintText.setX(0);
                this.iconPrintText.setX(0);
                break;
            }
            case CENTER: {
                this.labelPrintText.setX((this.iconLabelComponent.getContext().getComponentElement().getWidth() - this.getLineBox().getLeftPadding() - this.getLineBox().getRightPadding() - this.labelPrintText.getWidth()) / 2);
                this.iconPrintText.setX((this.iconLabelComponent.getContext().getComponentElement().getWidth() - this.getLineBox().getLeftPadding() - this.getLineBox().getRightPadding() - this.iconPrintText.getWidth()) / 2);
                break;
            }
            case RIGHT: {
                this.labelPrintText.setX(this.iconLabelComponent.getContext().getComponentElement().getWidth() - this.getLineBox().getLeftPadding() - this.getLineBox().getRightPadding() - this.labelPrintText.getWidth());
                this.iconPrintText.setX(this.iconLabelComponent.getContext().getComponentElement().getWidth() - this.getLineBox().getLeftPadding() - this.getLineBox().getRightPadding() - this.iconPrintText.getWidth());
            }
        }
        switch (this.getVerticalImageAlign()) {
            case TOP: {
                if (this.iconLabelComponent.getIconPosition() == IconPositionEnum.START) {
                    this.labelPrintText.setY(this.iconPrintText.getHeight() + this.middlePadding);
                    this.iconPrintText.setY(0);
                    break;
                }
                this.labelPrintText.setY(0);
                this.iconPrintText.setY(this.labelPrintText.getHeight() + this.middlePadding);
                break;
            }
            case MIDDLE: {
                if (this.iconLabelComponent.getIconPosition() == IconPositionEnum.START) {
                    this.iconPrintText.setY((this.stretchHeight - this.getLineBox().getTopPadding() - this.getLineBox().getBottomPadding() - this.middlePadding - this.labelPrintText.getHeight() - this.iconPrintText.getHeight()) / 2);
                    this.labelPrintText.setY(this.iconPrintText.getY() + this.iconPrintText.getHeight() + this.middlePadding);
                    break;
                }
                this.labelPrintText.setY((this.stretchHeight - this.getLineBox().getTopPadding() - this.getLineBox().getBottomPadding() - this.middlePadding - this.labelPrintText.getHeight() - this.iconPrintText.getHeight()) / 2);
                this.iconPrintText.setY(this.labelPrintText.getY() + this.labelPrintText.getHeight() + this.middlePadding);
                break;
            }
            case BOTTOM: {
                if (this.iconLabelComponent.getIconPosition() == IconPositionEnum.START) {
                    this.labelPrintText.setY(this.stretchHeight - this.getLineBox().getTopPadding() - this.getLineBox().getBottomPadding() - this.labelPrintText.getHeight());
                    this.iconPrintText.setY(this.labelPrintText.getY() - this.iconPrintText.getHeight() - this.middlePadding);
                    break;
                }
                this.iconPrintText.setY(this.stretchHeight - this.getLineBox().getTopPadding() - this.getLineBox().getBottomPadding() - this.iconPrintText.getHeight());
                this.labelPrintText.setY(this.iconPrintText.getY() - this.labelPrintText.getHeight() - this.middlePadding);
            }
        }
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public void setConditionalStylesContainer(JRFillElementContainer conditionalStylesContainer) {
        this.labelTextField.setConditionalStylesContainer(conditionalStylesContainer);
        this.iconTextField.setConditionalStylesContainer(conditionalStylesContainer);
    }

    @Override
    public FillPrepareResult prepare(int availableHeight) {
        float paddingDiff = this.iconLabelComponent.getContext().getComponentElement().getWidth() - this.getLineBox().getLeftPadding() - this.getLineBox().getRightPadding() - 1;
        if (paddingDiff < 0.0f) {
            int leftPadding = this.getLineBox().getLeftPadding() + (int)Math.floor(paddingDiff /= 2.0f);
            leftPadding = leftPadding < 0 ? 0 : leftPadding;
            this.getLineBox().setLeftPadding(leftPadding);
            int rightPadding = this.getLineBox().getRightPadding() + (int)Math.ceil(paddingDiff);
            rightPadding = rightPadding < 0 ? 0 : rightPadding;
            this.getLineBox().setRightPadding(rightPadding);
        }
        int availableWidth = this.iconLabelComponent.getContext().getComponentElement().getWidth() - this.getLineBox().getLeftPadding() - this.getLineBox().getRightPadding();
        this.middlePadding = (int)(this.iconTextField.getFontsize() / 2.0f);
        this.middlePadding = availableWidth <= this.middlePadding ? 0 : Math.min(availableWidth - this.middlePadding, this.middlePadding);
        availableWidth = this.iconLabelComponent.getContext().getComponentElement().getWidth() - this.getLineBox().getLeftPadding() - this.getLineBox().getRightPadding() - this.middlePadding;
        int textAvailableHeight = availableHeight - this.getLineBox().getTopPadding() - this.getLineBox().getBottomPadding();
        this.iconTextField.setWidth(availableWidth);
        try {
            this.iconTextField.prepare(textAvailableHeight, this.fillContext.getFillContainerContext().isCurrentOverflow());
        }
        catch (JRException e2) {
            throw new JRRuntimeException(e2);
        }
        boolean changeDirection = false;
        int iconsUsedWidth = 0;
        if (this.iconTextField.getTextWidth() > (float)(this.iconTextField.getWidth() - this.iconTextField.getLineBox().getLeftPadding() - this.iconTextField.getLineBox().getRightPadding())) {
            changeDirection = true;
        } else {
            iconsUsedWidth = (int)this.iconTextField.getTextWidth() + this.iconTextField.getLineBox().getLeftPadding() + this.iconTextField.getLineBox().getRightPadding();
            changeDirection = availableWidth <= iconsUsedWidth;
            int n2 = changeDirection ? availableWidth : availableWidth - iconsUsedWidth;
        }
        int labelAvailableWidth = changeDirection ? availableWidth + this.middlePadding : availableWidth - iconsUsedWidth;
        this.labelTextField.setWidth(labelAvailableWidth);
        try {
            this.labelTextField.prepare(textAvailableHeight, this.fillContext.getFillContainerContext().isCurrentOverflow());
        }
        catch (JRException e3) {
            throw new JRRuntimeException(e3);
        }
        if (changeDirection) {
            this.direction = IconLabelDirectionEnum.VERTICAL;
            this.middlePadding = (int)(this.iconTextField.getFontsize() / 2.0f);
            int iconAvailableHeight = (this.labelTextField.isStretchWithOverflow() ? textAvailableHeight - this.labelTextField.getStretchHeight() : this.iconLabelComponent.getContext().getComponentElement().getHeight() - this.labelTextField.getStretchHeight()) - this.middlePadding;
            boolean bl = this.iconsVisible = iconAvailableHeight > 0;
            if (this.iconsVisible) {
                try {
                    this.iconTextField.rewind();
                    this.iconTextField.reset();
                    this.iconTextField.setWidth(labelAvailableWidth);
                    this.iconTextField.prepare(iconAvailableHeight, this.fillContext.getFillContainerContext().isCurrentOverflow());
                    this.iconsVisible = this.iconTextField.getPrintElementHeight() <= iconAvailableHeight;
                }
                catch (JRException e4) {
                    throw new JRRuntimeException(e4);
                }
            }
        }
        this.stretchHeight = (this.direction == IconLabelDirectionEnum.HORIZONTAL ? Math.max(this.labelTextField.getStretchHeight(), this.iconsVisible ? this.iconTextField.getStretchHeight() : 0) : this.labelTextField.getStretchHeight() + (this.iconsVisible ? this.iconTextField.getStretchHeight() + this.middlePadding : 0)) + this.getLineBox().getTopPadding() + this.getLineBox().getBottomPadding();
        return FillPrepareResult.printStretch(this.stretchHeight, false);
    }

    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void evaluateDelayedElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluate(evaluation);
        this.copy((JRGenericPrintElement)element);
    }

    protected void copy(JRGenericPrintElement printElement) {
        printElement.setParameterValue("lineBox", this.iconLabelComponent.getLineBox().clone(null));
        printElement.setParameterValue("labelTextElement", this.labelPrintText);
        printElement.setParameterValue("iconTextElement", this.iconPrintText);
    }

    protected void copy(JRPrintFrame printFrame) {
        this.printElement.addElement(this.labelPrintText);
        if (this.iconsVisible) {
            this.printElement.addElement(this.iconPrintText);
        }
    }

    @Override
    public Color getDefaultLineColor() {
        return Color.black;
    }

    @Override
    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.fillContext.getComponentElement().getDefaultStyleProvider();
    }

    @Override
    public JRStyle getStyle() {
        return this.fillContext.getComponentElement().getStyle();
    }

    @Override
    public String getStyleNameReference() {
        return this.fillContext.getComponentElement().getStyleNameReference();
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    @Override
    public HorizontalAlignEnum getHorizontalAlignmentValue() {
        return HorizontalAlignEnum.getHorizontalAlignEnum(this.getHorizontalImageAlign());
    }

    @Override
    public HorizontalAlignEnum getOwnHorizontalAlignmentValue() {
        return HorizontalAlignEnum.getHorizontalAlignEnum(this.getOwnHorizontalImageAlign());
    }

    @Override
    public void setHorizontalAlignment(HorizontalAlignEnum horizontalAlignmentValue) {
        this.setHorizontalImageAlign(HorizontalAlignEnum.getHorizontalImageAlignEnum(horizontalAlignmentValue));
    }

    @Override
    public VerticalAlignEnum getVerticalAlignmentValue() {
        return VerticalAlignEnum.getVerticalAlignEnum(this.getVerticalImageAlign());
    }

    @Override
    public VerticalAlignEnum getOwnVerticalAlignmentValue() {
        return VerticalAlignEnum.getVerticalAlignEnum(this.getOwnVerticalImageAlign());
    }

    @Override
    public void setVerticalAlignment(VerticalAlignEnum verticalAlignmentValue) {
        this.setVerticalImageAlign(VerticalAlignEnum.getVerticalImageAlignEnum(verticalAlignmentValue));
    }

    @Override
    public HorizontalImageAlignEnum getHorizontalImageAlign() {
        return JRStyleResolver.getHorizontalImageAlign(this);
    }

    @Override
    public HorizontalImageAlignEnum getOwnHorizontalImageAlign() {
        return this.iconLabelComponent.getOwnHorizontalImageAlign();
    }

    @Override
    public void setHorizontalImageAlign(HorizontalImageAlignEnum horizontalAlignment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VerticalImageAlignEnum getVerticalImageAlign() {
        return JRStyleResolver.getVerticalImageAlign(this);
    }

    @Override
    public VerticalImageAlignEnum getOwnVerticalImageAlign() {
        return this.iconLabelComponent.getOwnVerticalImageAlign();
    }

    @Override
    public void setVerticalImageAlign(VerticalImageAlignEnum verticalAlignment) {
        throw new UnsupportedOperationException();
    }
}

