/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.list;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.list.FillDatasetRun;
import net.sf.jasperreports.components.list.ListComponent;
import net.sf.jasperreports.components.list.ListContents;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementContainer;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.component.BaseFillComponent;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateFrame;
import net.sf.jasperreports.engine.fill.JRTemplatePrintFrame;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseFillList
extends BaseFillComponent
implements JRFillCloneable {
    private static final Log log = LogFactory.getLog(BaseFillList.class);
    protected final int contentsHeight;
    protected final FillDatasetRun datasetRun;
    protected Map<JRStyle, JRTemplateFrame> printFrameTemplates = new HashMap<JRStyle, JRTemplateFrame>();
    protected JRTemplatePrintFrame printFrame;
    protected boolean filling;
    protected boolean fillStarted;

    public BaseFillList(ListComponent component, JRFillObjectFactory factory) throws JRException {
        ListContents listContents = component.getContents();
        this.contentsHeight = listContents.getHeight();
        this.datasetRun = new FillDatasetRun(component.getDatasetRun(), factory);
    }

    protected BaseFillList(BaseFillList list, JRFillCloneFactory factory) {
        super(list, factory);
        this.contentsHeight = list.contentsHeight;
        this.datasetRun = new FillDatasetRun(list.datasetRun, factory);
        this.printFrameTemplates = list.printFrameTemplates;
    }

    protected JRFillExpressionEvaluator createDatasetExpressionEvaluator() {
        return new JRFillExpressionEvaluator(){

            @Override
            public Object evaluate(JRExpression expression, byte evaluationType) throws JRException {
                return BaseFillList.this.datasetRun.evaluateDatasetExpression(expression, evaluationType);
            }

            @Override
            public JRFillDataset getFillDataset() {
                return BaseFillList.this.datasetRun.getDataset();
            }
        };
    }

    @Override
    public void evaluate(byte evaluation) throws JRException {
        if (this.filling) {
            log.warn("List fill did not complete, closing previous dataset run");
            this.datasetRun.end();
        }
        this.filling = false;
        this.fillStarted = false;
        this.datasetRun.evaluate(evaluation);
    }

    protected void createPrintFrame() {
        this.printFrame = new JRTemplatePrintFrame(this.getFrameTemplate(), this.printElementOriginator);
        this.printFrame.setUUID(this.fillContext.getComponentElement().getUUID());
        this.printFrame.setX(this.fillContext.getComponentElement().getX());
        this.printFrame.setWidth(this.fillContext.getComponentElement().getWidth());
    }

    protected JRTemplateFrame getFrameTemplate() {
        JRStyle style = this.fillContext.getElementStyle();
        JRTemplateFrame frameTemplate = this.printFrameTemplates.get(style);
        if (frameTemplate == null) {
            frameTemplate = new JRTemplateFrame(this.fillContext.getElementOrigin(), this.fillContext.getDefaultStyleProvider());
            frameTemplate.setElement(this.fillContext.getComponentElement());
            frameTemplate = this.deduplicate(frameTemplate);
            this.printFrameTemplates.put(style, frameTemplate);
        }
        return frameTemplate;
    }

    @Override
    public JRPrintElement fill() {
        this.printFrame.setY(this.fillContext.getElementPrintY());
        return this.printFrame;
    }

    @Override
    public void rewind() {
        try {
            if (this.filling) {
                this.datasetRun.end();
            }
            if (this.fillStarted) {
                if (log.isDebugEnabled()) {
                    log.debug("Rewinding started list");
                }
                this.datasetRun.rewind();
            }
            this.filling = false;
            this.fillStarted = false;
        }
        catch (JRException e2) {
            throw new JRRuntimeException(e2);
        }
    }

    protected static class AppendingPrintElementContainer
    implements JRPrintElementContainer {
        private final JRPrintElementContainer container;
        private final int initialContainerHeight;
        private int xOffset;

        public AppendingPrintElementContainer(JRPrintElementContainer container) {
            this.container = container;
            this.initialContainerHeight = container.getHeight();
        }

        @Override
        public void addElement(JRPrintElement element) {
            if (this.xOffset > 0) {
                element.setX(element.getX() + this.xOffset);
            }
            element.setY(this.initialContainerHeight + element.getY());
            this.container.addElement(element);
        }

        @Override
        public List<JRPrintElement> getElements() {
            return this.container.getElements();
        }

        @Override
        public int getHeight() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setHeight(int height) {
            int newHeight = this.initialContainerHeight + height;
            if (newHeight > this.container.getHeight()) {
                this.container.setHeight(newHeight);
            }
        }

        public void setXOffset(int xOffset) {
            this.xOffset = xOffset;
        }
    }
}

