/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.ColumnFactory;
import net.sf.jasperreports.components.table.TableComponent;
import net.sf.jasperreports.components.table.WhenNoDataTypeTableEnum;
import net.sf.jasperreports.components.table.util.ColumnElementsVisitor;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.ElementsVisitorUtils;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class StandardTable
implements TableComponent,
Serializable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_DATASET_RUN = "datasetRun";
    public static final String PROPERTY_COLUMNS = "columns";
    public static final String PROPERTY_WHEN_NO_DATA_TYPE = "whenNoDataType";
    private JRDatasetRun datasetRun;
    private List<BaseColumn> columns;
    private WhenNoDataTypeTableEnum whenNoDataType;
    private transient JRPropertyChangeSupport eventSupport;

    public StandardTable() {
        this.columns = new ArrayList<BaseColumn>();
    }

    public StandardTable(TableComponent table, JRBaseObjectFactory factory) {
        this.whenNoDataType = table.getWhenNoDataType();
        this.datasetRun = factory.getDatasetRun(table.getDatasetRun());
        ColumnFactory columnFactory = new ColumnFactory(factory);
        this.columns = columnFactory.createColumns(table.getColumns());
    }

    @Override
    public List<BaseColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<BaseColumn> columns) {
        List<BaseColumn> old = this.columns;
        this.columns = columns;
        this.getEventSupport().firePropertyChange(PROPERTY_COLUMNS, old, this.columns);
    }

    public void addColumn(BaseColumn column) {
        this.columns.add(column);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_COLUMNS, column, this.columns.size() - 1);
    }

    public void addColumn(int index, BaseColumn column) {
        this.columns.add(index, column);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_COLUMNS, column, index);
    }

    public boolean removeColumn(BaseColumn column) {
        int idx = this.columns.indexOf(column);
        if (idx >= 0) {
            this.columns.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_COLUMNS, column, idx);
        }
        return idx >= 0;
    }

    @Override
    public JRDatasetRun getDatasetRun() {
        return this.datasetRun;
    }

    public void setDatasetRun(JRDatasetRun datasetRun) {
        JRDatasetRun old = this.datasetRun;
        this.datasetRun = datasetRun;
        this.getEventSupport().firePropertyChange(PROPERTY_DATASET_RUN, old, this.datasetRun);
    }

    @Override
    public WhenNoDataTypeTableEnum getWhenNoDataType() {
        return this.whenNoDataType;
    }

    public void setWhenNoDataType(WhenNoDataTypeTableEnum whenNoDataType) {
        WhenNoDataTypeTableEnum old = this.whenNoDataType;
        this.whenNoDataType = whenNoDataType;
        this.getEventSupport().firePropertyChange(PROPERTY_WHEN_NO_DATA_TYPE, old, this.whenNoDataType);
    }

    @Override
    public Object clone() {
        StandardTable clone = null;
        try {
            clone = (StandardTable)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new JRRuntimeException(e2);
        }
        clone.datasetRun = JRCloneUtils.nullSafeClone(this.datasetRun);
        clone.columns = JRCloneUtils.cloneList(this.columns);
        clone.eventSupport = null;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        StandardTable standardTable = this;
        synchronized (standardTable) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    @Override
    public void visit(JRVisitor visitor) {
        if (ElementsVisitorUtils.visitDeepElements(visitor)) {
            ColumnElementsVisitor columnElementsVisitor = new ColumnElementsVisitor(visitor);
            for (BaseColumn column : this.columns) {
                column.visitColumn(columnElementsVisitor);
            }
        }
    }
}

