/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.excel;

import java.io.IOException;
import java.util.Map;
import net.sf.jasperreports.data.excel.ExcelDataAdapter;
import net.sf.jasperreports.data.excel.ExcelFormatEnum;
import net.sf.jasperreports.data.xls.AbstractXlsDataAdapterService;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.AbstractXlsDataSource;
import net.sf.jasperreports.engine.data.ExcelDataSource;

public class ExcelDataAdapterService
extends AbstractXlsDataAdapterService {
    public ExcelDataAdapterService(JasperReportsContext jasperReportsContext, ExcelDataAdapter excelDataAdapter) {
        super(jasperReportsContext, excelDataAdapter);
    }

    public ExcelDataAdapter getExcelDataAdapter() {
        return (ExcelDataAdapter)this.getDataAdapter();
    }

    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        super.contributeParameters(parameters);
        ExcelDataAdapter xlsDataAdapter = this.getExcelDataAdapter();
        if (xlsDataAdapter != null) {
            ExcelFormatEnum format = xlsDataAdapter.getFormat();
            if (xlsDataAdapter.isQueryExecuterMode() && format != null) {
                parameters.put("net.sf.jasperreports.xls.format", format);
            }
        }
    }

    @Override
    protected AbstractXlsDataSource getXlsDataSource() throws JRException {
        ExcelDataAdapter excelDataAdapter = this.getExcelDataAdapter();
        ExcelDataSource dataSource = null;
        try {
            dataSource = new ExcelDataSource(this.dataStream, excelDataAdapter.getFormat());
        }
        catch (IOException e2) {
            throw new JRException(e2);
        }
        return dataSource;
    }
}

