/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JRRuntimeException;

public class ListOfArrayDataSource
implements JRRewindableDataSource {
    public static final String EXCEPTION_MESSAGE_KEY_FIELD_NOT_FOUND = "data.array.list.field.not.found";
    private List<Object[]> records = new ArrayList<Object[]>();
    private ListIterator<Object[]> iterator;
    protected Object[] currentRecord;
    private Map<String, Integer> columnNamesMap = new HashMap<String, Integer>();

    public ListOfArrayDataSource(List<Object[]> records, String[] columnNames) {
        this.records = records;
        if (columnNames != null) {
            for (int i2 = 0; i2 < columnNames.length; ++i2) {
                this.columnNamesMap.put(columnNames[i2], i2);
            }
        }
        this.iterator = records.listIterator();
    }

    @Override
    public boolean next() {
        boolean hasNext = false;
        if (this.iterator != null && (hasNext = this.iterator.hasNext())) {
            this.currentRecord = this.iterator.next();
        }
        return hasNext;
    }

    @Override
    public Object getFieldValue(JRField jrField) {
        Integer fieldIndex = this.columnNamesMap.get(jrField.getName());
        if (fieldIndex == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_FIELD_NOT_FOUND, new Object[]{jrField.getName()});
        }
        return this.currentRecord[fieldIndex];
    }

    @Override
    public void moveFirst() {
        this.iterator = this.records.listIterator();
    }

    public int size() {
        return this.records.size();
    }
}

