/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRAbstractMultiClassCompiler;

public class JRJavacCompiler
extends JRAbstractMultiClassCompiler {
    public JRJavacCompiler(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    public JRJavacCompiler() {
        this(DefaultJasperReportsContext.getInstance());
    }

    @Override
    public String compileClasses(File[] sourceFiles, String classpath) throws JRException {
        String[] source = new String[sourceFiles.length + 3];
        source[0] = "javac";
        source[1] = "-classpath";
        source[2] = classpath;
        for (int i2 = 0; i2 < sourceFiles.length; ++i2) {
            source[i2 + 3] = sourceFiles[i2].getPath();
        }
        try {
            Process compile = Runtime.getRuntime().exec(source);
            InputStream errFile = compile.getErrorStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int count = 0;
            do {
                if ((count = errFile.read(buffer)) <= 0) continue;
                baos.write(buffer, 0, count);
            } while (count >= 0);
            if (baos.toString().indexOf("error") != -1) {
                return baos.toString();
            }
            return null;
        }
        catch (Exception e2) {
            StringBuffer files = new StringBuffer();
            for (int i3 = 0; i3 < sourceFiles.length; ++i3) {
                files.append(sourceFiles[i3].getPath());
                files.append(' ');
            }
            throw new JRException("compilers.java.source.compile.error", new Object[]{files}, e2);
        }
    }
}

