/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import java.util.List;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxParagraphHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxRunHelper;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterInputItem;

public class DocxStyleHelper
extends BaseHelper {
    private DocxParagraphHelper paragraphHelper;
    private DocxRunHelper runHelper;

    public DocxStyleHelper(JasperReportsContext jasperReportsContext, Writer writer, String exporterKey) {
        super(jasperReportsContext, writer);
        this.paragraphHelper = new DocxParagraphHelper(jasperReportsContext, writer, false);
        this.runHelper = new DocxRunHelper(jasperReportsContext, writer, exporterKey);
    }

    public void export(ExporterInput exporterInput) {
        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.write("<w:styles\n");
        this.write(" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\"\n");
        this.write(" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\">\n");
        this.write(" <w:docDefaults>\n");
        this.write("  <w:rPrDefault>\n");
        this.write("   <w:rPr>\n");
        this.write("    <w:rFonts w:ascii=\"Times New Roman\" w:eastAsia=\"Times New Roman\" w:hAnsi=\"Times New Roman\" w:cs=\"Times New Roman\"/>\n");
        this.write("   </w:rPr>\n");
        this.write("  </w:rPrDefault>\n");
        this.write("  <w:pPrDefault>\n");
        this.write("  <w:pPr>\n");
        this.write("  <w:spacing w:line=\"240\"/>\n");
        this.write("  </w:pPr>\n");
        this.write("  </w:pPrDefault>\n");
        this.write(" </w:docDefaults>\n");
        List<ExporterInputItem> items = exporterInput.getItems();
        for (int reportIndex = 0; reportIndex < items.size(); ++reportIndex) {
            JRStyle[] styles;
            ExporterInputItem item = items.get(reportIndex);
            JasperPrint jasperPrint = item.getJasperPrint();
            String localeCode = jasperPrint.getLocaleCode();
            if (reportIndex == 0) {
                JRDesignStyle style = new JRDesignStyle();
                style.setName("EMPTY_CELL_STYLE");
                style.setParentStyle(jasperPrint.getDefaultStyle());
                style.setFontSize(Float.valueOf(0.0f));
                this.exportHeader(style);
                this.paragraphHelper.exportProps(style);
                this.runHelper.exportProps(style, localeCode == null ? null : JRDataUtils.getLocale(localeCode));
                this.exportFooter();
            }
            if ((styles = jasperPrint.getStyles()) == null) continue;
            for (int i2 = 0; i2 < styles.length; ++i2) {
                JRStyle style = styles[i2];
                this.exportHeader(style);
                this.paragraphHelper.exportProps(style);
                this.runHelper.exportProps(style, localeCode == null ? null : JRDataUtils.getLocale(localeCode));
                this.exportFooter();
            }
        }
        this.write("</w:styles>\n");
    }

    private void exportHeader(JRStyle style) {
        String styleNameReference;
        this.write(" <w:style w:type=\"paragraph\" w:styleId=\"" + style.getName() + "\"");
        if (style.isDefault()) {
            this.write(" w:default=\"1\"");
        }
        this.write(">\n");
        this.write("  <w:name w:val=\"" + style.getName() + "\" />\n");
        this.write("  <w:qFormat />\n");
        String string = styleNameReference = style.getStyle() == null ? null : style.getStyle().getName();
        if (styleNameReference != null) {
            this.write("  <w:basedOn w:val=\"" + styleNameReference + "\" />\n");
        }
    }

    private void exportFooter() {
        this.write(" </w:style>\n");
    }
}

