/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.fill.BaseReportFiller;
import net.sf.jasperreports.engine.fill.DataSourceComparator;
import net.sf.jasperreports.engine.fill.DatasetSortInfo;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.SortFillDatasetRun;
import net.sf.jasperreports.engine.fill.SortedDataSource;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;

public class DatasetSortUtil {
    public static final String EXCEPTION_MESSAGE_KEY_SORT_FIELD_NOT_FOUND = "fill.dataset.sort.field.not.found";
    public static final String EXCEPTION_MESSAGE_KEY_SORT_VARIABLE_NOT_FOUND = "fill.dataset.sort.variable.not.found";

    public static JRSortField[] getAllSortFields(JRFillDataset dataset) {
        List dynamicSortFields;
        ArrayList<JRSortField> allSortFields = new ArrayList<JRSortField>();
        JRSortField[] staticSortFields = dataset.getSortFields();
        if (staticSortFields != null) {
            allSortFields.addAll(Arrays.asList(staticSortFields));
        }
        if ((dynamicSortFields = (List)dataset.getParameterValue("SORT_FIELDS", true)) != null) {
            allSortFields.addAll(dynamicSortFields);
        }
        return allSortFields.toArray(new JRSortField[allSortFields.size()]);
    }

    public static boolean needSorting(JRFillDataset dataset) {
        JRSortField[] staticSortFields = dataset.getSortFields();
        List dynamicSortFields = (List)dataset.getParameterValue("SORT_FIELDS", true);
        return staticSortFields != null && staticSortFields.length > 0 || dynamicSortFields != null && dynamicSortFields.size() > 0;
    }

    public static SortedDataSource getSortedDataSource(BaseReportFiller filler, JRFillDataset dataset, Locale locale) throws JRException {
        DatasetSortInfo sortInfo = DatasetSortUtil.createSortInfo(dataset);
        SortFillDatasetRun sortDatasetRun = new SortFillDatasetRun(filler, dataset, sortInfo);
        List<SortedDataSource.SortRecord> records = sortDatasetRun.sort();
        int recordCount = records.size();
        Integer[] indexes = new Integer[recordCount];
        for (int i2 = 0; i2 < recordCount; ++i2) {
            indexes[i2] = i2;
        }
        Arrays.sort(indexes, new DataSourceComparator(sortInfo, locale, records));
        return new SortedDataSource(sortInfo, records, indexes);
    }

    private static DatasetSortInfo createSortInfo(JRFillDataset dataset) throws JRException {
        JRSortField[] sortFields;
        DatasetSortInfo sortInfo = new DatasetSortInfo();
        HashMap<String, JRField> fieldsMap = new HashMap<String, JRField>();
        HashMap<String, Integer> fieldIndexMap = new HashMap<String, Integer>();
        JRField[] fields = dataset.getFields();
        if (fields != null) {
            for (int i2 = 0; i2 < fields.length; ++i2) {
                JRField field = fields[i2];
                fieldsMap.put(field.getName(), field);
                fieldIndexMap.put(field.getName(), i2);
                sortInfo.addRecordField(field.getName());
            }
        }
        HashMap<String, JRVariable> variablesMap = new HashMap<String, JRVariable>();
        JRVariable[] variables = dataset.getVariables();
        if (variables != null) {
            for (int i3 = 0; i3 < variables.length; ++i3) {
                variablesMap.put(variables[i3].getName(), variables[i3]);
            }
        }
        if ((sortFields = DatasetSortUtil.getAllSortFields(dataset)) != null) {
            for (int i4 = 0; i4 < sortFields.length; ++i4) {
                boolean collatorFlag;
                int recordIndex;
                JRSortField sortField = sortFields[i4];
                String sortFieldName = sortField.getName();
                if (sortField.getType() == SortFieldTypeEnum.VARIABLE) {
                    JRVariable variable = (JRVariable)variablesMap.get(sortFieldName);
                    if (variable == null) {
                        throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_SORT_VARIABLE_NOT_FOUND, new Object[]{sortFieldName});
                    }
                    recordIndex = sortInfo.addRecordVariable(variable.getName());
                    collatorFlag = String.class.getName().equals(variable.getValueClassName());
                } else {
                    JRField field = (JRField)fieldsMap.get(sortFieldName);
                    if (field == null) {
                        throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_SORT_FIELD_NOT_FOUND, new Object[]{sortFieldName});
                    }
                    recordIndex = (Integer)fieldIndexMap.get(sortField.getName());
                    collatorFlag = String.class.getName().equals(field.getValueClassName());
                }
                sortInfo.addSortField(sortField, recordIndex, collatorFlag);
            }
        }
        return sortInfo;
    }
}

