/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TimeZone;
import net.sf.jasperreports.charts.ChartContext;
import net.sf.jasperreports.charts.ChartThemeBundle;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRChartAxis;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRItemLabel;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRPie3DPlot;
import net.sf.jasperreports.charts.JRPiePlot;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.type.AxisPositionEnum;
import net.sf.jasperreports.charts.type.EdgeEnum;
import net.sf.jasperreports.charts.type.MeterShapeEnum;
import net.sf.jasperreports.charts.type.PlotOrientationEnum;
import net.sf.jasperreports.charts.type.ScaleTypeEnum;
import net.sf.jasperreports.charts.util.ChartUtil;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.type.ModeEnum;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.MeterInterval;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ThermometerPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.plot.dial.DialBackground;
import org.jfree.chart.plot.dial.DialCap;
import org.jfree.chart.plot.dial.DialFrame;
import org.jfree.chart.plot.dial.DialLayer;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.plot.dial.DialPointer;
import org.jfree.chart.plot.dial.DialScale;
import org.jfree.chart.plot.dial.DialTextAnnotation;
import org.jfree.chart.plot.dial.DialValueIndicator;
import org.jfree.chart.plot.dial.StandardDialFrame;
import org.jfree.chart.plot.dial.StandardDialRange;
import org.jfree.chart.plot.dial.StandardDialScale;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.GanttRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer3D;
import org.jfree.chart.renderer.xy.CandlestickRenderer;
import org.jfree.chart.renderer.xy.HighLowRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYBubbleRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.gantt.GanttCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.DefaultHighLowDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

public class DefaultChartTheme
implements net.sf.jasperreports.charts.ChartTheme {
    public static final String EXCEPTION_MESSAGE_KEY_UNSUPPORTED_CHART_TYPE = "fill.chart.theme.unsupported.chart.type";
    public static final String PROPERTY_DIAL_VALUE_DISPLAY_VISIBLE = "net.sf.jasperreports.chart.dial.value.display.visible";
    public static final String PROPERTY_DIAL_LABEL = "net.sf.jasperreports.chart.dial.label";
    public static final String PROPERTY_RANGE_AXIS_TICK_COUNT = "net.sf.jasperreports.chart.range.axis.tick.count";
    public static final String PROPERTY_RANGE_AXIS_TICK_INTERVAL = "net.sf.jasperreports.chart.range.axis.tick.interval";
    public static final String PROPERTY_RANGE_AXIS_INTEGER_UNIT = "net.sf.jasperreports.chart.range.axis.integer.unit";
    public static final String PROPERTY_DOMAIN_AXIS_TICK_COUNT = "net.sf.jasperreports.chart.domain.axis.tick.count";
    public static final String PROPERTY_DOMAIN_AXIS_TICK_INTERVAL = "net.sf.jasperreports.chart.domain.axis.tick.interval";
    public static final String PROPERTY_DOMAIN_AXIS_INTEGER_UNIT = "net.sf.jasperreports.chart.domain.axis.integer.unit";
    protected static final Color TRANSPARENT_PAINT = new Color(0, 0, 0, 0);
    private ChartContext chartContext;
    private FontUtil fontUtil;
    public static final ChartThemeBundle BUNDLE = new ChartThemeBundle(){
        private static final String NAME = "default";

        @Override
        public String[] getChartThemeNames() {
            return new String[]{NAME};
        }

        @Override
        public net.sf.jasperreports.charts.ChartTheme getChartTheme(String themeName) {
            if (NAME.equals(themeName)) {
                return new DefaultChartTheme();
            }
            return null;
        }
    };

    protected JRChart getChart() {
        return this.chartContext.getChart();
    }

    protected JRChartPlot getPlot() {
        return this.getChart().getPlot();
    }

    protected Dataset getDataset() {
        return this.chartContext.getDataset();
    }

    protected Object getLabelGenerator() {
        return this.chartContext.getLabelGenerator();
    }

    protected Locale getLocale() {
        return this.chartContext.getLocale();
    }

    protected JRFont getFont(JRFont font) {
        if (font == null) {
            return new JRBaseFont(this.getChart());
        }
        return font;
    }

    protected final String evaluateTextExpression(JRExpression expression) throws JRException {
        return this.chartContext.evaluateTextExpression(expression);
    }

    protected final Object evaluateExpression(JRExpression expression) throws JRException {
        return this.chartContext.evaluateExpression(expression);
    }

    @Override
    public JFreeChart createChart(ChartContext chartContext) throws JRException {
        this.chartContext = chartContext;
        this.fontUtil = FontUtil.getInstance(chartContext.getJasperReportsContext());
        JFreeChart jfreeChart = null;
        switch (this.getChart().getChartType()) {
            case 1: {
                jfreeChart = this.createAreaChart();
                break;
            }
            case 3: {
                jfreeChart = this.createBarChart();
                break;
            }
            case 2: {
                jfreeChart = this.createBar3DChart();
                break;
            }
            case 4: {
                jfreeChart = this.createBubbleChart();
                break;
            }
            case 5: {
                jfreeChart = this.createCandlestickChart();
                break;
            }
            case 6: {
                jfreeChart = this.createHighLowChart();
                break;
            }
            case 7: {
                jfreeChart = this.createLineChart();
                break;
            }
            case 17: {
                if (MeterShapeEnum.DIAL == ((JRMeterPlot)this.getPlot()).getShapeValue()) {
                    jfreeChart = this.createDialChart();
                    break;
                }
                jfreeChart = this.createMeterChart();
                break;
            }
            case 19: {
                break;
            }
            case 9: {
                jfreeChart = this.createPieChart();
                break;
            }
            case 8: {
                jfreeChart = this.createPie3DChart();
                break;
            }
            case 10: {
                jfreeChart = this.createScatterChart();
                break;
            }
            case 12: {
                jfreeChart = this.createStackedBarChart();
                break;
            }
            case 11: {
                jfreeChart = this.createStackedBar3DChart();
                break;
            }
            case 18: {
                jfreeChart = this.createThermometerChart();
                break;
            }
            case 16: {
                jfreeChart = this.createTimeSeriesChart();
                break;
            }
            case 13: {
                jfreeChart = this.createXyAreaChart();
                break;
            }
            case 14: {
                jfreeChart = this.createXYBarChart();
                break;
            }
            case 15: {
                jfreeChart = this.createXyLineChart();
                break;
            }
            case 20: {
                jfreeChart = this.createStackedAreaChart();
                break;
            }
            case 21: {
                jfreeChart = this.createGanttChart();
                break;
            }
            default: {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNSUPPORTED_CHART_TYPE, new Object[]{this.getChart().getChartType()});
            }
        }
        return jfreeChart;
    }

    protected void configureChart(JFreeChart jfreeChart) throws JRException {
        LegendTitle legend;
        String subtitleText;
        if (this.getChart().getModeValue() == ModeEnum.OPAQUE) {
            jfreeChart.setBackgroundPaint((Paint)this.getChart().getBackcolor());
        } else {
            jfreeChart.setBackgroundPaint((Paint)TRANSPARENT_PAINT);
        }
        RectangleEdge titleEdge = DefaultChartTheme.getEdge(this.getChart().getTitlePositionValue(), RectangleEdge.TOP);
        if (jfreeChart.getTitle() != null) {
            TextTitle title = jfreeChart.getTitle();
            title.setPaint((Paint)this.getChart().getTitleColor());
            title.setFont(this.fontUtil.getAwtFont(this.getFont(this.getChart().getTitleFont()), this.getLocale()));
            title.setPosition(titleEdge);
        }
        if ((subtitleText = this.evaluateTextExpression(this.getChart().getSubtitleExpression())) != null) {
            TextTitle subtitle = new TextTitle(subtitleText);
            subtitle.setPaint((Paint)this.getChart().getSubtitleColor());
            subtitle.setFont(this.fontUtil.getAwtFont(this.getFont(this.getChart().getSubtitleFont()), this.getLocale()));
            subtitle.setPosition(titleEdge);
            jfreeChart.addSubtitle((Title)subtitle);
        }
        if ((legend = jfreeChart.getLegend()) != null) {
            legend.setItemPaint((Paint)this.getChart().getLegendColor());
            if (this.getChart().getOwnLegendBackgroundColor() == null) {
                legend.setBackgroundPaint((Paint)TRANSPARENT_PAINT);
            } else {
                legend.setBackgroundPaint((Paint)this.getChart().getLegendBackgroundColor());
            }
            legend.setItemFont(this.fontUtil.getAwtFont(this.getFont(this.getChart().getLegendFont()), this.getLocale()));
            legend.setPosition(DefaultChartTheme.getEdge(this.getChart().getLegendPositionValue(), RectangleEdge.BOTTOM));
        }
        this.configurePlot(jfreeChart.getPlot());
    }

    protected void configurePlot(Plot plot) {
        SortedSet<JRChartPlot.JRSeriesColor> seriesColors;
        plot.setOutlinePaint((Paint)TRANSPARENT_PAINT);
        if (this.getPlot().getOwnBackcolor() == null) {
            plot.setBackgroundPaint((Paint)TRANSPARENT_PAINT);
        } else {
            plot.setBackgroundPaint((Paint)this.getPlot().getBackcolor());
        }
        float backgroundAlpha = this.getPlot().getBackgroundAlphaFloat() == null ? 1.0f : this.getPlot().getBackgroundAlphaFloat().floatValue();
        float foregroundAlpha = this.getPlot().getForegroundAlphaFloat() == null ? 1.0f : this.getPlot().getForegroundAlphaFloat().floatValue();
        plot.setBackgroundAlpha(backgroundAlpha);
        plot.setForegroundAlpha(foregroundAlpha);
        if (plot instanceof CategoryPlot) {
            CategoryAxis axis = ((CategoryPlot)plot).getDomainAxis();
            double labelRotation = this.getLabelRotation();
            if (labelRotation == 90.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_90);
            } else if (labelRotation == -90.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            } else if (labelRotation < 0.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)(-labelRotation / 180.0 * Math.PI)));
            } else if (labelRotation > 0.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.createDownRotationLabelPositions((double)(labelRotation / 180.0 * Math.PI)));
            }
        }
        if ((seriesColors = this.getPlot().getSeriesColors()) != null && seriesColors.size() > 0) {
            if (seriesColors.size() == 1) {
                Paint[] colors = new Paint[DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE.length + 1];
                colors[0] = seriesColors.first().getColor();
                System.arraycopy(DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE, 0, colors, 1, DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE.length);
                plot.setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier(colors, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
            } else if (seriesColors.size() > 1) {
                Paint[] colors = new Color[seriesColors.size()];
                JRChartPlot.JRSeriesColor[] colorSequence = new JRChartPlot.JRSeriesColor[seriesColors.size()];
                seriesColors.toArray(colorSequence);
                for (int i2 = 0; i2 < colorSequence.length; ++i2) {
                    colors[i2] = colorSequence[i2].getColor();
                }
                plot.setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier(colors, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
            }
        }
    }

    protected void configureAxis(Axis axis, JRFont labelFont, Color labelColor, JRFont tickLabelFont, Color tickLabelColor, String tickLabelMask, Boolean verticalTickLabels, Color lineColor, boolean isRangeAxis, Comparable<?> axisMinValue, Comparable<?> axisMaxValue) {
        axis.setLabelFont(this.fontUtil.getAwtFont(this.getFont(labelFont), this.getLocale()));
        axis.setTickLabelFont(this.fontUtil.getAwtFont(this.getFont(tickLabelFont), this.getLocale()));
        if (labelColor != null) {
            axis.setLabelPaint((Paint)labelColor);
        }
        if (tickLabelColor != null) {
            axis.setTickLabelPaint((Paint)tickLabelColor);
        }
        if (lineColor != null) {
            axis.setAxisLinePaint((Paint)lineColor);
            axis.setTickMarkPaint((Paint)lineColor);
        }
        TimeZone timeZone = this.chartContext.getTimeZone();
        if (axis instanceof DateAxis && timeZone != null) {
            ((DateAxis)axis).setTimeZone(timeZone);
        }
        if (tickLabelMask != null) {
            if (axis instanceof NumberAxis) {
                NumberFormat fmt = NumberFormat.getInstance(this.getLocale());
                if (fmt instanceof DecimalFormat) {
                    ((DecimalFormat)fmt).applyPattern(tickLabelMask);
                }
                ((NumberAxis)axis).setNumberFormatOverride(fmt);
            } else if (axis instanceof DateAxis) {
                DateFormat fmt = tickLabelMask.equals("SHORT") || tickLabelMask.equals("DateFormat.SHORT") ? DateFormat.getDateInstance(3, this.getLocale()) : (tickLabelMask.equals("MEDIUM") || tickLabelMask.equals("DateFormat.MEDIUM") ? DateFormat.getDateInstance(2, this.getLocale()) : (tickLabelMask.equals("LONG") || tickLabelMask.equals("DateFormat.LONG") ? DateFormat.getDateInstance(1, this.getLocale()) : (tickLabelMask.equals("FULL") || tickLabelMask.equals("DateFormat.FULL") ? DateFormat.getDateInstance(0, this.getLocale()) : new SimpleDateFormat(tickLabelMask, this.getLocale()))));
                if (timeZone != null) {
                    fmt.setTimeZone(timeZone);
                }
                ((DateAxis)axis).setDateFormatOverride(fmt);
            }
        }
        if (verticalTickLabels != null && axis instanceof ValueAxis) {
            ((ValueAxis)axis).setVerticalTickLabels(verticalTickLabels.booleanValue());
        }
        this.setAxisBounds(axis, isRangeAxis, axisMinValue, axisMaxValue);
    }

    protected JFreeChart createAreaChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createAreaChart((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)this.evaluateTextExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression()), (String)this.evaluateTextExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression()), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientationValue().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        JRAreaPlot areaPlot = (JRAreaPlot)this.getPlot();
        this.configureAxis((Axis)((CategoryPlot)jfreeChart.getPlot()).getDomainAxis(), areaPlot.getCategoryAxisLabelFont(), areaPlot.getCategoryAxisLabelColor(), areaPlot.getCategoryAxisTickLabelFont(), areaPlot.getCategoryAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getCategoryAxisVerticalTickLabels(), areaPlot.getCategoryAxisLineColor(), false, (Comparable)this.evaluateExpression(areaPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(areaPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)((CategoryPlot)jfreeChart.getPlot()).getRangeAxis(), areaPlot.getValueAxisLabelFont(), areaPlot.getValueAxisLabelColor(), areaPlot.getValueAxisTickLabelFont(), areaPlot.getValueAxisTickLabelColor(), areaPlot.getValueAxisTickLabelMask(), areaPlot.getValueAxisVerticalTickLabels(), areaPlot.getValueAxisLineColor(), true, (Comparable)this.evaluateExpression(areaPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(areaPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createBar3DChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createBarChart3D((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)this.evaluateTextExpression(((JRBar3DPlot)this.getPlot()).getCategoryAxisLabelExpression()), (String)this.evaluateTextExpression(((JRBar3DPlot)this.getPlot()).getValueAxisLabelExpression()), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientationValue().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRBar3DPlot bar3DPlot = (JRBar3DPlot)this.getPlot();
        BarRenderer3D barRenderer3D = new BarRenderer3D(bar3DPlot.getXOffsetDouble() == null ? 12.0 : bar3DPlot.getXOffsetDouble(), bar3DPlot.getYOffsetDouble() == null ? 8.0 : bar3DPlot.getYOffsetDouble());
        boolean isShowLabels = bar3DPlot.getShowLabels() == null ? false : bar3DPlot.getShowLabels();
        barRenderer3D.setBaseItemLabelsVisible(isShowLabels);
        if (isShowLabels) {
            JRItemLabel itemLabel = bar3DPlot.getItemLabel();
            barRenderer3D.setBaseItemLabelFont(this.fontUtil.getAwtFont(this.getFont(itemLabel == null ? null : itemLabel.getFont()), this.getLocale()));
            if (itemLabel != null) {
                if (itemLabel.getColor() != null) {
                    barRenderer3D.setBaseItemLabelPaint((Paint)itemLabel.getColor());
                } else {
                    barRenderer3D.setBaseItemLabelPaint((Paint)this.getChart().getForecolor());
                }
                barRenderer3D.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
            } else {
                barRenderer3D.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
                barRenderer3D.setBaseItemLabelPaint((Paint)this.getChart().getForecolor());
            }
        }
        categoryPlot.setRenderer((CategoryItemRenderer)barRenderer3D);
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), bar3DPlot.getCategoryAxisLabelFont(), bar3DPlot.getCategoryAxisLabelColor(), bar3DPlot.getCategoryAxisTickLabelFont(), bar3DPlot.getCategoryAxisTickLabelColor(), bar3DPlot.getCategoryAxisTickLabelMask(), bar3DPlot.getCategoryAxisVerticalTickLabels(), bar3DPlot.getCategoryAxisLineColor(), false, (Comparable)this.evaluateExpression(bar3DPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(bar3DPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), bar3DPlot.getValueAxisLabelFont(), bar3DPlot.getValueAxisLabelColor(), bar3DPlot.getValueAxisTickLabelFont(), bar3DPlot.getValueAxisTickLabelColor(), bar3DPlot.getValueAxisTickLabelMask(), bar3DPlot.getValueAxisVerticalTickLabels(), bar3DPlot.getValueAxisLineColor(), true, (Comparable)this.evaluateExpression(bar3DPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(bar3DPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createBarChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createBarChart((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)this.evaluateTextExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression()), (String)this.evaluateTextExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression()), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientationValue().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRBarPlot barPlot = (JRBarPlot)this.getPlot();
        boolean isShowTickMarks = barPlot.getShowTickMarks() == null ? true : barPlot.getShowTickMarks();
        boolean isShowTickLabels = barPlot.getShowTickLabels() == null ? true : barPlot.getShowTickLabels();
        categoryPlot.getDomainAxis().setTickMarksVisible(isShowTickMarks);
        categoryPlot.getDomainAxis().setTickLabelsVisible(isShowTickLabels);
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getCategoryAxisVerticalTickLabels(), barPlot.getCategoryAxisLineColor(), false, (Comparable)this.evaluateExpression(barPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(barPlot.getDomainAxisMaxValueExpression()));
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(isShowTickMarks);
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(isShowTickLabels);
        Comparable rangeAxisMaxValue = (Comparable)this.evaluateExpression(barPlot.getRangeAxisMaxValueExpression());
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getValueAxisVerticalTickLabels(), barPlot.getValueAxisLineColor(), true, (Comparable)this.evaluateExpression(barPlot.getRangeAxisMinValueExpression()), rangeAxisMaxValue);
        BarRenderer categoryRenderer = (BarRenderer)categoryPlot.getRenderer();
        boolean isShowLabels = barPlot.getShowLabels() == null ? false : barPlot.getShowLabels();
        categoryRenderer.setBaseItemLabelsVisible(isShowLabels);
        if (isShowLabels) {
            JRItemLabel itemLabel;
            ValueAxis axis;
            if (rangeAxisMaxValue == null && (axis = categoryPlot.getRangeAxis()) instanceof ValueAxis && !(axis instanceof DateAxis)) {
                float rangeAxisMaxRatio = 1.0f;
                rangeAxisMaxRatio = barPlot.getOrientationValue() == PlotOrientationEnum.HORIZONTAL ? JRPropertiesUtil.getInstance(this.chartContext.getJasperReportsContext()).getFloatProperty(this.getChart(), "net.sf.jasperreports.chart.bar.horizontal.range.max.value.ratio", 1.25f) : JRPropertiesUtil.getInstance(this.chartContext.getJasperReportsContext()).getFloatProperty(this.getChart(), "net.sf.jasperreports.chart.bar.vertical.range.max.value.ratio", 1.1f);
                axis.setUpperBound(axis.getUpperBound() * (double)rangeAxisMaxRatio);
            }
            categoryRenderer.setBaseItemLabelFont(this.fontUtil.getAwtFont(this.getFont((itemLabel = barPlot.getItemLabel()) == null ? null : itemLabel.getFont()), this.getLocale()));
            if (itemLabel != null) {
                if (itemLabel.getColor() != null) {
                    categoryRenderer.setBaseItemLabelPaint((Paint)itemLabel.getColor());
                } else {
                    categoryRenderer.setBaseItemLabelPaint((Paint)this.getChart().getForecolor());
                }
                categoryRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
            } else {
                categoryRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
                categoryRenderer.setBaseItemLabelPaint((Paint)this.getChart().getForecolor());
            }
        }
        categoryRenderer.setShadowVisible(false);
        return jfreeChart;
    }

    protected JFreeChart createBubbleChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createBubbleChart((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)this.evaluateTextExpression(((JRBubblePlot)this.getPlot()).getXAxisLabelExpression()), (String)this.evaluateTextExpression(((JRBubblePlot)this.getPlot()).getYAxisLabelExpression()), (XYZDataset)((XYZDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientationValue().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        JRBubblePlot bubblePlot = (JRBubblePlot)this.getPlot();
        int scaleType = bubblePlot.getScaleTypeValue() == null ? ScaleTypeEnum.ON_RANGE_AXIS.getValue() : bubblePlot.getScaleTypeValue().getValue();
        XYBubbleRenderer bubbleRenderer = new XYBubbleRenderer(scaleType);
        xyPlot.setRenderer((XYItemRenderer)bubbleRenderer);
        this.configureAxis((Axis)xyPlot.getDomainAxis(), bubblePlot.getXAxisLabelFont(), bubblePlot.getXAxisLabelColor(), bubblePlot.getXAxisTickLabelFont(), bubblePlot.getXAxisTickLabelColor(), bubblePlot.getXAxisTickLabelMask(), bubblePlot.getXAxisVerticalTickLabels(), bubblePlot.getXAxisLineColor(), false, (Comparable)this.evaluateExpression(bubblePlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(bubblePlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)xyPlot.getRangeAxis(), bubblePlot.getYAxisLabelFont(), bubblePlot.getYAxisLabelColor(), bubblePlot.getYAxisTickLabelFont(), bubblePlot.getYAxisTickLabelColor(), bubblePlot.getYAxisTickLabelMask(), bubblePlot.getYAxisVerticalTickLabels(), bubblePlot.getYAxisLineColor(), true, (Comparable)this.evaluateExpression(bubblePlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(bubblePlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createCandlestickChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createCandlestickChart((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)this.evaluateTextExpression(((JRCandlestickPlot)this.getPlot()).getTimeAxisLabelExpression()), (String)this.evaluateTextExpression(((JRCandlestickPlot)this.getPlot()).getValueAxisLabelExpression()), (OHLCDataset)((DefaultHighLowDataset)this.getDataset()), (boolean)this.isShowLegend());
        this.configureChart(jfreeChart);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        JRCandlestickPlot candlestickPlot = (JRCandlestickPlot)this.getPlot();
        CandlestickRenderer candlestickRenderer = (CandlestickRenderer)xyPlot.getRenderer();
        boolean isShowVolume = candlestickPlot.getShowVolume() == null ? true : candlestickPlot.getShowVolume();
        candlestickRenderer.setDrawVolume(isShowVolume);
        this.configureAxis((Axis)xyPlot.getDomainAxis(), candlestickPlot.getTimeAxisLabelFont(), candlestickPlot.getTimeAxisLabelColor(), candlestickPlot.getTimeAxisTickLabelFont(), candlestickPlot.getTimeAxisTickLabelColor(), candlestickPlot.getTimeAxisTickLabelMask(), candlestickPlot.getTimeAxisVerticalTickLabels(), candlestickPlot.getTimeAxisLineColor(), false, (Comparable)this.evaluateExpression(candlestickPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(candlestickPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)xyPlot.getRangeAxis(), candlestickPlot.getValueAxisLabelFont(), candlestickPlot.getValueAxisLabelColor(), candlestickPlot.getValueAxisTickLabelFont(), candlestickPlot.getValueAxisTickLabelColor(), candlestickPlot.getValueAxisTickLabelMask(), candlestickPlot.getValueAxisVerticalTickLabels(), candlestickPlot.getValueAxisLineColor(), true, (Comparable)this.evaluateExpression(candlestickPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(candlestickPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createHighLowChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createHighLowChart((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)this.evaluateTextExpression(((JRHighLowPlot)this.getPlot()).getTimeAxisLabelExpression()), (String)this.evaluateTextExpression(((JRHighLowPlot)this.getPlot()).getValueAxisLabelExpression()), (OHLCDataset)((DefaultHighLowDataset)this.getDataset()), (boolean)this.isShowLegend());
        this.configureChart(jfreeChart);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        JRHighLowPlot highLowPlot = (JRHighLowPlot)this.getPlot();
        HighLowRenderer hlRenderer = (HighLowRenderer)xyPlot.getRenderer();
        boolean isShowOpenTicks = highLowPlot.getShowOpenTicks() == null ? false : highLowPlot.getShowOpenTicks();
        boolean isShowCloseTicks = highLowPlot.getShowCloseTicks() == null ? false : highLowPlot.getShowCloseTicks();
        hlRenderer.setDrawOpenTicks(isShowOpenTicks);
        hlRenderer.setDrawCloseTicks(isShowCloseTicks);
        this.configureAxis((Axis)xyPlot.getDomainAxis(), highLowPlot.getTimeAxisLabelFont(), highLowPlot.getTimeAxisLabelColor(), highLowPlot.getTimeAxisTickLabelFont(), highLowPlot.getTimeAxisTickLabelColor(), highLowPlot.getTimeAxisTickLabelMask(), highLowPlot.getTimeAxisVerticalTickLabels(), highLowPlot.getTimeAxisLineColor(), false, (Comparable)this.evaluateExpression(highLowPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(highLowPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)xyPlot.getRangeAxis(), highLowPlot.getValueAxisLabelFont(), highLowPlot.getValueAxisLabelColor(), highLowPlot.getValueAxisTickLabelFont(), highLowPlot.getValueAxisTickLabelColor(), highLowPlot.getValueAxisTickLabelMask(), highLowPlot.getValueAxisVerticalTickLabels(), highLowPlot.getValueAxisLineColor(), true, (Comparable)this.evaluateExpression(highLowPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(highLowPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createLineChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createLineChart((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)this.evaluateTextExpression(((JRLinePlot)this.getPlot()).getCategoryAxisLabelExpression()), (String)this.evaluateTextExpression(((JRLinePlot)this.getPlot()).getValueAxisLabelExpression()), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientationValue().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRLinePlot linePlot = (JRLinePlot)this.getPlot();
        LineAndShapeRenderer lineRenderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
        boolean isShowShapes = linePlot.getShowShapes() == null ? true : linePlot.getShowShapes();
        boolean isShowLines = linePlot.getShowLines() == null ? true : linePlot.getShowLines();
        lineRenderer.setBaseShapesVisible(isShowShapes);
        lineRenderer.setBaseLinesVisible(isShowLines);
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), linePlot.getCategoryAxisLabelFont(), linePlot.getCategoryAxisLabelColor(), linePlot.getCategoryAxisTickLabelFont(), linePlot.getCategoryAxisTickLabelColor(), linePlot.getCategoryAxisTickLabelMask(), linePlot.getCategoryAxisVerticalTickLabels(), linePlot.getCategoryAxisLineColor(), false, (Comparable)this.evaluateExpression(linePlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(linePlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), linePlot.getValueAxisLabelFont(), linePlot.getValueAxisLabelColor(), linePlot.getValueAxisTickLabelFont(), linePlot.getValueAxisTickLabelColor(), linePlot.getValueAxisTickLabelMask(), linePlot.getValueAxisVerticalTickLabels(), linePlot.getValueAxisLineColor(), true, (Comparable)this.evaluateExpression(linePlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(linePlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createPie3DChart() throws JRException {
        boolean isShowLabels;
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createPieChart3D((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (PieDataset)((PieDataset)this.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        PiePlot3D piePlot3D = (PiePlot3D)jfreeChart.getPlot();
        JRPie3DPlot jrPie3DPlot = (JRPie3DPlot)this.getPlot();
        double depthFactor = jrPie3DPlot.getDepthFactorDouble() == null ? 0.2 : jrPie3DPlot.getDepthFactorDouble();
        boolean isCircular = jrPie3DPlot.getCircular() == null ? false : jrPie3DPlot.getCircular();
        piePlot3D.setDepthFactor(depthFactor);
        piePlot3D.setCircular(isCircular);
        boolean bl = isShowLabels = jrPie3DPlot.getShowLabels() == null ? true : jrPie3DPlot.getShowLabels();
        if (isShowLabels) {
            PieSectionLabelGenerator labelGenerator = (PieSectionLabelGenerator)this.getLabelGenerator();
            JRItemLabel itemLabel = jrPie3DPlot.getItemLabel();
            if (labelGenerator != null) {
                piePlot3D.setLabelGenerator(labelGenerator);
            } else if (jrPie3DPlot.getLabelFormat() != null) {
                piePlot3D.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(jrPie3DPlot.getLabelFormat(), NumberFormat.getNumberInstance(this.getLocale()), NumberFormat.getPercentInstance(this.getLocale())));
            }
            piePlot3D.setLabelFont(this.fontUtil.getAwtFont(this.getFont(itemLabel == null ? null : itemLabel.getFont()), this.getLocale()));
            if (itemLabel != null && itemLabel.getColor() != null) {
                piePlot3D.setLabelPaint((Paint)itemLabel.getColor());
            } else {
                piePlot3D.setLabelPaint((Paint)this.getChart().getForecolor());
            }
            if (itemLabel != null && itemLabel.getBackgroundColor() != null) {
                piePlot3D.setLabelBackgroundPaint((Paint)itemLabel.getBackgroundColor());
            } else {
                piePlot3D.setLabelBackgroundPaint((Paint)this.getChart().getBackcolor());
            }
        } else {
            piePlot3D.setLabelGenerator(null);
        }
        if (jrPie3DPlot.getLegendLabelFormat() != null) {
            piePlot3D.setLegendLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(jrPie3DPlot.getLegendLabelFormat(), NumberFormat.getNumberInstance(this.getLocale()), NumberFormat.getPercentInstance(this.getLocale())));
        }
        return jfreeChart;
    }

    protected JFreeChart createPieChart() throws JRException {
        boolean isShowLabels;
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createPieChart((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (PieDataset)((PieDataset)this.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        PiePlot piePlot = (PiePlot)jfreeChart.getPlot();
        JRPiePlot jrPiePlot = (JRPiePlot)this.getPlot();
        boolean isCircular = jrPiePlot.getCircular() == null ? true : jrPiePlot.getCircular();
        piePlot.setCircular(isCircular);
        boolean bl = isShowLabels = jrPiePlot.getShowLabels() == null ? true : jrPiePlot.getShowLabels();
        if (isShowLabels) {
            PieSectionLabelGenerator labelGenerator = (PieSectionLabelGenerator)this.getLabelGenerator();
            JRItemLabel itemLabel = jrPiePlot.getItemLabel();
            if (labelGenerator != null) {
                piePlot.setLabelGenerator(labelGenerator);
            } else if (jrPiePlot.getLabelFormat() != null) {
                piePlot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(jrPiePlot.getLabelFormat(), NumberFormat.getNumberInstance(this.getLocale()), NumberFormat.getPercentInstance(this.getLocale())));
            }
            piePlot.setLabelFont(this.fontUtil.getAwtFont(this.getFont(itemLabel == null ? null : itemLabel.getFont()), this.getLocale()));
            if (itemLabel != null && itemLabel.getColor() != null) {
                piePlot.setLabelPaint((Paint)itemLabel.getColor());
            } else {
                piePlot.setLabelPaint((Paint)this.getChart().getForecolor());
            }
            if (itemLabel != null && itemLabel.getBackgroundColor() != null) {
                piePlot.setLabelBackgroundPaint((Paint)itemLabel.getBackgroundColor());
            } else {
                piePlot.setLabelBackgroundPaint((Paint)this.getChart().getBackcolor());
            }
        } else {
            piePlot.setLabelGenerator(null);
        }
        if (jrPiePlot.getLegendLabelFormat() != null) {
            piePlot.setLegendLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(jrPiePlot.getLegendLabelFormat(), NumberFormat.getNumberInstance(this.getLocale()), NumberFormat.getPercentInstance(this.getLocale())));
        }
        return jfreeChart;
    }

    protected JFreeChart createScatterChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createScatterPlot((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)this.evaluateTextExpression(((JRScatterPlot)this.getPlot()).getXAxisLabelExpression()), (String)this.evaluateTextExpression(((JRScatterPlot)this.getPlot()).getYAxisLabelExpression()), (XYDataset)((XYDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientationValue().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        XYLineAndShapeRenderer plotRenderer = (XYLineAndShapeRenderer)((XYPlot)jfreeChart.getPlot()).getRenderer();
        JRScatterPlot scatterPlot = (JRScatterPlot)this.getPlot();
        boolean isShowLines = scatterPlot.getShowLines() == null ? true : scatterPlot.getShowLines();
        boolean isShowShapes = scatterPlot.getShowShapes() == null ? true : scatterPlot.getShowShapes();
        plotRenderer.setBaseLinesVisible(isShowLines);
        plotRenderer.setBaseShapesVisible(isShowShapes);
        this.configureAxis((Axis)jfreeChart.getXYPlot().getDomainAxis(), scatterPlot.getXAxisLabelFont(), scatterPlot.getXAxisLabelColor(), scatterPlot.getXAxisTickLabelFont(), scatterPlot.getXAxisTickLabelColor(), scatterPlot.getXAxisTickLabelMask(), scatterPlot.getXAxisVerticalTickLabels(), scatterPlot.getXAxisLineColor(), false, (Comparable)this.evaluateExpression(scatterPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(scatterPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)jfreeChart.getXYPlot().getRangeAxis(), scatterPlot.getYAxisLabelFont(), scatterPlot.getYAxisLabelColor(), scatterPlot.getYAxisTickLabelFont(), scatterPlot.getYAxisTickLabelColor(), scatterPlot.getYAxisTickLabelMask(), scatterPlot.getYAxisVerticalTickLabels(), scatterPlot.getYAxisLineColor(), true, (Comparable)this.evaluateExpression(scatterPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(scatterPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createStackedBar3DChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createStackedBarChart3D((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)this.evaluateTextExpression(((JRBar3DPlot)this.getPlot()).getCategoryAxisLabelExpression()), (String)this.evaluateTextExpression(((JRBar3DPlot)this.getPlot()).getValueAxisLabelExpression()), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientationValue().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRBar3DPlot bar3DPlot = (JRBar3DPlot)this.getPlot();
        StackedBarRenderer3D stackedBarRenderer3D = new StackedBarRenderer3D(bar3DPlot.getXOffsetDouble() == null ? 12.0 : bar3DPlot.getXOffsetDouble(), bar3DPlot.getYOffsetDouble() == null ? 8.0 : bar3DPlot.getYOffsetDouble());
        stackedBarRenderer3D.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
        stackedBarRenderer3D.setBaseItemLabelsVisible(bar3DPlot.getShowLabels() == null ? false : bar3DPlot.getShowLabels());
        categoryPlot.setRenderer((CategoryItemRenderer)stackedBarRenderer3D);
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), bar3DPlot.getCategoryAxisLabelFont(), bar3DPlot.getCategoryAxisLabelColor(), bar3DPlot.getCategoryAxisTickLabelFont(), bar3DPlot.getCategoryAxisTickLabelColor(), bar3DPlot.getCategoryAxisTickLabelMask(), bar3DPlot.getCategoryAxisVerticalTickLabels(), bar3DPlot.getCategoryAxisLineColor(), false, (Comparable)this.evaluateExpression(bar3DPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(bar3DPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), bar3DPlot.getValueAxisLabelFont(), bar3DPlot.getValueAxisLabelColor(), bar3DPlot.getValueAxisTickLabelFont(), bar3DPlot.getValueAxisTickLabelColor(), bar3DPlot.getValueAxisTickLabelMask(), bar3DPlot.getValueAxisVerticalTickLabels(), bar3DPlot.getValueAxisLineColor(), true, (Comparable)this.evaluateExpression(bar3DPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(bar3DPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createStackedBarChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createStackedBarChart((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)this.evaluateTextExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression()), (String)this.evaluateTextExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression()), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientationValue().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRBarPlot barPlot = (JRBarPlot)this.getPlot();
        boolean isShowTickMarks = barPlot.getShowTickMarks() == null ? true : barPlot.getShowTickMarks();
        boolean isShowTickLabels = barPlot.getShowTickLabels() == null ? true : barPlot.getShowTickLabels();
        boolean isShowLabels = barPlot.getShowLabels() == null ? false : barPlot.getShowLabels();
        categoryPlot.getDomainAxis().setTickMarksVisible(isShowTickMarks);
        categoryPlot.getDomainAxis().setTickLabelsVisible(isShowTickLabels);
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(isShowTickMarks);
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(isShowTickLabels);
        StackedBarRenderer categoryRenderer = (StackedBarRenderer)categoryPlot.getRenderer();
        categoryRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
        categoryRenderer.setBaseItemLabelsVisible(isShowLabels);
        categoryRenderer.setShadowVisible(false);
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getCategoryAxisVerticalTickLabels(), barPlot.getCategoryAxisLineColor(), false, (Comparable)this.evaluateExpression(barPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(barPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getValueAxisVerticalTickLabels(), barPlot.getValueAxisLineColor(), true, (Comparable)this.evaluateExpression(barPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(barPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createStackedAreaChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createStackedAreaChart((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)this.evaluateTextExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression()), (String)this.evaluateTextExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression()), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientationValue().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        JRAreaPlot areaPlot = (JRAreaPlot)this.getPlot();
        this.configureAxis((Axis)((CategoryPlot)jfreeChart.getPlot()).getDomainAxis(), areaPlot.getCategoryAxisLabelFont(), areaPlot.getCategoryAxisLabelColor(), areaPlot.getCategoryAxisTickLabelFont(), areaPlot.getCategoryAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getCategoryAxisVerticalTickLabels(), areaPlot.getCategoryAxisLineColor(), false, (Comparable)this.evaluateExpression(areaPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(areaPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)((CategoryPlot)jfreeChart.getPlot()).getRangeAxis(), areaPlot.getValueAxisLabelFont(), areaPlot.getValueAxisLabelColor(), areaPlot.getValueAxisTickLabelFont(), areaPlot.getValueAxisTickLabelColor(), areaPlot.getValueAxisTickLabelMask(), areaPlot.getValueAxisVerticalTickLabels(), areaPlot.getValueAxisLineColor(), true, (Comparable)this.evaluateExpression(areaPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(areaPlot.getRangeAxisMaxValueExpression()));
        ((CategoryPlot)jfreeChart.getPlot()).getDomainAxis().setCategoryMargin(0.0);
        return jfreeChart;
    }

    protected JFreeChart createXyAreaChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createXYAreaChart((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)this.evaluateTextExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression()), (String)this.evaluateTextExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression()), (XYDataset)((XYDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientationValue().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        JRAreaPlot areaPlot = (JRAreaPlot)this.getPlot();
        this.configureAxis((Axis)jfreeChart.getXYPlot().getDomainAxis(), areaPlot.getCategoryAxisLabelFont(), areaPlot.getCategoryAxisLabelColor(), areaPlot.getCategoryAxisTickLabelFont(), areaPlot.getCategoryAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getCategoryAxisVerticalTickLabels(), areaPlot.getCategoryAxisLineColor(), false, (Comparable)this.evaluateExpression(areaPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(areaPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)jfreeChart.getXYPlot().getRangeAxis(), areaPlot.getValueAxisLabelFont(), areaPlot.getValueAxisLabelColor(), areaPlot.getValueAxisTickLabelFont(), areaPlot.getValueAxisTickLabelColor(), areaPlot.getValueAxisTickLabelMask(), areaPlot.getValueAxisVerticalTickLabels(), areaPlot.getValueAxisLineColor(), true, (Comparable)this.evaluateExpression(areaPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(areaPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createXYBarChart() throws JRException {
        IntervalXYDataset tmpDataset = (IntervalXYDataset)this.getDataset();
        boolean isDate = true;
        if (this.getChart().getDataset().getDatasetType() == 3) {
            isDate = false;
        }
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createXYBarChart((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)this.evaluateTextExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression()), (boolean)isDate, (String)this.evaluateTextExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression()), (IntervalXYDataset)tmpDataset, (PlotOrientation)this.getPlot().getOrientationValue().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        XYBarRenderer itemRenderer = (XYBarRenderer)xyPlot.getRenderer();
        itemRenderer.setBaseItemLabelGenerator((XYItemLabelGenerator)this.getLabelGenerator());
        itemRenderer.setShadowVisible(false);
        JRBarPlot barPlot = (JRBarPlot)this.getPlot();
        boolean isShowLabels = barPlot.getShowLabels() == null ? false : barPlot.getShowLabels();
        itemRenderer.setBaseItemLabelsVisible(isShowLabels);
        this.configureAxis((Axis)xyPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getCategoryAxisVerticalTickLabels(), barPlot.getCategoryAxisLineColor(), false, (Comparable)this.evaluateExpression(barPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(barPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)xyPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getValueAxisVerticalTickLabels(), barPlot.getValueAxisLineColor(), true, (Comparable)this.evaluateExpression(barPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(barPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createXyLineChart() throws JRException {
        JRLinePlot linePlot = (JRLinePlot)this.getPlot();
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createXYLineChart((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)this.evaluateTextExpression(linePlot.getCategoryAxisLabelExpression()), (String)this.evaluateTextExpression(linePlot.getValueAxisLabelExpression()), (XYDataset)((XYDataset)this.getDataset()), (PlotOrientation)linePlot.getOrientationValue().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        this.configureAxis((Axis)jfreeChart.getXYPlot().getDomainAxis(), linePlot.getCategoryAxisLabelFont(), linePlot.getCategoryAxisLabelColor(), linePlot.getCategoryAxisTickLabelFont(), linePlot.getCategoryAxisTickLabelColor(), linePlot.getCategoryAxisTickLabelMask(), linePlot.getCategoryAxisVerticalTickLabels(), linePlot.getCategoryAxisLineColor(), false, (Comparable)this.evaluateExpression(linePlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(linePlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)jfreeChart.getXYPlot().getRangeAxis(), linePlot.getValueAxisLabelFont(), linePlot.getValueAxisLabelColor(), linePlot.getValueAxisTickLabelFont(), linePlot.getValueAxisTickLabelColor(), linePlot.getValueAxisTickLabelMask(), linePlot.getValueAxisVerticalTickLabels(), linePlot.getValueAxisLineColor(), true, (Comparable)this.evaluateExpression(linePlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(linePlot.getRangeAxisMaxValueExpression()));
        XYLineAndShapeRenderer lineRenderer = (XYLineAndShapeRenderer)jfreeChart.getXYPlot().getRenderer();
        boolean isShowShapes = linePlot.getShowShapes() == null ? true : linePlot.getShowShapes();
        boolean isShowLines = linePlot.getShowLines() == null ? true : linePlot.getShowLines();
        lineRenderer.setBaseShapesVisible(isShowShapes);
        lineRenderer.setBaseLinesVisible(isShowLines);
        return jfreeChart;
    }

    protected JFreeChart createTimeSeriesChart() throws JRException {
        String timeAxisLabel = this.evaluateTextExpression(((JRTimeSeriesPlot)this.getPlot()).getTimeAxisLabelExpression());
        String valueAxisLabel = this.evaluateTextExpression(((JRTimeSeriesPlot)this.getPlot()).getValueAxisLabelExpression());
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createTimeSeriesChart((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)timeAxisLabel, (String)valueAxisLabel, (XYDataset)((TimeSeriesCollection)this.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        JRTimeSeriesPlot timeSeriesPlot = (JRTimeSeriesPlot)this.getPlot();
        XYLineAndShapeRenderer lineRenderer = (XYLineAndShapeRenderer)xyPlot.getRenderer();
        boolean isShowShapes = timeSeriesPlot.getShowShapes() == null ? true : timeSeriesPlot.getShowShapes();
        boolean isShowLines = timeSeriesPlot.getShowLines() == null ? true : timeSeriesPlot.getShowLines();
        lineRenderer.setBaseLinesVisible(isShowLines);
        lineRenderer.setBaseShapesVisible(isShowShapes);
        this.configureAxis((Axis)xyPlot.getDomainAxis(), timeSeriesPlot.getTimeAxisLabelFont(), timeSeriesPlot.getTimeAxisLabelColor(), timeSeriesPlot.getTimeAxisTickLabelFont(), timeSeriesPlot.getTimeAxisTickLabelColor(), timeSeriesPlot.getTimeAxisTickLabelMask(), timeSeriesPlot.getTimeAxisVerticalTickLabels(), timeSeriesPlot.getTimeAxisLineColor(), false, (Comparable)this.evaluateExpression(timeSeriesPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(timeSeriesPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)xyPlot.getRangeAxis(), timeSeriesPlot.getValueAxisLabelFont(), timeSeriesPlot.getValueAxisLabelColor(), timeSeriesPlot.getValueAxisTickLabelFont(), timeSeriesPlot.getValueAxisTickLabelColor(), timeSeriesPlot.getValueAxisTickLabelMask(), timeSeriesPlot.getValueAxisVerticalTickLabels(), timeSeriesPlot.getValueAxisLineColor(), true, (Comparable)this.evaluateExpression(timeSeriesPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(timeSeriesPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createGanttChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createGanttChart((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)this.evaluateTextExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression()), (String)this.evaluateTextExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression()), (IntervalCategoryDataset)((GanttCategoryDataset)this.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRBarPlot barPlot = (JRBarPlot)this.getPlot();
        boolean isShowTickMarks = barPlot.getShowTickMarks() == null ? true : barPlot.getShowTickMarks();
        boolean isShowTickLabels = barPlot.getShowTickLabels() == null ? true : barPlot.getShowTickLabels();
        boolean isShowLabels = barPlot.getShowLabels() == null ? false : barPlot.getShowLabels();
        categoryPlot.getDomainAxis().setTickMarksVisible(isShowTickMarks);
        categoryPlot.getDomainAxis().setTickLabelsVisible(isShowTickLabels);
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getCategoryAxisVerticalTickLabels(), barPlot.getCategoryAxisLineColor(), false, null, null);
        ((DateAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(isShowTickMarks);
        ((DateAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(isShowTickLabels);
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getValueAxisVerticalTickLabels(), barPlot.getValueAxisLineColor(), true, (Comparable)this.evaluateExpression(barPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(barPlot.getRangeAxisMaxValueExpression()));
        GanttRenderer categoryRenderer = (GanttRenderer)categoryPlot.getRenderer();
        categoryRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
        categoryRenderer.setBaseItemLabelsVisible(isShowLabels);
        categoryRenderer.setShadowVisible(false);
        return jfreeChart;
    }

    protected Range convertRange(JRDataRange dataRange) throws JRException {
        if (dataRange == null) {
            return null;
        }
        Number low = (Number)this.evaluateExpression(dataRange.getLowExpression());
        Number high = (Number)this.evaluateExpression(dataRange.getHighExpression());
        return new Range(low != null ? low.doubleValue() : 0.0, high != null ? high.doubleValue() : 100.0);
    }

    protected MeterInterval convertInterval(JRMeterInterval interval) throws JRException {
        String label = interval.getLabel();
        if (label == null) {
            label = "";
        }
        Range range = this.convertRange(interval.getDataRange());
        Color color = interval.getBackgroundColor() == null ? this.getChart().getBackcolor() : interval.getBackgroundColor();
        float[] components = color.getRGBColorComponents(null);
        float alpha = interval.getAlphaDouble() == null ? 1.0f : interval.getAlphaDouble().floatValue();
        Color alphaColor = new Color(components[0], components[1], components[2], alpha);
        return new MeterInterval(label, range, (Paint)alphaColor, null, (Paint)alphaColor);
    }

    protected JFreeChart createMeterChart() throws JRException {
        List<JRMeterInterval> intervals;
        JRMeterPlot jrPlot = (JRMeterPlot)this.getPlot();
        MeterPlot chartPlot = new MeterPlot((ValueDataset)this.getDataset());
        MeterShapeEnum shape = jrPlot.getShapeValue() == null ? MeterShapeEnum.PIE : jrPlot.getShapeValue();
        switch (shape) {
            case CHORD: {
                chartPlot.setDialShape(DialShape.CHORD);
                break;
            }
            case CIRCLE: {
                chartPlot.setDialShape(DialShape.CIRCLE);
                break;
            }
            default: {
                chartPlot.setDialShape(DialShape.PIE);
            }
        }
        chartPlot.setRange(this.convertRange(jrPlot.getDataRange()));
        int meterAngle = jrPlot.getMeterAngleInteger() == null ? 180 : jrPlot.getMeterAngleInteger();
        chartPlot.setMeterAngle(meterAngle);
        String units = jrPlot.getUnits();
        if (units != null && units.length() > 0) {
            chartPlot.setUnits(units);
        }
        if (jrPlot.getTickLabelFont() != null) {
            chartPlot.setTickLabelFont(this.fontUtil.getAwtFont(jrPlot.getTickLabelFont(), this.getLocale()));
        }
        double tickInterval = jrPlot.getTickIntervalDouble() == null ? 10.0 : jrPlot.getTickIntervalDouble();
        chartPlot.setTickSize(tickInterval);
        Color color = jrPlot.getMeterBackgroundColor();
        if (color != null) {
            chartPlot.setDialBackgroundPaint((Paint)color);
        }
        if ((color = jrPlot.getNeedleColor()) != null) {
            chartPlot.setNeedlePaint((Paint)color);
        }
        chartPlot.setTickLabelFormat(NumberFormat.getInstance(this.getLocale()));
        JRValueDisplay display = jrPlot.getValueDisplay();
        if (display != null) {
            if (display.getColor() != null) {
                chartPlot.setValuePaint((Paint)display.getColor());
            }
            if (display.getMask() != null) {
                chartPlot.setTickLabelFormat((NumberFormat)new DecimalFormat(display.getMask(), DecimalFormatSymbols.getInstance(this.getLocale())));
            }
            if (display.getFont() != null) {
                chartPlot.setValueFont(this.fontUtil.getAwtFont(display.getFont(), this.getLocale()));
            }
        }
        if ((color = jrPlot.getTickColor()) != null) {
            chartPlot.setTickPaint((Paint)color);
        }
        if ((intervals = jrPlot.getIntervals()) != null) {
            for (JRMeterInterval interval : intervals) {
                chartPlot.addInterval(this.convertInterval(interval));
            }
        }
        JFreeChart jfreeChart = new JFreeChart(this.evaluateTextExpression(this.getChart().getTitleExpression()), null, (Plot)chartPlot, this.isShowLegend());
        this.configureChart(jfreeChart);
        return jfreeChart;
    }

    protected JFreeChart createThermometerChart() throws JRException {
        JRThermometerPlot jrPlot = (JRThermometerPlot)this.getPlot();
        ThermometerPlot chartPlot = new ThermometerPlot((ValueDataset)this.getDataset());
        ChartUtil chartUtil = ChartUtil.getInstance(this.chartContext.getJasperReportsContext());
        chartPlot.getRangeAxis().setStandardTickUnits(chartUtil.createIntegerTickUnits(this.getLocale()));
        Range range = this.convertRange(jrPlot.getDataRange());
        chartPlot.setLowerBound(range.getLowerBound());
        chartPlot.setUpperBound(range.getUpperBound());
        chartPlot.setUnits(0);
        Color color = jrPlot.getMercuryColor();
        if (color != null) {
            chartPlot.setMercuryPaint((Paint)color);
            chartPlot.setUseSubrangePaint(false);
        }
        chartPlot.setValueFormat(NumberFormat.getNumberInstance(this.getLocale()));
        JRValueDisplay display = jrPlot.getValueDisplay();
        if (display != null) {
            if (display.getColor() != null) {
                chartPlot.setValuePaint((Paint)display.getColor());
            }
            if (display.getMask() != null) {
                chartPlot.setValueFormat((NumberFormat)new DecimalFormat(display.getMask(), DecimalFormatSymbols.getInstance(this.getLocale())));
            }
            if (display.getFont() != null) {
                chartPlot.setValueFont(this.fontUtil.getAwtFont(display.getFont(), this.getLocale()));
            }
        }
        switch (jrPlot.getValueLocationValue()) {
            case NONE: {
                chartPlot.setValueLocation(0);
                break;
            }
            case LEFT: {
                chartPlot.setValueLocation(2);
                break;
            }
            case RIGHT: {
                chartPlot.setValueLocation(1);
                break;
            }
            default: {
                chartPlot.setValueLocation(3);
            }
        }
        range = this.convertRange(jrPlot.getLowRange());
        if (range != null) {
            chartPlot.setSubrangeInfo(2, range.getLowerBound(), range.getUpperBound());
        }
        if ((range = this.convertRange(jrPlot.getMediumRange())) != null) {
            chartPlot.setSubrangeInfo(1, range.getLowerBound(), range.getUpperBound());
        }
        if ((range = this.convertRange(jrPlot.getHighRange())) != null) {
            chartPlot.setSubrangeInfo(0, range.getLowerBound(), range.getUpperBound());
        }
        JFreeChart jfreeChart = new JFreeChart((Plot)chartPlot);
        this.configureChart(jfreeChart);
        return jfreeChart;
    }

    protected JFreeChart createDialChart() throws JRException {
        String label;
        JRValueDisplay display;
        String displayVisibility;
        JRMeterPlot jrPlot = (JRMeterPlot)this.getPlot();
        DialPlot dialPlot = new DialPlot();
        dialPlot.setDataset((ValueDataset)this.getDataset());
        StandardDialFrame dialFrame = new StandardDialFrame();
        dialPlot.setDialFrame((DialFrame)dialFrame);
        DialBackground db = new DialBackground((Paint)jrPlot.getBackcolor());
        dialPlot.setBackground((DialLayer)db);
        Range range = this.convertRange(jrPlot.getDataRange());
        int tickCount = jrPlot.getTickCount() != null && jrPlot.getTickCount() > 1 ? jrPlot.getTickCount() : 7;
        StandardDialScale scale = new StandardDialScale(range.getLowerBound(), range.getUpperBound(), 225.0, -270.0, (range.getUpperBound() - range.getLowerBound()) / (double)(tickCount - 1), 15);
        scale.setTickRadius(0.9);
        scale.setTickLabelOffset(0.16);
        if (jrPlot.getTickLabelFont() != null) {
            scale.setTickLabelFont(this.fontUtil.getAwtFont(jrPlot.getTickLabelFont(), this.getLocale()));
        }
        scale.setMajorTickStroke((Stroke)new BasicStroke(1.0f));
        scale.setMinorTickStroke((Stroke)new BasicStroke(0.3f));
        scale.setMajorTickPaint((Paint)jrPlot.getTickColor());
        scale.setMinorTickPaint((Paint)jrPlot.getTickColor());
        scale.setTickLabelsVisible(true);
        scale.setFirstTickLabelVisible(true);
        scale.setTickLabelFormatter((NumberFormat)new DecimalFormat("0.0", DecimalFormatSymbols.getInstance(this.getLocale())));
        dialPlot.addScale(0, (DialScale)scale);
        List<JRMeterInterval> intervals = jrPlot.getIntervals();
        if (intervals != null && intervals.size() > 0) {
            int size = Math.min(3, intervals.size());
            int colorStep = 0;
            if (size > 0) {
                colorStep = 255 / size;
            }
            for (int i2 = 0; i2 < size; ++i2) {
                JRMeterInterval interval = intervals.get(i2);
                Range intervalRange = this.convertRange(interval.getDataRange());
                Color color = new Color(255 - colorStep * i2, 0 + colorStep * i2, 0);
                StandardDialRange dialRange = new StandardDialRange(intervalRange.getLowerBound(), intervalRange.getUpperBound(), (Paint)(interval.getBackgroundColor() == null ? color : interval.getBackgroundColor()));
                dialRange.setInnerRadius(0.41);
                dialRange.setOuterRadius(0.41);
                dialPlot.addLayer((DialLayer)dialRange);
            }
        }
        String string = displayVisibility = (display = jrPlot.getValueDisplay()) != null && this.getChart().hasProperties() ? this.getChart().getPropertiesMap().getProperty(PROPERTY_DIAL_VALUE_DISPLAY_VISIBLE) : "false";
        if (Boolean.valueOf(displayVisibility).booleanValue()) {
            String pattern;
            DialValueIndicator dvi = new DialValueIndicator(0);
            dvi.setBackgroundPaint((Paint)TRANSPARENT_PAINT);
            dvi.setOutlinePaint((Paint)TRANSPARENT_PAINT);
            dvi.setPaint((Paint)Color.WHITE);
            String string2 = pattern = display.getMask() != null ? display.getMask() : "#,##0.####";
            if (pattern != null) {
                dvi.setNumberFormat((NumberFormat)new DecimalFormat(pattern, DecimalFormatSymbols.getInstance(this.getLocale())));
            }
            dvi.setRadius(0.15);
            dvi.setValueAnchor(RectangleAnchor.CENTER);
            dvi.setTextAnchor(TextAnchor.CENTER);
            dialPlot.addLayer((DialLayer)dvi);
        }
        String string3 = label = this.getChart().hasProperties() ? this.getChart().getPropertiesMap().getProperty(PROPERTY_DIAL_LABEL) : null;
        if (label != null) {
            JRFont displayFont = display == null ? null : display.getFont();
            String[] textLines = label.split("\\n");
            for (int i3 = 0; i3 < textLines.length; ++i3) {
                DialTextAnnotation dialAnnotation = new DialTextAnnotation(textLines[i3]);
                if (displayFont != null) {
                    dialAnnotation.setFont(this.fontUtil.getAwtFont(displayFont, this.getLocale()));
                }
                if (display != null && display.getColor() != null) {
                    dialAnnotation.setPaint((Paint)jrPlot.getValueDisplay().getColor());
                }
                dialAnnotation.setRadius(Math.sin(0.7853981633974483) + (double)i3 / 10.0);
                dialAnnotation.setAnchor(TextAnchor.CENTER);
                dialPlot.addLayer((DialLayer)dialAnnotation);
            }
        }
        DialPointer.Pointer needle = new DialPointer.Pointer();
        needle.setVisible(true);
        needle.setRadius(0.91);
        dialPlot.addLayer((DialLayer)needle);
        DialCap cap = new DialCap();
        cap.setRadius(0.05);
        cap.setFillPaint((Paint)Color.DARK_GRAY);
        cap.setOutlinePaint((Paint)Color.GRAY);
        cap.setOutlineStroke((Stroke)new BasicStroke(0.5f));
        dialPlot.setCap((DialLayer)cap);
        JFreeChart jfreeChart = new JFreeChart(this.evaluateTextExpression(this.getChart().getTitleExpression()), null, (Plot)dialPlot, this.isShowLegend());
        this.configureChart(jfreeChart);
        return jfreeChart;
    }

    protected AxisLocation getChartAxisLocation(JRChartAxis chartAxis) {
        return chartAxis.getPositionValue() != null && chartAxis.getPositionValue() == AxisPositionEnum.RIGHT_OR_BOTTOM ? AxisLocation.BOTTOM_OR_RIGHT : AxisLocation.TOP_OR_LEFT;
    }

    protected void setAxisBounds(Axis axis, boolean isRangeAxis, Comparable<?> axisMinValue, Comparable<?> axisMaxValue) {
        if (axis instanceof ValueAxis) {
            if (axis instanceof DateAxis) {
                if (axisMinValue != null) {
                    ((DateAxis)axis).setMinimumDate((Date)axisMinValue);
                }
                if (axisMaxValue != null) {
                    ((DateAxis)axis).setMaximumDate((Date)axisMaxValue);
                }
            } else {
                if (axisMinValue != null) {
                    ((ValueAxis)axis).setLowerBound(((Number)((Object)axisMinValue)).doubleValue());
                }
                if (axisMaxValue != null) {
                    ((ValueAxis)axis).setUpperBound(((Number)((Object)axisMaxValue)).doubleValue());
                }
            }
            this.calculateTickUnits(axis, isRangeAxis);
        }
    }

    protected void calculateTickUnits(Axis axis, boolean isRangeAxis) {
        Integer tickCount = null;
        Number tickInterval = null;
        boolean axisIntegerUnit = false;
        if (this.getChart().hasProperties()) {
            String tickCountProperty = null;
            String tickIntervalProperty = null;
            String axisIntegerUnitProperty = null;
            if (isRangeAxis) {
                tickCountProperty = this.getChart().getPropertiesMap().getProperty(PROPERTY_RANGE_AXIS_TICK_COUNT);
                tickIntervalProperty = this.getChart().getPropertiesMap().getProperty(PROPERTY_RANGE_AXIS_TICK_INTERVAL);
                axisIntegerUnitProperty = this.getChart().getPropertiesMap().getProperty(PROPERTY_RANGE_AXIS_INTEGER_UNIT);
            } else {
                tickCountProperty = this.getChart().getPropertiesMap().getProperty(PROPERTY_DOMAIN_AXIS_TICK_COUNT);
                tickIntervalProperty = this.getChart().getPropertiesMap().getProperty(PROPERTY_DOMAIN_AXIS_TICK_INTERVAL);
                axisIntegerUnitProperty = this.getChart().getPropertiesMap().getProperty(PROPERTY_DOMAIN_AXIS_INTEGER_UNIT);
            }
            if (tickCountProperty != null && tickCountProperty.trim().length() > 0) {
                tickCount = Integer.valueOf(tickCountProperty);
            }
            if (tickIntervalProperty != null && tickIntervalProperty.trim().length() > 0) {
                tickInterval = Double.valueOf(tickIntervalProperty);
            }
            if (axisIntegerUnitProperty != null && axisIntegerUnitProperty.trim().length() > 0) {
                axisIntegerUnit = Boolean.valueOf(axisIntegerUnitProperty);
            }
        }
        if (axis instanceof NumberAxis) {
            ChartUtil chartUtil;
            NumberAxis numberAxis = (NumberAxis)axis;
            int axisRange = (int)numberAxis.getRange().getLength();
            if (axisIntegerUnit) {
                chartUtil = ChartUtil.getInstance(this.chartContext.getJasperReportsContext());
                numberAxis.setStandardTickUnits(chartUtil.createIntegerTickUnits(this.getLocale()));
                chartUtil.setAutoTickUnit(numberAxis);
            } else if (axisRange > 0) {
                if (tickInterval != null) {
                    if (numberAxis.getNumberFormatOverride() != null) {
                        numberAxis.setTickUnit(new NumberTickUnit(tickInterval.doubleValue(), numberAxis.getNumberFormatOverride()));
                    } else {
                        numberAxis.setTickUnit(new NumberTickUnit(tickInterval.doubleValue(), NumberFormat.getNumberInstance(this.getLocale())));
                    }
                } else if (tickCount != null) {
                    if (numberAxis.getNumberFormatOverride() != null) {
                        numberAxis.setTickUnit(new NumberTickUnit((double)(axisRange / tickCount), numberAxis.getNumberFormatOverride()));
                    } else {
                        numberAxis.setTickUnit(new NumberTickUnit((double)(axisRange / tickCount), NumberFormat.getNumberInstance(this.getLocale())));
                    }
                } else {
                    chartUtil = ChartUtil.getInstance(this.chartContext.getJasperReportsContext());
                    numberAxis.setStandardTickUnits(chartUtil.createStandardTickUnits(this.getLocale()));
                    chartUtil.setAutoTickUnit(numberAxis);
                }
            }
        }
    }

    private double getLabelRotation() {
        return this.getPlot().getLabelRotationDouble() == null ? 0.0 : this.getPlot().getLabelRotationDouble();
    }

    private static RectangleEdge getEdge(EdgeEnum position, RectangleEdge defaultPosition) {
        RectangleEdge edge = defaultPosition;
        if (position != null) {
            switch (position) {
                case TOP: {
                    edge = RectangleEdge.TOP;
                    break;
                }
                case BOTTOM: {
                    edge = RectangleEdge.BOTTOM;
                    break;
                }
                case LEFT: {
                    edge = RectangleEdge.LEFT;
                    break;
                }
                case RIGHT: {
                    edge = RectangleEdge.RIGHT;
                }
            }
        }
        return edge;
    }

    protected boolean isShowLegend() {
        return this.getChart().getShowLegend() == null ? true : this.getChart().getShowLegend();
    }
}

