/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fill.JRAbstractLRUVirtualizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRFileVirtualizer
extends JRAbstractLRUVirtualizer {
    private static final Log log = LogFactory.getLog(JRFileVirtualizer.class);
    public static final String PROPERTY_TEMP_FILES_SET_DELETE_ON_EXIT = "net.sf.jasperreports.virtualizer.files.delete.on.exit";
    private final JasperReportsContext jasperReportsContext;
    private final String directory;

    public JRFileVirtualizer(int maxSize) {
        this(DefaultJasperReportsContext.getInstance(), maxSize, null);
    }

    public JRFileVirtualizer(int maxSize, String directory) {
        this(DefaultJasperReportsContext.getInstance(), maxSize, directory);
    }

    public JRFileVirtualizer(JasperReportsContext jasperReportsContext, int maxSize, String directory) {
        super(maxSize);
        this.jasperReportsContext = jasperReportsContext;
        this.directory = directory;
    }

    private String makeFilename(JRVirtualizable o2) {
        String uid = o2.getUID();
        return "virt" + uid;
    }

    private String makeFilename(String virtualId) {
        return "virt" + virtualId;
    }

    @Override
    protected void pageOut(JRVirtualizable o2) throws IOException {
        String filename = this.makeFilename(o2);
        File file = new File(this.directory, filename);
        if (file.createNewFile()) {
            boolean deleteOnExit = JRPropertiesUtil.getInstance(this.jasperReportsContext).getBooleanProperty(PROPERTY_TEMP_FILES_SET_DELETE_ON_EXIT);
            if (deleteOnExit) {
                file.deleteOnExit();
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(file);
                BufferedOutputStream bufferedOut = new BufferedOutputStream(fos);
                this.writeData(o2, bufferedOut);
            }
            catch (FileNotFoundException e2) {
                log.error("Error virtualizing object", e2);
                throw new JRRuntimeException(e2);
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
        } else if (!this.isReadOnly(o2)) {
            throw new IllegalStateException("Cannot virtualize data because the file \"" + filename + "\" already exists.");
        }
    }

    @Override
    protected void pageIn(JRVirtualizable o2) throws IOException {
        String filename = this.makeFilename(o2);
        File file = new File(this.directory, filename);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            BufferedInputStream bufferedIn = new BufferedInputStream(fis);
            this.readData(o2, bufferedIn);
        }
        catch (FileNotFoundException e2) {
            log.error("Error devirtualizing object", e2);
            throw new JRRuntimeException(e2);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        if (!this.isReadOnly(o2)) {
            file.delete();
        }
    }

    @Override
    protected void dispose(String virtualId) {
        String filename = this.makeFilename(virtualId);
        File file = new File(this.directory, filename);
        file.delete();
    }

    @Override
    public synchronized void cleanup() {
        this.disposeAll();
        this.reset();
    }
}

