/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.fill.JRAbstractLRUVirtualizer;

public class JRGzipVirtualizer
extends JRAbstractLRUVirtualizer {
    public static final String EXCEPTION_MESSAGE_KEY_NO_DATA_FOUND = "fill.virtualizer.no.data.found";
    private final Map<String, byte[]> zippedData = Collections.synchronizedMap(new HashMap());

    public JRGzipVirtualizer(int maxSize) {
        super(maxSize);
    }

    @Override
    protected void dispose(String virtualId) {
        this.zippedData.remove(virtualId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void pageOut(JRVirtualizable o2) throws IOException {
        if (!this.zippedData.containsKey(o2.getUID())) {
            DeflaterOutputStream gos = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(3000);
                gos = new GZIPOutputStream(baos);
                this.writeData(o2, gos);
                ((GZIPOutputStream)gos).finish();
                gos.flush();
                byte[] data = baos.toByteArray();
                this.zippedData.put(o2.getUID(), data);
            }
            finally {
                if (gos != null) {
                    gos.close();
                }
            }
        } else if (!this.isReadOnly(o2)) {
            throw new IllegalStateException("Cannot virtualize data because the data for object UID \"" + o2.getUID() + "\" already exists.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void pageIn(JRVirtualizable o2) throws IOException {
        GZIPInputStream gis = null;
        try {
            byte[] data = this.zippedData.get(o2.getUID());
            if (data == null) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_NO_DATA_FOUND, new Object[]{o2.getUID()});
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            gis = new GZIPInputStream(bais);
            this.readData(o2, gis);
        }
        finally {
            if (gis != null) {
                gis.close();
            }
        }
        if (!this.isReadOnly(o2)) {
            this.zippedData.remove(o2.getUID());
        }
    }

    @Override
    public void cleanup() {
        this.zippedData.clear();
        this.reset();
    }
}

