/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.extensions;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.extensions.ExtensionsRegistry;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ListableBeanFactory;

public class SpringExtensionsRegistry
implements ExtensionsRegistry {
    private static final Log log = LogFactory.getLog(SpringExtensionsRegistry.class);
    private final ListableBeanFactory beanFactory;
    private final ReferenceMap extensionBeanNamesCache = new ReferenceMap(2, 0);

    public SpringExtensionsRegistry(ListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public <T> List<T> getExtensions(Class<T> extensionType) {
        String[] beanNames = this.getExtensionBeanNames(extensionType);
        ArrayList<Object> beans = new ArrayList<Object>(beanNames.length);
        for (int i2 = 0; i2 < beanNames.length; ++i2) {
            String name = beanNames[i2];
            if (log.isDebugEnabled()) {
                log.debug("Getting bean " + name + " as extension of type " + extensionType.getName());
            }
            Object bean = this.beanFactory.getBean(name, extensionType);
            beans.add(bean);
        }
        return beans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getExtensionBeanNames(Class<?> extensionType) {
        ReferenceMap referenceMap = this.extensionBeanNamesCache;
        synchronized (referenceMap) {
            String[] beanNames = (String[])this.extensionBeanNamesCache.get(extensionType);
            if (beanNames == null) {
                beanNames = this.findExtensionBeanNames(extensionType);
                this.extensionBeanNamesCache.put(extensionType, beanNames);
            }
            return beanNames;
        }
    }

    protected String[] findExtensionBeanNames(Class<?> extensionType) {
        String[] beanNames = this.beanFactory.getBeanNamesForType(extensionType);
        if (log.isDebugEnabled()) {
            log.debug("Found " + beanNames.length + " beans for extension type " + extensionType);
        }
        return beanNames;
    }
}

