/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.functions;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRClassLoader;

public class FunctionsBundle {
    private List<Class<?>> functionClasses = new ArrayList();

    public FunctionsBundle(List<String> functionClassNames) {
        for (String className : functionClassNames) {
            this.addFunctionClass(className);
        }
    }

    public FunctionsBundle() {
    }

    public void addFunctionClass(Class<?> clazz) {
        this.functionClasses.add(clazz);
    }

    public void addFunctionClass(String className) {
        try {
            Class<?> clazz = JRClassLoader.loadClassForName(className);
            this.addFunctionClass(clazz);
        }
        catch (ClassNotFoundException e2) {
            throw new JRRuntimeException(e2);
        }
    }

    public List<Class<?>> getFunctionClasses() {
        return this.functionClasses;
    }

    public void setFunctionClasses(List<Class<?>> functionClasses) {
        this.functionClasses = functionClasses;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FunctionsBundle && this.functionClasses != null) {
            return this.functionClasses.equals(((FunctionsBundle)obj).getFunctionClasses());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.functionClasses != null) {
            return this.functionClasses.hashCode();
        }
        return super.hashCode();
    }
}

