/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.actions;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRElementsVisitor;
import net.sf.jasperreports.engine.util.MessageProvider;
import net.sf.jasperreports.engine.util.MessageUtil;
import net.sf.jasperreports.engine.util.UniformElementVisitor;
import net.sf.jasperreports.repo.JasperDesignCache;
import net.sf.jasperreports.repo.JasperDesignReportResource;
import net.sf.jasperreports.web.actions.Action;
import net.sf.jasperreports.web.actions.ActionException;
import net.sf.jasperreports.web.commands.CommandStack;
import net.sf.jasperreports.web.commands.CommandTarget;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="actionName")
public abstract class AbstractAction
implements Action {
    public static final String PARAM_COMMAND_STACK = "net.sf.jasperreports.command.stack";
    public static final String ERR_CONCAT_STRING = "<#_#>";
    private JasperReportsContext jasperReportsContext;
    private ReportContext reportContext;
    private CommandStack commandStack;
    protected ActionErrors errors;

    public String getMessagesBundle() {
        return "net.sf.jasperreports.web.actions.messages";
    }

    public void init(JasperReportsContext jasperReportsContext, ReportContext reportContext) {
        this.jasperReportsContext = jasperReportsContext;
        this.reportContext = reportContext;
        this.commandStack = (CommandStack)reportContext.getParameterValue(PARAM_COMMAND_STACK);
        if (this.commandStack == null) {
            this.commandStack = new CommandStack();
            reportContext.setParameterValue(PARAM_COMMAND_STACK, this.commandStack);
        }
        this.errors = new ActionErrors(MessageUtil.getInstance(jasperReportsContext).getMessageProvider(this.getMessagesBundle()), (Locale)reportContext.getParameterValue("REPORT_LOCALE"));
    }

    public JasperReportsContext getJasperReportsContext() {
        return this.jasperReportsContext;
    }

    public ReportContext getReportContext() {
        return this.reportContext;
    }

    @Override
    public void run() throws ActionException {
        this.performAction();
    }

    public CommandStack getCommandStack() {
        return this.commandStack;
    }

    public void setCommandStack(CommandStack commandStack) {
        this.commandStack = commandStack;
    }

    public abstract void performAction() throws ActionException;

    public CommandTarget getCommandTarget(UUID uuid) {
        return this.getCommandTarget(uuid, JRDesignComponentElement.class);
    }

    public CommandTarget getCommandTarget(final UUID uuid, final Class<? extends JRDesignElement> elementType) {
        JasperDesignCache cache = JasperDesignCache.getInstance(this.getJasperReportsContext(), this.getReportContext());
        Map<String, JasperDesignReportResource> cachedResources = cache.getCachedResources();
        Set<String> uris = cachedResources.keySet();
        for (String uri : uris) {
            final CommandTarget target = new CommandTarget();
            target.setUri(uri);
            JasperDesign jasperDesign = cache.getJasperDesign(uri);
            JRElementsVisitor.visitReport(jasperDesign, new UniformElementVisitor(){
                private boolean found = false;

                @Override
                public void visitElementGroup(JRElementGroup elementGroup) {
                }

                @Override
                protected void visitElement(JRElement element) {
                    if (!this.found && elementType.isInstance(element) && uuid.equals(element.getUUID())) {
                        target.setIdentifiable(element);
                        this.found = true;
                    }
                }
            });
            if (target.getIdentifiable() == null) continue;
            return target;
        }
        return null;
    }

    public NumberFormat createNumberFormat(String pattern, Locale locale) {
        NumberFormat format = null;
        format = locale == null ? NumberFormat.getNumberInstance() : NumberFormat.getNumberInstance(locale);
        if (pattern != null && pattern.trim().length() > 0 && format instanceof DecimalFormat) {
            ((DecimalFormat)format).applyPattern(pattern);
        }
        return format;
    }

    @Override
    public boolean requiresRefill() {
        return true;
    }

    public static class ActionErrors {
        private MessageProvider messageProvider;
        private Locale locale;
        private List<String> errorMessages;

        public ActionErrors(MessageProvider messageProvider, Locale locale) {
            this.messageProvider = messageProvider;
            this.locale = locale;
            this.errorMessages = new ArrayList<String>();
        }

        public void add(String messageKey, Object ... args) {
            this.errorMessages.add(this.messageProvider.getMessage(messageKey, args, this.locale));
        }

        public void add(String messageKey) {
            this.add(messageKey, null);
        }

        public void addAndThrow(String messageKey, Object ... args) throws ActionException {
            this.errorMessages.add(this.messageProvider.getMessage(messageKey, args, this.locale));
            this.throwAll();
        }

        public void addAndThrow(String messageKey) throws ActionException {
            this.addAndThrow(messageKey, null);
        }

        public boolean isEmpty() {
            return this.errorMessages.size() == 0;
        }

        public void throwAll() throws ActionException {
            if (!this.errorMessages.isEmpty()) {
                StringBuffer errBuff = new StringBuffer();
                int ln = this.errorMessages.size();
                for (int i2 = 0; i2 < ln; ++i2) {
                    String errMsg = this.errorMessages.get(i2);
                    errBuff.append(errMsg);
                    if (i2 >= ln - 1) continue;
                    errBuff.append(AbstractAction.ERR_CONCAT_STRING);
                }
                throw new ActionException(errBuff.toString());
            }
        }
    }
}

